/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.calculated.dependencies;

import de.elpro.ewms.core.variable.calculated.dependencies.DependencyKeyType;

public class DependencyKey<T> {
    private final DependencyKeyType type;
    private final T id;

    DependencyKey(DependencyKeyType type, T id) {
        this.type = type;
        this.id = id;
    }

    public DependencyKeyType getType() {
        return this.type;
    }

    public Object getId() {
        return this.id;
    }

    public String toString() {
        return this.id != null ? String.format("[%s: %s]", this.type.name(), this.id) : String.format("[%s]", this.type.name());
    }

    public String getName() {
        switch (this.type) {
            case LowerLimit: 
            case UpperLimit: 
            case Link: {
                return this.type.name();
            }
            case ExplicitDependency: {
                return (String)this.id;
            }
            case VariableReference: 
            case Characteristic2D: {
                return this.id.toString();
            }
            case ObjectProperty: {
                return this.id.toString();
            }
        }
        return "";
    }

    public int hashCode() {
        return this.type.hashCode() * 13 + (this.id == null ? 0 : this.id.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DependencyKey) {
            DependencyKey pair = (DependencyKey)o;
            if (this.type != pair.type) {
                return false;
            }
            return !(this.id != null ? !this.id.equals(pair.id) : pair.id != null);
        }
        return false;
    }
}

