/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.snapshot;

import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.snapshot.VariableInstanceSnapshot;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_variables_variableinstance_snapshot_group")
@Access(value=AccessType.PROPERTY)
public class VariableInstanceSnapshotGroup
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "variable/instance/snapshot_group";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<User> owner = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final ObjectProperty<Instant> timestamp = new SimpleObjectProperty();
    private final ObjectProperty<Raster> baseRaster = new SimpleObjectProperty();
    private final ObjectProperty<Instant> valuesDataFrom = new SimpleObjectProperty();
    private final ObjectProperty<Instant> valuesDataTo = new SimpleObjectProperty();
    private final IntegerProperty snapshotDataSize = new SimpleIntegerProperty(0);
    private final BooleanProperty isPublic = new SimpleBooleanProperty();
    private List<VariableInstanceSnapshot> snapshots = new LinkedList<VariableInstanceSnapshot>();

    public VariableInstanceSnapshotGroup() {
    }

    public VariableInstanceSnapshotGroup(int id) {
        this.setId(id);
    }

    public ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_variables_variableinstance_snapshot_group_sequence")
    @SequenceGenerator(name="ewms_variables_variableinstance_snapshot_group_sequence", sequenceName="ewms_variables_variableinstance_snapshot_group_sequence")
    public Integer getId() {
        return (Integer)this.idProperty().get();
    }

    void setId(Integer id) {
        this.idProperty().set((Object)id);
    }

    public ObjectProperty<User> ownerProperty() {
        return this.owner;
    }

    @ManyToOne
    @JoinColumn(name="owner", nullable=false)
    public User getOwner() {
        return (User)this.ownerProperty().get();
    }

    public void setOwner(User owner) {
        this.ownerProperty().set((Object)owner);
    }

    public ObjectProperty<Instant> timestampProperty() {
        return this.timestamp;
    }

    public Instant getTimestamp() {
        return (Instant)this.timestampProperty().get();
    }

    public void setTimestamp(Instant timestamp) {
        this.timestampProperty().set((Object)timestamp);
    }

    public ObjectProperty<Raster> baseRasterProperty() {
        return this.baseRaster;
    }

    @Column(name="base_raster", nullable=false)
    public Raster getBaseRaster() {
        return (Raster)((Object)this.baseRasterProperty().get());
    }

    public void setBaseRaster(Raster baseRaster) {
        this.baseRasterProperty().set((Object)baseRaster);
    }

    public ObjectProperty<Instant> valuesDataFromProperty() {
        return this.valuesDataFrom;
    }

    @Column(name="values_data_from", nullable=false)
    public Instant getValuesDataFrom() {
        return (Instant)this.valuesDataFromProperty().get();
    }

    public void setValuesDataFrom(Instant valuesDataFrom) {
        this.valuesDataFromProperty().set((Object)valuesDataFrom);
    }

    public ObjectProperty<Instant> valuesDataToProperty() {
        return this.valuesDataTo;
    }

    @Column(name="values_data_to", nullable=false)
    public Instant getValuesDataTo() {
        return (Instant)this.valuesDataToProperty().get();
    }

    public void setValuesDataTo(Instant valuesDataTo) {
        this.valuesDataToProperty().set((Object)valuesDataTo);
    }

    public IntegerProperty snapshotDataSizeProperty() {
        return this.snapshotDataSize;
    }

    @Column(name="snapshot_data_size")
    public int getSnapshotDataSize() {
        return this.snapshotDataSizeProperty().get();
    }

    public void setSnapshotDataSize(int snapshotDataSize) {
        this.snapshotDataSizeProperty().set(snapshotDataSize);
    }

    @Transient
    public BooleanProperty isPublicProperty() {
        return this.isPublic;
    }

    @Column(name="is_public")
    public boolean isPublic() {
        return this.isPublicProperty().get();
    }

    public void setPublic(boolean isPublic) {
        this.isPublicProperty().set(isPublic);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="name", columnDefinition="TEXT")
    public String getName() {
        return (String)this.nameProperty().get();
    }

    @Transient
    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    @OneToMany(mappedBy="snapshotGroup")
    public List<VariableInstanceSnapshot> getSnapshots() {
        return this.snapshots;
    }

    protected void setSnapshots(List<VariableInstanceSnapshot> snapshots) {
        this.snapshots = snapshots;
    }

    public String toString() {
        return this.getLocalName();
    }
}

