/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ui.formats.TimeFormatType;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;

public class ArchiveValue
implements IStoredVarValue {
    public static final int BYTES = 33;
    private long startTimestamp;
    private long endTimestamp;
    private double value;
    private double quality;
    private Plausibility plausibility;

    public ArchiveValue(long startTimestamp, long endTimestamp, double value, double quality) {
        this(startTimestamp, endTimestamp, value, quality, Plausibility.Ok);
    }

    public ArchiveValue(long startTimestamp, long endTimestamp, double value, double quality, Plausibility plausibility) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.value = value;
        this.quality = quality;
        this.plausibility = plausibility;
    }

    @Override
    public IVarValue.IVarValueType getType() {
        return IVarValue.IVarValueType.ArchiveValue;
    }

    @Override
    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getQuality() {
        return this.quality;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Plausibility getPlausibility() {
        return this.plausibility;
    }

    @Override
    public void changePlausibility(Plausibility plausibility) {
        this.plausibility = plausibility;
    }

    @Override
    public ValueSource getValueSource() {
        return ValueSource.Archive;
    }

    @Override
    public boolean metadataEqualWithTimeOffet(IVarValue varValue, long offset) {
        if (ArchiveValue.class != varValue.getClass()) {
            return false;
        }
        ArchiveValue av = (ArchiveValue)varValue;
        return this.quality == av.getQuality() && this.plausibility == av.plausibility && this.startTimestamp + offset == av.startTimestamp && this.endTimestamp + offset == av.endTimestamp;
    }

    @Override
    public IStoredVarValue copy(long startTimestamp, long endTimestamp, double value, double quality, Plausibility plausibility) {
        return new ArchiveValue(startTimestamp, endTimestamp, value, quality, plausibility);
    }

    @Override
    public ArchiveValue copyWithTimeShift(double value, long timeShift) {
        return new ArchiveValue(this.startTimestamp + timeShift, this.endTimestamp + timeShift, value, Double.isFinite(value) ? this.quality : 0.0, this.plausibility);
    }

    @Override
    public IVarValue copyWithPlausibility(Plausibility plausibility) {
        return new ArchiveValue(this.startTimestamp, this.endTimestamp, this.value, Double.isFinite(this.value) ? this.quality : 0.0, plausibility);
    }

    public String toString() {
        return String.format("%s-%s %f", TimeFormatType.DateTimeHMsMs.format((TemporalAccessor)LocalDateTime.ofInstant(Instant.ofEpochMilli(this.startTimestamp), ZoneOffset.systemDefault())), TimeFormatType.DateTimeHMsMs.format((TemporalAccessor)LocalDateTime.ofInstant(Instant.ofEpochMilli(this.endTimestamp), ZoneOffset.systemDefault())), this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IVarValue)) {
            return false;
        }
        if (this.getType() != ((IVarValue)obj).getType()) {
            return false;
        }
        ArchiveValue other = (ArchiveValue)obj;
        return this.startTimestamp == other.startTimestamp && this.endTimestamp == other.endTimestamp && this.equalValue(other) && this.quality == other.quality && this.plausibility == other.plausibility;
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.putLong(this.startTimestamp);
        buffer.putLong(this.endTimestamp);
        buffer.putDouble(this.value);
        buffer.putDouble(this.quality);
        buffer.put((byte)this.plausibility.ordinal());
    }

    public static ArchiveValue read(ByteBuffer buffer) {
        return new ArchiveValue(buffer.getLong(), buffer.getLong(), buffer.getDouble(), buffer.getDouble(), Plausibility.values()[buffer.get()]);
    }
}

