/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import java.util.Iterator;

public class FastIVarValuesArrayIterable
implements Iterable<IVarValue[]> {
    private final IVarValuesCollection[] array;
    private final int minSize;

    public FastIVarValuesArrayIterable(IVarValuesCollection ... array) {
        if (array.length == 0) {
            throw new IllegalArgumentException();
        }
        Integer size = null;
        IVarValuesCollection[] iVarValuesCollectionArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IVarValuesCollection c = iVarValuesCollectionArray[n2];
            if (c != null) {
                size = size == null ? c.size() : Math.min(size, c.size());
            }
            ++n2;
        }
        if (size == null) {
            throw new IllegalStateException("No min size");
        }
        this.minSize = size;
        this.array = array;
    }

    @Override
    public Iterator<IVarValue[]> iterator() {
        return new IVarValuesCollectionArrayIterator();
    }

    private final class IVarValuesCollectionArrayIterator
    implements Iterator<IVarValue[]> {
        private final Iterator<IVarValue>[] iterators;
        private final Iterator<IVarValue> firstAvailableIterator;
        private final IVarValue[] next;
        private int pos;

        public IVarValuesCollectionArrayIterator() {
            this.next = new IVarValue[FastIVarValuesArrayIterable.this.array.length];
            this.pos = 0;
            this.iterators = new Iterator[FastIVarValuesArrayIterable.this.array.length];
            Iterator<IVarValue> firstIterator = null;
            int i = 0;
            while (i < FastIVarValuesArrayIterable.this.array.length) {
                if (FastIVarValuesArrayIterable.this.array[i] != null) {
                    this.iterators[i] = FastIVarValuesArrayIterable.this.array[i].iterator();
                    if (firstIterator == null) {
                        firstIterator = this.iterators[i];
                    }
                }
                ++i;
            }
            this.firstAvailableIterator = firstIterator;
        }

        @Override
        public boolean hasNext() {
            return this.pos < FastIVarValuesArrayIterable.this.minSize && this.firstAvailableIterator != null && this.firstAvailableIterator.hasNext();
        }

        @Override
        public IVarValue[] next() {
            int i = 0;
            while (i < FastIVarValuesArrayIterable.this.array.length) {
                if (this.iterators[i] != null) {
                    this.next[i] = this.iterators[i].next();
                }
                ++i;
            }
            ++this.pos;
            return this.next;
        }
    }
}

