/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GetValuesRequest {
    private final RawValuesViewType viewType;
    private final Integer viewIndex;
    private final Long from;
    private final Long to;
    private final ComplexRaster raster;
    private final List<VarValuesRequestInstance> instances = new ArrayList<VarValuesRequestInstance>();

    public GetValuesRequest(RawValuesViewType viewType, Integer viewIndex, Instant from, Instant to, ComplexRaster raster) {
        this(viewType, viewIndex, from != null ? Long.valueOf(from.toEpochMilli()) : null, to != null ? Long.valueOf(to.toEpochMilli()) : null, raster);
    }

    public GetValuesRequest(RawValuesViewType viewType, Integer viewIndex, Long from, Long to, ComplexRaster raster) {
        if (viewType == null) {
            throw new IllegalArgumentException();
        }
        this.viewType = viewType;
        this.viewIndex = viewIndex;
        this.from = from;
        this.to = to;
        this.raster = raster;
    }

    public RawValuesViewType getViewType() {
        return this.viewType;
    }

    public Integer getViewIndex() {
        return this.viewIndex;
    }

    public Long getFrom() {
        return this.from;
    }

    public Long getTo() {
        return this.to;
    }

    public ComplexRaster getRaster() {
        return this.raster;
    }

    public Collection<VarValuesRequestInstance> getInstances() {
        return this.instances;
    }

    public void addInstance(int instanceId) {
        this.instances.add(new VarValuesRequestInstance(instanceId, null));
    }

    public void addInstance(int instanceId, Aggregation aggr) {
        this.instances.add(new VarValuesRequestInstance(instanceId, aggr));
    }

    public void addInstances(int[] instanceIds) {
        this.addInstances(instanceIds, null);
    }

    public void addInstances(VariableInstance[] instance) {
        Arrays.stream(instance).forEach(i -> this.addInstance(i.getId()));
    }

    public void addInstances(int[] instanceIds, Aggregation[] aggrs) {
        if (aggrs != null && instanceIds.length != aggrs.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < instanceIds.length) {
            int id = instanceIds[i];
            Aggregation aggr = aggrs != null ? aggrs[i] : null;
            this.addInstance(id, aggr);
            ++i;
        }
    }

    public static final class VarValuesRequestInstance {
        private final int instanceId;
        private final Aggregation aggregation;

        public VarValuesRequestInstance(int id, Aggregation aggregation) {
            this.instanceId = id;
            this.aggregation = aggregation;
        }

        public int getId() {
            return this.instanceId;
        }

        public Aggregation getAggregation() {
            return this.aggregation;
        }
    }
}

