/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.StoredVarValue;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import java.nio.ByteBuffer;

public interface IVarValue {
    public static final /* synthetic */ int[] $SWITCH_TABLE$de$elpro$ewms$core$variable$value$IVarValue$IVarValueType;

    public long getEndTimestamp();

    public double getValue();

    public double getQuality();

    public Plausibility getPlausibility();

    public ValueSource getValueSource();

    public IVarValueType getType();

    public IVarValue copy();

    public IVarValue copy(long var1);

    public IVarValue copy(double var1);

    public IVarValue copyWithTimeShift(long var1);

    public IVarValue copyWithTimeShift(double var1, long var3);

    public IVarValue copyWithPlausibility(Plausibility var1);

    default public boolean isValid() {
        return Double.isFinite(this.getValue()) && this.getQuality() > 0.0 && this.getPlausibility() == Plausibility.Ok;
    }

    public void changePlausibility(Plausibility var1);

    default public boolean equalValue(IVarValue val, double delta) {
        if (val == null) {
            return false;
        }
        boolean isValid = this.isValid();
        boolean valIsValid = val.isValid();
        if (!isValid && !valIsValid) {
            return true;
        }
        if (!isValid || !valIsValid) {
            return false;
        }
        if (this.getQuality() != val.getQuality()) {
            return false;
        }
        double diff = Math.abs(this.getValue() - val.getValue());
        return diff <= delta;
    }

    default public boolean equalValue(IVarValue varValue) {
        return Double.isNaN(this.getValue()) && Double.isNaN(varValue.getValue()) || this.getValue() == varValue.getValue();
    }

    default public boolean equalWithTimeOffset(IVarValue varValue, Raster raster, int intervals) {
        boolean metaEqual = this.metadataEqualWithTimeOffet(varValue, raster.toMilli() * (long)intervals);
        return metaEqual && this.equalValue(varValue);
    }

    default public boolean equalWithTimeOffset(IVarValue varValue, long offset) {
        boolean metaEqual = this.metadataEqualWithTimeOffet(varValue, offset);
        return metaEqual && this.equalValue(varValue);
    }

    public boolean metadataEqualWithTimeOffet(IVarValue var1, long var2);

    public void write(ByteBuffer var1);

    public static void write(ByteBuffer buffer, IVarValue val) {
        buffer.put((byte)val.getType().ordinal());
        val.write(buffer);
    }

    public static IVarValue read(ByteBuffer buffer) {
        IVarValueType type = IVarValueType.values()[buffer.get()];
        switch (type) {
            case VarValue: {
                return VarValue.read(buffer);
            }
            case StoredVarValue: {
                return StoredVarValue.read(buffer);
            }
            case ArchiveValue: {
                return ArchiveValue.read(buffer);
            }
            case MeasuredValue: {
                return MeasuredValue.read(buffer);
            }
            case SupplementValue: {
                return SupplementValue.read(buffer);
            }
        }
        throw new IllegalArgumentException("Unsupported IVarValueType");
    }

    public static enum IVarValueType {
        VarValue,
        StoredVarValue,
        ArchiveValue,
        MeasuredValue,
        SupplementValue;


        public int getBytes() {
            switch (this) {
                case VarValue: {
                    return 26;
                }
                case StoredVarValue: {
                    return 34;
                }
                case ArchiveValue: {
                    return 33;
                }
                case MeasuredValue: {
                    return 33;
                }
                case SupplementValue: {
                    return 37;
                }
            }
            return -1;
        }
    }
}

