/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValueValidator;
import de.elpro.ewms.core.variable.value.VarValue;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.IntFunction;

public class IVarValuesCollection
implements Collection<IVarValue>,
Closeable {
    private byte[] data;
    private int size = 0;
    private IVarValue firstValue;
    private IVarValue lastValue;
    private final IVarValueValidator validator;
    private IVarValuesOutputStream outputStream;
    private boolean outputStreamClosed = false;

    public IVarValuesCollection() {
        this(null);
    }

    public IVarValuesCollection(IVarValueValidator validator) {
        this.validator = validator;
    }

    public static IVarValuesCollection create(byte[] data) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IVarValuesCollection collection = new IVarValuesCollection();){
            collection.data = data;
            collection.outputStreamClosed = true;
            ByteBuffer buffer = ByteBuffer.wrap(data, 0, 4);
            collection.size = buffer.getInt();
            return collection;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IVarValuesCollection create(IVarValue ... values) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IVarValuesCollection collection = new IVarValuesCollection();){
            IVarValue[] iVarValueArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                IVarValue val = iVarValueArray[n2];
                collection.add(val);
                ++n2;
            }
            return collection;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T extends IVarValue> IVarValuesCollection create(Collection<T> values) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IVarValuesCollection collection = new IVarValuesCollection();){
            for (IVarValue val : values) {
                collection.add(val);
            }
            return collection;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IVarValuesCollection create(IVarValue value, int count, long timeDelta) {
        Throwable throwable = null;
        Object var5_5 = null;
        try (IVarValuesCollection collection = new IVarValuesCollection();){
            collection.size = count;
            collection.outputStream = new IVarValuesOutputStream(count);
            try {
                int i = 0;
                ByteBuffer buffer = ByteBuffer.allocate(128);
                while (i < count) {
                    IVarValue firstValue = i == 0 ? value : value.copyWithTimeShift(timeDelta * (long)i);
                    int items = Math.min(count - i, 65535);
                    buffer.put((byte)ClusterType.Identical.ordinal());
                    buffer.putChar((char)items);
                    IVarValue.write(buffer, firstValue);
                    if (items > 1) {
                        buffer.putLong(timeDelta);
                    }
                    collection.outputStream.write(buffer.array(), 0, buffer.position());
                    buffer.position(0);
                    i += items;
                }
                collection.data = collection.outputStream.toByteArray();
                collection.outputStream.close();
                collection.outputStream = null;
                collection.outputStreamClosed = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            collection.firstValue = value;
            collection.lastValue = value.copyWithTimeShift(timeDelta * (long)(count - 1));
            return collection;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IVarValuesCollection createNaN(long fromTs, long toTs, Raster raster) {
        if (fromTs >= toTs || raster.getRasterEnd(fromTs) != fromTs || raster.getRasterEnd(toTs) != toTs) {
            throw new IllegalArgumentException();
        }
        IVarValue firstNaN = VarValue.nan(fromTs + raster.toMilli());
        int items = (int)((toTs - fromTs) / raster.toMilli());
        return IVarValuesCollection.create(firstNaN, items, raster.toMilli());
    }

    @Override
    public Iterator<IVarValue> iterator() {
        if (!this.outputStreamClosed) {
            throw new IllegalStateException("Collection not closed!");
        }
        switch (this.size) {
            case 0: {
                return new EmptyIterator();
            }
            case 1: {
                if (this.firstValue == null) break;
                return new SingleValIterator(this.firstValue);
            }
        }
        return new IVarValuesStreamIterator(this.toByteArray());
    }

    public IVarValue getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.iterator().next();
    }

    public IVarValue getLast() {
        if (this.lastValue != null) {
            return this.lastValue;
        }
        Iterator<IVarValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            IVarValue val;
            this.lastValue = val = iterator.next();
        }
        return this.lastValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public byte[] toByteArray() {
        if (!this.outputStreamClosed) {
            throw new IllegalStateException("Stream is not fully written");
        }
        if (this.data != null) {
            return this.data;
        }
        switch (this.size) {
            case 0: {
                this.data = new byte[4];
                break;
            }
            case 1: {
                this.data = new byte[8 + this.firstValue.getType().getBytes()];
                ByteBuffer buffer = ByteBuffer.wrap(this.data);
                buffer.putInt(1);
                buffer.put((byte)0);
                buffer.putChar('\u0001');
                IVarValue.write(buffer, this.firstValue);
                break;
            }
            default: {
                this.data = this.outputStream.toByteArray();
                ByteBuffer.wrap(this.data, 0, 4).putInt(this.size);
                this.outputStream = null;
            }
        }
        return this.data;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(IVarValue e) {
        if (this.outputStreamClosed) {
            throw new IllegalStateException("IVarValues output stream is already closed!");
        }
        if (this.validator != null) {
            e = this.validator.validate(e);
        }
        switch (this.size) {
            case 0: {
                this.firstValue = e;
                break;
            }
            case 1: {
                this.outputStream = new IVarValuesOutputStream();
                this.outputStream.writeValue(this.firstValue);
                this.outputStream.writeValue(e);
                this.firstValue = null;
                break;
            }
            default: {
                this.outputStream.writeValue(e);
            }
        }
        ++this.size;
        this.lastValue = e;
        return true;
    }

    public IVarValue[] toArray() {
        if (!this.outputStreamClosed) {
            throw new IllegalStateException();
        }
        IVarValue[] array = new IVarValue[this.size];
        int i = 0;
        for (IVarValue val : this) {
            array[i++] = val;
        }
        return array;
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.toArray();
    }

    @Override
    public <U> U[] toArray(IntFunction<U[]> a) {
        U[] array = a.apply(this.size);
        int i = 0;
        for (IVarValue val : this) {
            array[i++] = val;
        }
        return array;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends IVarValue> c) {
        for (IVarValue iVarValue : c) {
            this.add(iVarValue);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        for (IVarValue val : this) {
            b.append(String.valueOf(val));
            if (i > 10) {
                return b.append(" ...]").toString();
            }
            if (++i == this.size) {
                return b.append(']').toString();
            }
            b.append(", ");
        }
        return b.toString();
    }

    @Override
    public void close() {
        if (this.outputStreamClosed) {
            return;
        }
        this.outputStreamClosed = true;
        if (this.outputStream != null) {
            try {
                this.outputStream.pushClusterToOutputStream();
            }
            finally {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.outputStreamClosed = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static IVarValuesCollection mergeStoredVarValues(IVarValuesCollection master, IVarValuesCollection slave) {
        var2_2 = null;
        var3_4 = null;
        try {
            merged = new IVarValuesCollection();
            try {
                if (master == null || master.isEmpty()) {
                    merged.addAll(slave);
                    return merged;
                }
                if (slave == null || slave.isEmpty()) {
                    merged.addAll(master);
                    return merged;
                }
                masterIterator = master.iterator();
                slaveIterator = slave.iterator();
                masterValue = (IStoredVarValue)masterIterator.next();
                slaveValue = (IStoredVarValue)slaveIterator.next();
                prevValue = null;
                while (masterValue != null && slaveValue != null) {
                    if (slaveValue.getEndTimestamp() > masterValue.getStartTimestamp()) ** GOTO lbl31
                    if (prevValue == null || prevValue.getEndTimestamp() <= slaveValue.getStartTimestamp()) {
                        merged.add(slaveValue);
                        prevValue = slaveValue;
                    }
                    if (slaveIterator.hasNext()) {
                        slaveValue = (IStoredVarValue)slaveIterator.next();
                        continue;
                    }
                    slaveValue = null;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        slaveValue = slaveIterator.hasNext() != false ? (IStoredVarValue)slaveIterator.next() : null;
lbl31:
                        // 2 sources

                        ** while (slaveValue != null && slaveValue.getStartTimestamp() < masterValue.getEndTimestamp())
                    }
lbl32:
                    // 1 sources

                    if (prevValue == null || prevValue.getEndTimestamp() <= masterValue.getStartTimestamp()) {
                        merged.add(masterValue);
                        prevValue = masterValue;
                    }
                    masterValue = masterIterator.hasNext() != false ? (IStoredVarValue)masterIterator.next() : null;
                }
                while (masterValue != null) {
                    if (prevValue.getEndTimestamp() <= masterValue.getStartTimestamp()) {
                        merged.add(masterValue);
                        prevValue = masterValue;
                    }
                    masterValue = masterIterator.hasNext() != false ? (IStoredVarValue)masterIterator.next() : null;
                }
                while (slaveValue != null) {
                    if (prevValue.getEndTimestamp() <= slaveValue.getStartTimestamp()) {
                        merged.add(slaveValue);
                        prevValue = slaveValue;
                    }
                    slaveValue = slaveIterator.hasNext() != false ? (IStoredVarValue)slaveIterator.next() : null;
                }
                return merged;
            }
            finally {
                if (merged != null) {
                    merged.close();
                }
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
            } else if (var2_2 != var3_5) {
                var2_2.addSuppressed(var3_5);
            }
            throw var2_2;
        }
    }

    private static enum ClusterType {
        Sequence,
        Identical;

    }

    private static class EmptyIterator
    implements Iterator<IVarValue> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public IVarValue next() {
            return null;
        }
    }

    private static class IVarValuesOutputStream
    extends ByteArrayOutputStream {
        private final ByteBuffer buffer = ByteBuffer.allocate(65536);
        private ClusterType clusterType = ClusterType.Sequence;
        private char counter = '\u0000';
        private Long timeDelta;
        private IVarValue lastValue;

        public IVarValuesOutputStream() {
            this(0);
        }

        public IVarValuesOutputStream(int size) {
            ByteBuffer sizeHeader = ByteBuffer.allocate(4);
            sizeHeader.putInt(size);
            this.write(sizeHeader.array(), 0, 4);
        }

        private void pushClusterToOutputStream() {
            if (this.buffer.position() == 0) {
                return;
            }
            this.write(this.buffer.array(), 0, this.buffer.position());
            this.buffer.position(0);
            this.clusterType = ClusterType.Sequence;
            this.counter = '\u0000';
            this.timeDelta = null;
        }

        private void writeDefaultHeader(IVarValue val) {
            this.buffer.put((byte)this.clusterType.ordinal());
            this.counter = (char)(this.counter + '\u0001');
            this.buffer.putChar(this.counter);
            IVarValue.write(this.buffer, val);
        }

        private void writeValue(IVarValue val) {
            if (this.lastValue == null) {
                this.lastValue = val;
            }
            if (this.counter == '\uffff') {
                this.pushClusterToOutputStream();
            }
            if (this.buffer.position() == 0) {
                this.writeDefaultHeader(val);
            } else {
                boolean metadataEqual;
                if (this.timeDelta == null) {
                    this.timeDelta = val.getEndTimestamp() - this.lastValue.getEndTimestamp();
                }
                if (metadataEqual = this.lastValue.metadataEqualWithTimeOffet(val, this.timeDelta)) {
                    boolean valueEqual = this.lastValue.equalValue(val);
                    if (valueEqual) {
                        if (this.clusterType == ClusterType.Identical) {
                            this.counter = (char)(this.counter + '\u0001');
                            this.buffer.putChar(1, this.counter);
                        } else if (this.counter == '\u0001') {
                            this.buffer.put(0, (byte)ClusterType.Identical.ordinal());
                            this.counter = (char)(this.counter + '\u0001');
                            this.buffer.putChar(1, this.counter);
                            this.buffer.putLong(this.timeDelta);
                            this.clusterType = ClusterType.Identical;
                        } else {
                            this.pushClusterToOutputStream();
                            this.writeDefaultHeader(val);
                        }
                    } else if (this.clusterType == ClusterType.Identical) {
                        this.pushClusterToOutputStream();
                        this.writeDefaultHeader(val);
                    } else if (this.buffer.position() < this.buffer.capacity() - 8) {
                        if (this.counter == '\u0001') {
                            this.buffer.putLong(this.timeDelta);
                        }
                        this.counter = (char)(this.counter + '\u0001');
                        this.buffer.putChar(1, this.counter);
                        this.buffer.putDouble(val.getValue());
                    } else {
                        this.pushClusterToOutputStream();
                        this.writeDefaultHeader(val);
                    }
                } else {
                    this.pushClusterToOutputStream();
                    this.writeDefaultHeader(val);
                }
            }
            this.lastValue = val;
        }
    }

    private static final class IVarValuesStreamIterator
    implements Iterator<IVarValue> {
        private final ByteBuffer buffer;
        private final int size;
        private int index = 0;
        private ClusterType clusterType;
        private char clusterSize;
        private char clusterIndex;
        private Long timeDelta;
        private IVarValue headerValue;

        public IVarValuesStreamIterator(byte[] data) {
            this.buffer = ByteBuffer.wrap(data);
            this.size = this.buffer.getInt();
        }

        @Override
        public boolean hasNext() {
            boolean isEnd;
            boolean hasMore = this.buffer.hasRemaining() || this.clusterIndex < this.clusterSize;
            boolean bl = isEnd = this.size == this.index;
            if (hasMore == isEnd) {
                throw new IllegalStateException("Something is wrong here. Expected and actual length are not the same!");
            }
            return hasMore;
        }

        @Override
        public IVarValue next() {
            IVarValue val;
            if (this.headerValue == null) {
                this.clusterType = ClusterType.values()[this.buffer.get()];
                this.clusterSize = this.buffer.getChar();
                this.clusterIndex = '\u0000';
                this.headerValue = IVarValue.read(this.buffer);
                if (this.clusterSize > '\u0001') {
                    this.timeDelta = this.buffer.getLong();
                }
            }
            if (this.clusterIndex == '\u0000') {
                val = this.headerValue;
            } else {
                switch (this.clusterType) {
                    case Identical: {
                        val = this.headerValue.copyWithTimeShift(this.timeDelta * (long)this.clusterIndex);
                        break;
                    }
                    case Sequence: {
                        double value = this.buffer.getDouble();
                        val = this.headerValue.copyWithTimeShift(value, this.timeDelta * (long)this.clusterIndex);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported Cluster Type");
                    }
                }
            }
            this.clusterIndex = (char)(this.clusterIndex + '\u0001');
            if (this.clusterIndex == this.clusterSize) {
                this.headerValue = null;
            }
            ++this.index;
            return val;
        }
    }

    private static class SingleValIterator
    implements Iterator<IVarValue> {
        private IVarValue value;

        public SingleValIterator(IVarValue value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.value != null;
        }

        @Override
        public IVarValue next() {
            try {
                IVarValue iVarValue = this.value;
                return iVarValue;
            }
            finally {
                this.value = null;
            }
        }
    }
}

