/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.IVarValuesCollectionCluster;
import de.elpro.ewms.core.variable.value.IVarValuesCollectionClustered;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IVarValuesCollectionSpliterator
implements Iterator<IVarValuesCollectionCluster> {
    private final Raster clusterSize;
    private final Iterator<IVarValue> valuesIterator;
    private Long clusterBeginTs = null;
    private IVarValue value = null;

    public IVarValuesCollectionSpliterator(Raster clusterSize, IVarValuesCollection values) {
        this.clusterSize = clusterSize;
        this.valuesIterator = values.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.value != null || this.valuesIterator.hasNext();
    }

    @Override
    public IVarValuesCollectionCluster next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (IVarValuesCollection clusterValues = new IVarValuesCollection();){
            long valueClusterBeginTimestamp;
            block13: {
                if (this.value == null) {
                    this.value = this.valuesIterator.next();
                }
                while (true) {
                    valueClusterBeginTimestamp = this.value instanceof IStoredVarValue ? this.clusterSize.getRasterBegin(((IStoredVarValue)this.value).getStartTimestamp()) : this.clusterSize.getRasterBegin(this.value.getEndTimestamp() - 1L);
                    if (this.clusterBeginTs == null) {
                        this.clusterBeginTs = valueClusterBeginTimestamp;
                    }
                    if (this.clusterBeginTs != valueClusterBeginTimestamp) break block13;
                    clusterValues.add(this.value);
                    if (!this.valuesIterator.hasNext()) break;
                    this.value = this.valuesIterator.next();
                }
                this.value = null;
            }
            IVarValuesCollectionCluster result = new IVarValuesCollectionCluster(this.clusterBeginTs, this.clusterSize, clusterValues);
            this.clusterBeginTs = valueClusterBeginTimestamp;
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        IVarValuesCollection testColl;
        Throwable throwable = null;
        Iterator<IVarValuesCollectionCluster> iterator = null;
        try (IVarValuesCollection newColl = new IVarValuesCollection();){
            int i = 0;
            while (i < 100) {
                newColl.add(new MeasuredValue(i * 10, (i + 1) * 10, i, 1.0));
                ++i;
            }
            testColl = newColl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (IVarValuesCollectionCluster cluster : new IVarValuesCollectionClustered(Raster.Milli_100, testColl)) {
            System.out.println(cluster.getClusterBeginTs());
            System.out.println(cluster.getClusterValues().toString());
        }
    }
}

