/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.variable.value;

import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.ValueSource;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class SupplementValue
implements IStoredVarValue {
    public static final int BYTES = 37;
    private long startTimestamp;
    private long endTimestamp;
    private double value;
    private Plausibility plausibility;
    private long recordedTimestamp;
    private int userId;

    public SupplementValue(long startTimestamp, long endTimestamp, double value, long recordedTimestamp, int userId) {
        this(startTimestamp, endTimestamp, value, Plausibility.Ok, recordedTimestamp, userId);
    }

    public SupplementValue(long startTimestamp, long endTimestamp, double value, Plausibility plausibility, long recordedTimestamp, int userId) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.value = value;
        this.plausibility = plausibility;
        this.recordedTimestamp = recordedTimestamp;
        this.userId = userId;
    }

    @Override
    public IVarValue.IVarValueType getType() {
        return IVarValue.IVarValueType.SupplementValue;
    }

    @Override
    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getQuality() {
        return 1.0;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Plausibility getPlausibility() {
        return this.plausibility;
    }

    @Override
    public void changePlausibility(Plausibility plausibility) {
        this.plausibility = plausibility;
    }

    @Override
    public ValueSource getValueSource() {
        return ValueSource.Supplement;
    }

    @Override
    public boolean metadataEqualWithTimeOffet(IVarValue varValue, long offset) {
        if (SupplementValue.class != varValue.getClass()) {
            return false;
        }
        SupplementValue sv = (SupplementValue)varValue;
        return this.plausibility == sv.plausibility && this.recordedTimestamp == sv.recordedTimestamp && this.userId == sv.userId && this.startTimestamp + offset == sv.startTimestamp && this.endTimestamp + offset == sv.endTimestamp;
    }

    @Override
    public SupplementValue copy(long startTimestamp, long endTimestamp, double value, double quality, Plausibility plausibility) {
        return new SupplementValue(startTimestamp, endTimestamp, value, plausibility, this.recordedTimestamp, this.userId);
    }

    @Override
    public SupplementValue copyWithTimeShift(double value, long timeShift) {
        return new SupplementValue(this.startTimestamp + timeShift, this.endTimestamp + timeShift, value, this.plausibility, this.recordedTimestamp, this.userId);
    }

    @Override
    public IVarValue copyWithPlausibility(Plausibility plausibility) {
        return new SupplementValue(this.startTimestamp, this.endTimestamp, this.value, plausibility, this.recordedTimestamp, this.userId);
    }

    public long getRecordedTimestamp() {
        return this.recordedTimestamp;
    }

    public int getUserId() {
        return this.userId;
    }

    public boolean getIsParameterValue() {
        return this.startTimestamp == this.endTimestamp;
    }

    public String toString() {
        if (this.getIsParameterValue()) {
            return String.format("%s %f", LocalDateTime.ofInstant(Instant.ofEpochMilli(this.startTimestamp), ZoneOffset.UTC), this.value);
        }
        return String.format("%s-%s %f", LocalDateTime.ofInstant(Instant.ofEpochMilli(this.startTimestamp), ZoneOffset.UTC), LocalDateTime.ofInstant(Instant.ofEpochMilli(this.endTimestamp), ZoneOffset.UTC), this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IVarValue)) {
            return false;
        }
        if (this.getType() != ((IVarValue)obj).getType()) {
            return false;
        }
        SupplementValue other = (SupplementValue)obj;
        return this.startTimestamp == other.startTimestamp && this.endTimestamp == other.endTimestamp && this.equalValue(other) && this.plausibility == other.plausibility && this.recordedTimestamp == other.recordedTimestamp && this.userId == other.userId;
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.putLong(this.startTimestamp);
        buffer.putLong(this.endTimestamp);
        buffer.putDouble(this.value);
        buffer.put((byte)this.plausibility.ordinal());
        buffer.putLong(this.recordedTimestamp);
        buffer.putInt(this.userId);
    }

    public static IVarValue read(ByteBuffer buffer) {
        return new SupplementValue(buffer.getLong(), buffer.getLong(), buffer.getDouble(), Plausibility.values()[buffer.get()], buffer.getLong(), buffer.getInt());
    }
}

