/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.virtualtime;

import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import java.time.Instant;
import java.util.LinkedList;
import javafx.util.StringConverter;

public class ComplexRaster
implements Comparable<Object> {
    public static final ComplexRaster HOUR;
    public static final ComplexRaster DAY;
    public static final ComplexRaster WEEK;
    public static final ComplexRaster MONTH;
    public static final ComplexRaster YEAR;
    public static final ComplexRaster OVERALL;
    private static final ComplexRaster[] values;
    public static final StringConverter<ComplexRaster> CONVERTER;
    private final VirtualRaster virtualRaster;
    private final Raster raster;

    static {
        CONVERTER = new StringConverter<ComplexRaster>(){

            public String toString(ComplexRaster object) {
                if (object == null) {
                    return null;
                }
                return object.name();
            }

            public ComplexRaster fromString(String string) {
                return ComplexRaster.valueOf(string);
            }
        };
        LinkedList<ComplexRaster> crs = new LinkedList<ComplexRaster>();
        Raster[] rasterValues = Raster.values();
        VirtualRaster[] virtualRasterValues = VirtualRaster.values();
        int i = 0;
        while (i < rasterValues.length) {
            crs.add(new ComplexRaster(rasterValues[i]));
            ++i;
        }
        i = 1;
        while (i < virtualRasterValues.length) {
            crs.add(new ComplexRaster(virtualRasterValues[i]));
            ++i;
        }
        values = (ComplexRaster[])crs.stream().toArray(ComplexRaster[]::new);
        HOUR = ComplexRaster.of(Raster.Hour);
        DAY = ComplexRaster.of(VirtualRaster.Day);
        WEEK = ComplexRaster.of(VirtualRaster.Week);
        MONTH = ComplexRaster.of(VirtualRaster.Month);
        YEAR = ComplexRaster.of(VirtualRaster.Year);
        OVERALL = ComplexRaster.of(VirtualRaster.Overall);
    }

    private ComplexRaster(VirtualRaster virtualRaster) {
        if (virtualRaster != VirtualRaster.Hour) {
            this.virtualRaster = virtualRaster;
            this.raster = null;
        } else {
            this.virtualRaster = null;
            this.raster = Raster.Hour;
        }
    }

    private ComplexRaster(Raster raster) {
        this.raster = raster;
        this.virtualRaster = null;
    }

    public VirtualRaster getVirtualRaster() {
        if (this.virtualRaster == null && this.raster == Raster.Hour) {
            return VirtualRaster.Hour;
        }
        return this.virtualRaster;
    }

    public Raster getRaster() {
        if (this.raster == null && this.virtualRaster == VirtualRaster.Hour) {
            return Raster.Hour;
        }
        return this.raster;
    }

    public Instant getRasterBegin(Instant utc) {
        if (this.virtualRaster != null) {
            return this.virtualRaster.getRasterBegin(utc);
        }
        long ts = utc.toEpochMilli();
        long tsBegin = this.raster.getRasterBegin(ts);
        if (tsBegin == ts && utc.getNano() % 1000000 == 0) {
            tsBegin -= this.raster.toMilli();
        }
        return Instant.ofEpochMilli(tsBegin).plusNanos(1L);
    }

    public Instant getRasterEnd(Instant utc) {
        long tsEnd;
        if (this.virtualRaster != null) {
            return this.virtualRaster.getRasterEnd(utc);
        }
        long ts = utc.toEpochMilli();
        if (ts == (tsEnd = this.raster.getRasterEnd(ts)) && utc.getNano() % 1000000 != 0) {
            tsEnd += this.raster.toMilli();
        }
        return Instant.ofEpochMilli(tsEnd);
    }

    public String toString() {
        return this.raster != null ? this.raster.toString() : this.virtualRaster.toString();
    }

    public static ComplexRaster valueOf(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        try {
            return new ComplexRaster(Raster.valueOf(name));
        }
        catch (Exception exception) {
            return new ComplexRaster(VirtualRaster.valueOf(name));
        }
    }

    public static ComplexRaster of(Raster raster) {
        if (raster == null) {
            return null;
        }
        return values[raster.ordinal()];
    }

    public static ComplexRaster of(VirtualRaster virtualRaster) {
        if (virtualRaster == null) {
            return null;
        }
        return values[Raster.values().length - 1 + virtualRaster.ordinal()];
    }

    public String name() {
        if (this.raster != null) {
            return this.raster.name();
        }
        return this.virtualRaster.name();
    }

    public static ComplexRaster[] values() {
        return values;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ComplexRaster)) {
            return false;
        }
        ComplexRaster cr = (ComplexRaster)o;
        return cr.raster == this.raster && cr.virtualRaster == this.virtualRaster;
    }

    public int ordinal() {
        if (this.raster != null) {
            return this.raster.ordinal();
        }
        return this.virtualRaster.ordinal() + Raster.values().length - 1;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof VirtualRaster) {
            VirtualRaster oR = (VirtualRaster)((Object)o);
            return this.compareTo(new ComplexRaster(oR));
        }
        if (o instanceof Raster) {
            Raster oR = (Raster)((Object)o);
            return this.compareTo(new ComplexRaster(oR));
        }
        if (o instanceof ComplexRaster) {
            ComplexRaster oR = (ComplexRaster)o;
            return Integer.compare(this.ordinal(), oR.ordinal());
        }
        return 0;
    }

    public int hashCode() {
        return ComplexRaster.class.hashCode() + (this.raster != null ? 17 * Raster.class.hashCode() * this.raster.hashCode() : 17 * VirtualRaster.class.hashCode() * this.virtualRaster.hashCode());
    }
}

