/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.gef.layout.algorithms;

import de.elpro.ewms.engin.gui.gef.layout.algorithms.TreeLayoutObserver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.LayoutContext;
import org.eclipse.gef.layout.LayoutProperties;

public class TreeLayoutAlgorithm
implements ILayoutAlgorithm {
    public static final int TOP_DOWN = 1;
    public static final int BOTTOM_UP = 2;
    public static final int LEFT_RIGHT = 3;
    public static final int RIGHT_LEFT = 4;
    private int direction = 1;
    private static final int INSETS = 10;
    private boolean resize = false;
    private LayoutContext context;
    private Rectangle bounds;
    private TreeLayoutObserver treeObserver;
    private Dimension nodeSpace;
    protected double[] layersDepths;
    protected double[] layersDepth;
    protected ArrayList<TreeLayoutObserver.TreeNode> leafNodes;
    protected double totalLeafBreadth = 0.0;

    public TreeLayoutAlgorithm() {
    }

    public TreeLayoutAlgorithm(int direction) {
        this(direction, null);
    }

    public TreeLayoutAlgorithm(int direction, Dimension nodeSpace) {
        this.setDirection(direction);
        this.nodeSpace = nodeSpace;
    }

    public void setNodeSpace(Dimension nodeSpace) {
        this.nodeSpace = nodeSpace;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction != 1 && direction != 2 && direction != 3 && direction != 4) {
            throw new IllegalArgumentException("Invalid direction: " + direction);
        }
        this.direction = direction;
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
    }

    public void setLayoutContext(LayoutContext context) {
        if (this.treeObserver != null) {
            this.treeObserver.stop();
        }
        this.context = context;
        if (context != null) {
            this.treeObserver = new TreeLayoutObserver(context, null);
        }
    }

    public LayoutContext getLayoutContext() {
        return this.context;
    }

    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.internalApplyLayout();
    }

    protected void scanLayout(TreeLayoutObserver.TreeNode root, int layer) {
        if (root.getNode() != null) {
            double layerDepth = this.layersDepths[layer - 1];
            Dimension dim = LayoutProperties.getSize((Node)root.getNode());
            layerDepth = Math.max(layerDepth, dim != null ? this.getDepth(dim) : 0.0);
            if (root.getChildren().isEmpty()) {
                this.leafNodes.add(root);
                this.totalLeafBreadth += dim != null ? this.getAppearentBreadth(root) : 0.0;
            }
        }
        for (TreeLayoutObserver.TreeNode child : root.getChildren()) {
            this.scanLayout(child, layer + 1);
        }
    }

    private double getAppearentBreadth(TreeLayoutObserver.TreeNode leaf) {
        double breadth = 0.0;
        while (leaf != null && leaf.getNode() != null) {
            Dimension dim = LayoutProperties.getSize((Node)leaf.getNode());
            breadth = Math.max(breadth, this.getBreadth(dim));
            if (leaf.getParent() == null || leaf.getParent().getChildren().size() != 1) break;
            leaf = leaf.getParent();
        }
        return breadth;
    }

    private double getDepth(Dimension dim) {
        switch (this.direction) {
            case 1: 
            case 2: {
                return dim.height;
            }
            case 3: 
            case 4: {
                return dim.width;
            }
        }
        return 0.0;
    }

    private double getBreadth(Dimension dim) {
        switch (this.direction) {
            case 1: 
            case 2: {
                return dim.width;
            }
            case 3: 
            case 4: {
                return dim.height;
            }
        }
        return 0.0;
    }

    private double getBreadth(Point p) {
        switch (this.direction) {
            case 1: {
                return p.x();
            }
            case 2: {
                return p.x();
            }
            case 3: {
                return p.y();
            }
            case 4: {
                return p.y();
            }
        }
        return 0.0;
    }

    protected void setLocRevRec(TreeLayoutObserver.TreeNode child) {
    }

    protected void computeLayersDepth() {
        double totalLayerDepth = 0.0;
        double[] dArray = this.layersDepths;
        int n = this.layersDepths.length;
        int n2 = 0;
        while (n2 < n) {
            double maxDepth = dArray[n2];
            totalLayerDepth += maxDepth;
            ++n2;
        }
        double spacing = 0.0;
        if (this.layersDepths.length > 1) {
            double totalDepth = this.getDepth(new Dimension(this.bounds.getWidth(), this.bounds.getHeight()));
            spacing = (totalDepth - totalLayerDepth - 20.0) / (double)(this.layersDepths.length - 1);
        }
        double layerDepth = this.layersDepths[0] / 2.0 + 10.0;
        int i = 0;
        while (i < this.layersDepths.length) {
            this.layersDepth[i] = layerDepth;
            layerDepth += this.layersDepths[i] / 2.0 + spacing;
            if (i < this.layersDepths.length - 1) {
                layerDepth += this.layersDepths[i + 1] / 2.0;
            }
            ++i;
        }
    }

    protected void layoutLeafs() {
        if (this.leafNodes.size() == 0) {
            return;
        }
        double boundsBreadth = this.getBreadth(new Dimension(this.bounds.getWidth(), this.bounds.getHeight()));
        if (this.leafNodes.size() == 1) {
            TreeLayoutObserver.TreeNode leaf = this.leafNodes.get(0);
            LayoutProperties.setLocation((Node)leaf.getNode(), (Point)this.getPoint(boundsBreadth / 2.0, this.layersDepth[leaf.depth]));
            return;
        }
        double leafSpacing = (boundsBreadth - this.totalLeafBreadth - 30.0) / (double)(this.leafNodes.size() - 1);
        double layerBreadth = 10.0;
        int i = 0;
        while (i < this.leafNodes.size()) {
            TreeLayoutObserver.TreeNode leaf = this.leafNodes.get(i);
            double appearentBreadth = this.getAppearentBreadth(leaf);
            LayoutProperties.setLocation((Node)leaf.getNode(), (Point)this.getPoint(layerBreadth + appearentBreadth / 2.0, this.layersDepth[leaf.depth]));
            layerBreadth += appearentBreadth + leafSpacing;
            ++i;
        }
    }

    private Point getPoint(double breadth, double depth) {
        switch (this.direction) {
            case 1: {
                return new Point(breadth, depth);
            }
            case 2: {
                return new Point(breadth, this.bounds.getHeight() - depth);
            }
            case 3: {
                return new Point(depth, breadth);
            }
            case 4: {
                return new Point(this.bounds.getWidth() - depth, breadth);
            }
        }
        return null;
    }

    private List<TreeLayoutObserver.TreeNode> getLeafs(TreeLayoutObserver.TreeNode root) {
        LinkedList<TreeLayoutObserver.TreeNode> leafs = new LinkedList<TreeLayoutObserver.TreeNode>();
        for (TreeLayoutObserver.TreeNode child : root.getChildren()) {
            if (child.getChildren().isEmpty()) {
                leafs.add(child);
                continue;
            }
            leafs.addAll(this.getLeafs(child));
        }
        return leafs;
    }

    private double getLeftLeafBreadth(TreeLayoutObserver.TreeNode root) {
        double leftCorner = this.getBreadth(new Dimension(this.bounds.getWidth(), this.bounds.getHeight()));
        for (TreeLayoutObserver.TreeNode leaf : this.getLeafs(root)) {
            double breadth = this.getBreadth(LayoutProperties.getLocation((Node)leaf.getNode())) - this.getBreadth(LayoutProperties.getSize((Node)leaf.getNode())) / 2.0;
            leftCorner = Math.min(breadth, leftCorner);
        }
        return leftCorner;
    }

    private double getRightLeafBrea\u0432th(TreeLayoutObserver.TreeNode root) {
        double rightCorner = 0.0;
        for (TreeLayoutObserver.TreeNode leaf : this.getLeafs(root)) {
            double yMidle = this.getBreadth(LayoutProperties.getLocation((Node)leaf.getNode())) + this.getBreadth(LayoutProperties.getSize((Node)leaf.getNode())) / 2.0;
            rightCorner = Math.max(yMidle, rightCorner);
        }
        return rightCorner;
    }

    private List<TreeLayoutObserver.TreeNode> getParents(TreeLayoutObserver.TreeNode root) {
        LinkedList<TreeLayoutObserver.TreeNode> parents = new LinkedList<TreeLayoutObserver.TreeNode>();
        if (root.getNode() != null && !root.getChildren().isEmpty()) {
            parents.add(root);
        }
        for (TreeLayoutObserver.TreeNode child : root.getChildren()) {
            parents.addAll(this.getParents(child));
        }
        return parents;
    }

    protected void layoutParents(TreeLayoutObserver.TreeNode superRoot) {
        for (TreeLayoutObserver.TreeNode parent : this.getParents(superRoot)) {
            double leftBreadthCorner = this.getLeftLeafBreadth(parent);
            double rightBreadthCorner = this.getRightLeafBrea\u0432th(parent);
            LayoutProperties.setLocation((Node)parent.getNode(), (Point)this.getPoint((leftBreadthCorner + rightBreadthCorner) / 2.0, this.layersDepth[parent.depth]));
        }
    }

    void internalApplyLayout() {
        TreeLayoutObserver.TreeNode superRoot = this.treeObserver.getSuperRoot();
        this.bounds = LayoutProperties.getBounds((Graph)this.context.getGraph());
        this.layersDepths = new double[superRoot.height];
        this.layersDepth = new double[superRoot.height];
        this.leafNodes = new ArrayList();
        this.totalLeafBreadth = 0.0;
        this.scanLayout(superRoot, 0);
        this.computeLayersDepth();
        this.layoutLeafs();
        this.layoutParents(superRoot);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TreeLayout { direction : ");
        switch (this.direction) {
            case 2: {
                sb.append("bottom -> top");
                break;
            }
            case 3: {
                sb.append("left -> right");
                break;
            }
            case 4: {
                sb.append("right -> left");
                break;
            }
            case 1: {
                sb.append("top -> down");
            }
        }
        sb.append(", resize : " + this.resize);
        sb.append(" }");
        return sb.toString();
    }
}

