/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.gef.parts;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.engin.gui.gef.graph.StructureClassNode;
import de.elpro.ewms.engin.gui.gef.layout.algorithms.TreeLayoutAlgorithm;
import de.elpro.ewms.engin.gui.gef.zest.fx.parts.EnginFXModule;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Polygon;
import javafx.stage.Stage;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ClassHierarchyView
extends Stage {
    private final IDomain domain;
    private final IViewer viewer;
    private final ProgressIndicatorPane progressIndicator;
    private final StructureClass rootClass;

    public ClassHierarchyView(StructureClass rootClass) {
        this.rootClass = rootClass;
        this.setTitle(rootClass.toString());
        if (rootClass.getGraphic() instanceof ImageView) {
            this.getIcons().add((Object)((ImageView)rootClass.getGraphic()).getImage());
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new EnginFXModule()});
        this.domain = (IDomain)injector.getInstance(IDomain.class);
        this.viewer = (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
        this.progressIndicator = new ProgressIndicatorPane((Node)this.viewer.getCanvas());
        this.setScene(new Scene((Parent)this.progressIndicator));
        this.setHeight(800.0);
        this.setWidth(1200.0);
    }

    public void showAndActivate() {
        this.show();
        this.domain.activate();
        CallableTask<Graph> task = new CallableTask<Graph>(){

            public Graph call() throws Exception {
                HashMap<StructureClass, org.eclipse.gef.graph.Node> nodes = new HashMap<StructureClass, org.eclipse.gef.graph.Node>();
                ArrayList<Edge> edges = new ArrayList<Edge>();
                Transaction trx = Transactions.begin();
                try {
                    ClassHierarchyView.buildDepTree(trx, ClassHierarchyView.this.rootClass, nodes, edges, new HashMap<Integer, Variable>());
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
                HashMap<String, TreeLayoutAlgorithm> attrs = new HashMap<String, TreeLayoutAlgorithm>();
                attrs.put("graph-layout-algorithm", new TreeLayoutAlgorithm(1));
                return new Graph(attrs, nodes.values(), edges);
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)task).consumeResult((status, graph) -> {
            if (status == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> this.viewer.getContents().setAll(Collections.singletonList(graph)));
            }
        });
    }

    protected static void buildDepTree(Transaction trx, StructureClass clazz, Map<StructureClass, org.eclipse.gef.graph.Node> nodes, List<Edge> edges, Map<Integer, Variable> variables) {
        org.eclipse.gef.graph.Node node = nodes.get(clazz);
        if (node != null) {
            return;
        }
        clazz = StructureClassDAO.get((Transaction)trx, (int)clazz.getId());
        LinkedList vars = new LinkedList(clazz.getVariables());
        clazz.getVariables().clear();
        for (Variable var : vars) {
            clazz.getVariables().add(VariableDAO.get((Transaction)trx, (int)var.getId()));
        }
        node = ClassHierarchyView.createInstanceNode(clazz);
        nodes.put(clazz, node);
        for (StructureClass extendClass : new TreeSet(clazz.getExtendClasses())) {
            ClassHierarchyView.buildDepTree(trx, extendClass, nodes, edges, variables);
            edges.add(ClassHierarchyView.createEdge(clazz, extendClass, nodes));
        }
    }

    protected static org.eclipse.gef.graph.Node createInstanceNode(StructureClass clazz) {
        return new StructureClassNode(clazz);
    }

    protected static Edge createEdge(StructureClass parentClass, StructureClass extendClass, Map<StructureClass, org.eclipse.gef.graph.Node> nodes) {
        org.eclipse.gef.graph.Node from = nodes.get(parentClass);
        org.eclipse.gef.graph.Node to = nodes.get(extendClass);
        Edge.Builder builder = new Edge.Builder(from, to).attr("element-css-id", (Object)String.format("dependency_%d-%d", parentClass.getId(), extendClass.getId())).attr("edge-source-decoration", (Object)new Arrow());
        return builder.buildEdge();
    }

    static class Arrow
    extends Polygon {
        public Arrow() {
            super(new double[]{0.0, 0.0, 10.0, 3.0, 10.0, -3.0});
        }
    }
}

