/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.gef.parts;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic2DDAO;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDependencyDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.dependencies.VariableInstanceDependency;
import de.elpro.ewms.engin.gui.gef.graph.Characteristic2DInstanceNode;
import de.elpro.ewms.engin.gui.gef.graph.ObjectPropertyNode;
import de.elpro.ewms.engin.gui.gef.graph.VariableInstanceNode;
import de.elpro.ewms.engin.gui.gef.layout.algorithms.TreeLayoutAlgorithm;
import de.elpro.ewms.engin.gui.gef.zest.fx.parts.EnginFXModule;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Polygon;
import javafx.stage.Stage;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class DependenciesView
extends Stage {
    private final IDomain domain;
    private final IViewer viewer;
    private final ProgressIndicatorPane progressIndicator;
    private final VariableInstance instance;

    public DependenciesView(VariableInstance instance) {
        this.instance = instance;
        this.setTitle(instance.toString());
        if (instance.getGraphic() instanceof ImageView) {
            this.getIcons().add((Object)((ImageView)instance.getGraphic()).getImage());
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new EnginFXModule()});
        this.domain = (IDomain)injector.getInstance(IDomain.class);
        this.viewer = (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
        this.progressIndicator = new ProgressIndicatorPane((Node)this.viewer.getCanvas());
        this.setScene(new Scene((Parent)this.progressIndicator));
        this.setHeight(800.0);
        this.setWidth(1200.0);
    }

    public void showAndActivate() {
        this.show();
        this.domain.activate();
        CallableTask<Graph> task = new CallableTask<Graph>(){

            public Graph call() throws Exception {
                HashMap<Object, org.eclipse.gef.graph.Node> nodes = new HashMap<Object, org.eclipse.gef.graph.Node>();
                ArrayList<Edge> edges = new ArrayList<Edge>();
                Transaction trx = Transactions.begin();
                try {
                    DependenciesView.buildDepTree(trx, DependenciesView.this.instance, nodes, edges, new HashMap<Integer, Variable>(), new HashMap<Integer, StructureObject>(), new HashMap<Integer, Characteristic2D>());
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
                HashMap<String, TreeLayoutAlgorithm> attrs = new HashMap<String, TreeLayoutAlgorithm>();
                attrs.put("graph-layout-algorithm", new TreeLayoutAlgorithm(1));
                return new Graph(attrs, nodes.values(), edges);
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)task).consumeResult((status, graph) -> {
            if (status == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> this.viewer.getContents().setAll(Collections.singletonList(graph)));
            }
        });
    }

    protected static void buildDepTree(Transaction trx, VariableInstance instance, Map<Object, org.eclipse.gef.graph.Node> nodes, List<Edge> edges, Map<Integer, Variable> variables, Map<Integer, StructureObject> objects, Map<Integer, Characteristic2D> characteristics) {
        StructureObject object;
        org.eclipse.gef.graph.Node node = nodes.get(instance);
        if (node != null) {
            return;
        }
        Variable var = variables.get((instance = VariableInstanceDAO.get((Transaction)trx, (int)instance.getId())).getVariable().getId());
        if (var == null) {
            var = VariableDAO.get((Transaction)trx, (int)instance.getVariable().getId());
            variables.put(var.getId(), var);
        }
        if ((object = objects.get(instance.getStructureObject().getId())) == null) {
            object = StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId());
            objects.put(object.getId(), object);
        }
        instance.setVariable(var);
        instance.setStructureObject(object);
        node = DependenciesView.createInstanceNode(instance);
        nodes.put(instance, node);
        VariableInstanceDependency[] variableInstanceDependencyArray = VariableInstanceDependencyDAO.getDependencies((Transaction)trx, (VariableInstance)instance);
        int n = variableInstanceDependencyArray.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                VariableInstanceDependency dependency;
                block9: {
                    block10: {
                        block8: {
                            dependency = variableInstanceDependencyArray[n2];
                            if (!(dependency.getDependency() instanceof VariableInstance)) break block8;
                            DependenciesView.buildDepTree(trx, (VariableInstance)dependency.getDependency(), nodes, edges, variables, objects, characteristics);
                            break block9;
                        }
                        if (!(dependency.getDependency() instanceof Characteristic2DInstance)) break block10;
                        Characteristic2DInstance c2di = (Characteristic2DInstance)dependency.getDependency();
                        Characteristic2D c2d = characteristics.get(c2di.getId());
                        if (c2d == null) {
                            c2d = Characteristic2DDAO.get((Transaction)trx, (int)c2di.getCharacteristic().getId());
                            characteristics.put(c2d.getId(), c2d);
                        }
                        c2di.setCharacteristic(c2d);
                        nodes.put(dependency.getDependency(), new Characteristic2DInstanceNode(c2di));
                        break block9;
                    }
                    if (!(dependency.getDependency() instanceof PropertyValue)) break block11;
                    PropertyValue propValue = (PropertyValue)dependency.getDependency();
                    Property property = propValue.getProperty();
                    property = property.getId() != null ? PropertyDAO.get((Transaction)trx, (Integer)property.getId()) : PropertyDAO.get((Transaction)trx, (String)property.getKey(), (String)property.getGroup().getKey());
                    StructureObject structureObject = StructureObjectDAO.get((Transaction)trx, (int)propValue.getStructureObject().getId());
                    ObjectPropertyNode opn = new ObjectPropertyNode(structureObject, property);
                    nodes.put(dependency.getDependency(), opn);
                }
                edges.add(DependenciesView.createEdge(dependency, nodes));
            }
            ++n2;
        }
    }

    protected static org.eclipse.gef.graph.Node createInstanceNode(VariableInstance instance) {
        return new VariableInstanceNode(instance);
    }

    protected static Edge createEdge(VariableInstanceDependency dependency, Map<Object, org.eclipse.gef.graph.Node> nodes) {
        String label = dependency.getKey().getName();
        org.eclipse.gef.graph.Node from = nodes.get(dependency.getVariableInstance());
        org.eclipse.gef.graph.Node to = nodes.get(dependency.getDependency());
        Edge.Builder builder = new Edge.Builder(from, to).attr("element-label", (Object)label).attr("element-css-id", (Object)String.format("dependency_%d-%d", dependency.getVariableInstance().getId(), dependency.getDependency().hashCode())).attr("edge-source-decoration", (Object)new Arrow());
        return builder.buildEdge();
    }

    static class Arrow
    extends Polygon {
        public Arrow() {
            super(new double[]{0.0, 0.0, 10.0, 3.0, 10.0, -3.0});
        }
    }
}

