/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.gef.parts;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.engin.gui.gef.graph.StructureObjectNode;
import de.elpro.ewms.engin.gui.gef.layout.algorithms.TreeLayoutAlgorithm;
import de.elpro.ewms.engin.gui.gef.zest.fx.parts.EnginFXModule;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.TaskUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Polygon;
import javafx.stage.Stage;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ObjectHierarchyView
extends Stage {
    private final IDomain domain;
    private final IViewer viewer;
    private final ProgressIndicatorPane progressIndicator;
    private final StructureObject rootObject;

    public ObjectHierarchyView(StructureObject rootObject) {
        this.rootObject = rootObject;
        this.setTitle(rootObject.toString());
        this.getIcons().add((Object)((ImageView)rootObject.getGraphic()).getImage());
        Injector injector = Guice.createInjector((Module[])new Module[]{new EnginFXModule()});
        this.domain = (IDomain)injector.getInstance(IDomain.class);
        this.viewer = (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
        this.progressIndicator = new ProgressIndicatorPane((Node)this.viewer.getCanvas());
        this.setScene(new Scene((Parent)this.progressIndicator));
        this.setHeight(800.0);
        this.setWidth(1200.0);
    }

    public void showAndActivate() {
        this.show();
        this.domain.activate();
        CallableTask<Graph> task = new CallableTask<Graph>(){

            public Graph call() throws Exception {
                HashMap<StructureObject, org.eclipse.gef.graph.Node> nodes = new HashMap<StructureObject, org.eclipse.gef.graph.Node>();
                ArrayList<Edge> edges = new ArrayList<Edge>();
                Transaction trx = Transactions.begin();
                try {
                    ObjectHierarchyView.buildDepTree(trx, ObjectHierarchyView.this.rootObject, nodes, edges);
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
                HashMap<String, TreeLayoutAlgorithm> attrs = new HashMap<String, TreeLayoutAlgorithm>();
                attrs.put("graph-layout-algorithm", new TreeLayoutAlgorithm());
                return new Graph(attrs, nodes.values(), edges);
            }
        };
        TaskUtils.executeUITask((ProgressIndicatorPane)this.progressIndicator, (CallableTask)task).consumeResult((status, graph) -> {
            if (status == Worker.State.SUCCEEDED) {
                Platform.runLater(() -> this.viewer.getContents().setAll(Collections.singletonList(graph)));
            }
        });
    }

    protected static void buildDepTree(Transaction trx, StructureObject object, Map<StructureObject, org.eclipse.gef.graph.Node> nodes, List<Edge> edges) {
        org.eclipse.gef.graph.Node node = nodes.get(object);
        if (node != null) {
            return;
        }
        object = StructureObjectDAO.get((Transaction)trx, (int)object.getId());
        node = ObjectHierarchyView.createNode(object);
        nodes.put(object, node);
        for (StructureObject child : new TreeSet(object.getChildren())) {
            ObjectHierarchyView.buildDepTree(trx, child, nodes, edges);
            edges.add(ObjectHierarchyView.createEdge(object, child, nodes));
        }
    }

    protected static org.eclipse.gef.graph.Node createNode(StructureObject object) {
        return new StructureObjectNode(object);
    }

    protected static Edge createEdge(StructureObject parent, StructureObject child, Map<StructureObject, org.eclipse.gef.graph.Node> nodes) {
        org.eclipse.gef.graph.Node from = nodes.get(parent);
        org.eclipse.gef.graph.Node to = nodes.get(child);
        Edge.Builder builder = new Edge.Builder(from, to).attr("element-css-id", (Object)String.format("dependency_%d-%d", parent.getId(), child.getId())).attr("edge-source-decoration", (Object)new Arrow());
        return builder.buildEdge();
    }

    static class Arrow
    extends Polygon {
        public Arrow() {
            super(new double[]{0.0, 0.0, 10.0, 3.0, 10.0, -3.0});
        }
    }
}

