/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.gef.zest.fx.parts;

import de.elpro.ewms.engin.gui.gef.zest.fx.tools.GraphTool;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.zest.fx.ZestProperties;
import org.eclipse.gef.zest.fx.models.HidingModel;
import org.eclipse.gef.zest.fx.parts.NodePart;

public abstract class EwmsNodePart
extends NodePart {
    protected static final double DEFAULT_SHAPE_PADDING = 5.0;
    private static final String DEFAULT_SHAPE_ROLE = "defaultShape";
    public static final String CSS_CLASS_CONTAINER = "container";
    private Group group;
    private javafx.scene.Node shape;
    private Region container;

    protected abstract Region doCreateContainer();

    protected final Group doCreateVisual() {
        this.shape = this.doCreateDefaultShape();
        this.container = this.doCreateContainer();
        this.group = new Group(){

            public boolean isResizable() {
                return true;
            }

            protected void layoutChildren() {
            }

            public double maxHeight(double width) {
                return EwmsNodePart.this.container.maxHeight(width);
            }

            public double maxWidth(double height) {
                return EwmsNodePart.this.container.maxWidth(height);
            }

            public double minHeight(double width) {
                return EwmsNodePart.this.container.minHeight(width);
            }

            public double minWidth(double height) {
                return EwmsNodePart.this.container.minWidth(height);
            }

            public double prefHeight(double width) {
                return EwmsNodePart.this.container.prefHeight(width);
            }

            public double prefWidth(double height) {
                return EwmsNodePart.this.container.prefWidth(height);
            }

            public void resize(double w, double h) {
                EwmsNodePart.this.shape.resize(w, h);
                EwmsNodePart.this.container.setPrefSize(w, h);
                EwmsNodePart.this.container.autosize();
                Bounds vboxBounds = EwmsNodePart.this.container.getLayoutBounds();
                EwmsNodePart.this.container.relocate((w - vboxBounds.getWidth()) / 2.0, (h - vboxBounds.getHeight()) / 2.0);
            }
        };
        ZestProperties.setShape((Node)this.getContent(), (javafx.scene.Node)this.shape);
        this.container.getStyleClass().add((Object)CSS_CLASS_CONTAINER);
        this.container.setPrefSize(-1.0, -1.0);
        this.group.getChildren().addAll((Object[])new javafx.scene.Node[]{this.shape, this.container});
        return this.group;
    }

    protected void doRefreshVisual(Group visual) {
        if (!this.container.getStyleClass().contains((Object)CSS_CLASS_CONTAINER)) {
            this.container.getStyleClass().add((Object)CSS_CLASS_CONTAINER);
        }
        if (this.getShape() != null && DEFAULT_SHAPE_ROLE.equals(this.getShape().getUserData())) {
            this.container.setPadding(new Insets(5.0));
        } else {
            this.container.setPadding(Insets.EMPTY);
        }
        super.doRefreshVisual(visual);
    }

    protected javafx.scene.Node doCreateDefaultShape() {
        GeometryNode shape = new GeometryNode((IGeometry)new Rectangle());
        shape.setUserData((Object)DEFAULT_SHAPE_ROLE);
        shape.getStyleClass().add((Object)"shape");
        shape.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.REFLECT, Arrays.asList(new Stop(0.0, new Color(1.0, 1.0, 1.0, 1.0)))));
        shape.setStroke((Paint)new Color(0.0, 0.0, 0.0, 1.0));
        shape.setStrokeType(StrokeType.INSIDE);
        return shape;
    }

    public javafx.scene.Node getShape() {
        return this.shape;
    }

    public void toggleChildren() {
        List<NodePart> children = GraphTool.getAllChildren(this);
        boolean allChildrenHidden = true;
        HidingModel hidingModel = (HidingModel)this.getRoot().getViewer().getAdapter(HidingModel.class);
        for (NodePart child : children) {
            if (hidingModel.isHidden(child.getContent())) continue;
            allChildrenHidden = false;
            break;
        }
        if (!allChildrenHidden) {
            this.hideAllChildren();
        } else {
            this.showAllChildren();
        }
    }

    public void hideAllChildren() {
        for (NodePart child : GraphTool.getAllChildren(this)) {
            if (!(child instanceof EwmsNodePart)) continue;
            ((EwmsNodePart)child).hide();
        }
    }

    public void showAllChildren() {
        for (NodePart child : GraphTool.getAllChildren(this)) {
            if (!(child instanceof EwmsNodePart)) continue;
            ((EwmsNodePart)child).show();
        }
    }

    public void hide() {
        ((HidingModel)this.getViewer().getAdapter(HidingModel.class)).hide((NodePart)this);
    }

    public void show() {
        ((HidingModel)this.getViewer().getAdapter(HidingModel.class)).show((NodePart)this);
    }
}

