/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.gef.zest.fx.parts;

import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.engin.gui.gef.graph.StructureClassNode;
import de.elpro.ewms.engin.gui.gef.zest.fx.parts.EwmsNodePart;
import java.util.TreeSet;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class StructureClassNodePart
extends EwmsNodePart {
    private VBox vbox;
    private BorderPane content;

    public StructureClassNode getContent() {
        return (StructureClassNode)super.getContent();
    }

    @Override
    protected Region doCreateContainer() {
        this.content = new BorderPane();
        VBox.setVgrow((Node)this.content, (Priority)Priority.ALWAYS);
        this.vbox = new VBox(5.0);
        this.vbox.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        this.vbox.setMouseTransparent(true);
        this.vbox.setAlignment(Pos.TOP_CENTER);
        this.vbox.getChildren().addAll((Object[])new Node[]{this.createHeader(this.getContent().getStructureClass()), new Separator(), this.content});
        return this.vbox;
    }

    @Override
    protected void doRefreshVisual(Group visual) {
        if (!this.getContent().getStructureClass().getVariables().isEmpty()) {
            GridPane grid = new GridPane();
            grid.setHgap(5.0);
            grid.setVgap(5.0);
            int index = 0;
            for (Variable var : new TreeSet(this.getContent().getStructureClass().getVariables())) {
                grid.addRow(index++, new Node[]{var.getGraphic(), new Text(var.toString())});
            }
            this.content.setCenter((Node)grid);
        }
        super.doRefreshVisual(visual);
    }

    private Node createHeader(StructureClass structureClass) {
        Text varName = new Text(structureClass.toString());
        varName.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)12.0));
        return new HBox(5.0, new Node[]{structureClass.getGraphic(), varName}){
            {
                this.setAlignment(Pos.CENTER);
            }
        };
    }
}

