/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.gef.zest.fx.parts;

import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.engin.gui.gef.graph.VariableInstanceNode;
import de.elpro.ewms.engin.gui.gef.zest.fx.parts.EwmsNodePart;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class VariableInstanceNodePart
extends EwmsNodePart {
    private VBox vbox;
    private BorderPane content;

    public VariableInstanceNode getContent() {
        return (VariableInstanceNode)super.getContent();
    }

    @Override
    protected Region doCreateContainer() {
        this.content = new BorderPane();
        this.content.setCenter(this.createFormulaText());
        VBox.setVgrow((Node)this.content, (Priority)Priority.ALWAYS);
        this.vbox = new VBox(5.0);
        this.vbox.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        this.vbox.setMouseTransparent(true);
        this.vbox.setAlignment(Pos.TOP_CENTER);
        this.vbox.getChildren().addAll((Object[])new Node[]{this.createHeader(this.getContent().getVariableInstance()), this.content});
        return this.vbox;
    }

    @Override
    protected void doRefreshVisual(Group visual) {
        this.content.setCenter(this.createFormulaText());
        super.doRefreshVisual(visual);
    }

    private Node createFormulaText() {
        if (this.getContent().getVariableInstance().getType() == VariableInstanceType.Calculated) {
            BorderPane pane = new BorderPane();
            String formula = this.getContent().getVariableInstance().getResultCalculationFormula();
            HBox box = new HBox(new Node[]{new Text(formula)});
            box.setAlignment(Pos.TOP_LEFT);
            box.setPadding(new Insets(5.0));
            pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, null)}));
            pane.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.THIN)}));
            pane.setCenter((Node)box);
            return pane;
        }
        return null;
    }

    private Node createHeader(VariableInstance instance) {
        VBox box = new VBox();
        box.setAlignment(Pos.CENTER);
        Text varName = new Text(instance.getVariable().toString());
        varName.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)12.0));
        box.getChildren().add((Object)new HBox(5.0, new Node[]{instance.getGraphic(), varName}){
            {
                this.setAlignment(Pos.CENTER);
            }
        });
        Separator sep = new Separator();
        box.getChildren().add((Object)sep);
        Text objName = new Text(instance.getStructureObject().toString());
        objName.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)10.0));
        box.getChildren().add((Object)new BorderPane((Node)new HBox(5.0, new Node[]{instance.getStructureObject().getGraphic(), objName}){
            {
                this.setAlignment(Pos.CENTER);
            }
        }));
        return box;
    }
}

