/*
 * Decompiled with CFR 0.152.
 */
package de.elrpo.ewms.engin.gui.preferences.extensions;

import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.gui.preferences.model.IPreferenceDefinition;
import de.elpro.ewms.gui.preferences.model.PreferenceEditor;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.propertysheet.LocalDateTimePropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.model.LabeledElement;
import de.elpro.ui.model.UILabeledElement;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;

public class CoreDataPreferencesEditorDefinition
implements IPreferenceDefinition {
    public static final String ID = "de.elpro.ewms.engin.gui.server.coredata.prefs";

    public String getId() {
        return ID;
    }

    public String getParentId() {
        return "de.elpro.ewms.engin.gui.server.pref";
    }

    public UILabeledElement getNavigationElement() {
        return new LabeledElement("Core Data Range");
    }

    public PreferenceEditor createEditor(Window rootWindow) {
        return new CoreDataPreferenceEditor(rootWindow);
    }

    private static class CoreDataPreferenceEditor
    extends PreferenceEditor {
        private static final String LOW_RES_DATA = "Low Resolution Core Data";
        private static final String HIGH_RES_DATA = "High Resolution Core Data";
        private final SimpleObjectProperty<LocalDateTime> lowResCoreStart = new SimpleObjectProperty();
        private final SimpleObjectProperty<LocalDateTime> lowResCoreEnd = new SimpleObjectProperty();
        private final PropertySheet propertySheet = new PropertySheet();
        private final ProgressIndicatorPane progressIndicator = new ProgressIndicatorPane((Node)this.propertySheet);

        public CoreDataPreferenceEditor(Window window) {
            super(window);
        }

        protected Node createEditor() {
            TimeRange lowResRange = ServerDAO.getGlobalViewTimeRange();
            this.lowResCoreStart.setValue((Object)LocalDateTime.ofInstant(lowResRange.getFrom(), ZoneId.systemDefault()));
            this.lowResCoreEnd.setValue((Object)LocalDateTime.ofInstant(lowResRange.getTo(), ZoneId.systemDefault()));
            LocalDateTimePropertyItem lowResCoreStartItem = new LocalDateTimePropertyItem(LOW_RES_DATA, "Compute from", this.lowResCoreStart);
            LocalDateTimePropertyItem lowResCoreEndItem = new LocalDateTimePropertyItem(LOW_RES_DATA, "Compute to", this.lowResCoreEnd);
            lowResCoreEndItem.setReadOnly(true);
            this.propertySheet.getItems().addAll((Object[])new PropertySheet.Item[]{lowResCoreStartItem, lowResCoreEndItem});
            this.hasChangesProperty().bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.propertySheet.getItems()));
            this.canSaveProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.propertySheet.getItems())));
            return this.progressIndicator;
        }

        public void save() {
            try {
                Instant newLowResStart = ZonedDateTime.of((LocalDateTime)this.lowResCoreStart.get(), ZoneId.systemDefault()).toInstant();
                ServerDAO.setGlobalViewCoreDataStart((long)newLowResStart.toEpochMilli());
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.initOwner(this.getRootWindow());
                alert.setContentText("Server need to be restarted to apply changes!");
                alert.show();
            }
            catch (DAOOperationException exc) {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.show();
            }
        }

        public void discardChanges() {
        }
    }
}

