/*
 * Decompiled with CFR 0.152.
 */
package de.elrpo.ewms.engin.gui.preferences.extensions;

import de.elpro.ewms.core.client.preferences.Preferences;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ewms.core.virtualtime.ZoneIdWithOffset;
import de.elpro.ewms.gui.preferences.model.IPreferenceDefinition;
import de.elpro.ewms.gui.preferences.model.PreferenceEditor;
import de.elpro.resources.Icons;
import de.elpro.ui.fx.cells.editable.EditableInstantTableCell;
import de.elpro.ui.fx.cells.editable.TextFieldTableCell;
import de.elpro.ui.model.LabeledElement;
import de.elpro.ui.model.UILabeledElement;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.ImageView;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class VirtualRasterPreferenceEditorDefinition
implements IPreferenceDefinition {
    public static final String ID = "de.elpro.ewms.engin.gui.server.virtualraster.prefs";

    public String getId() {
        return ID;
    }

    public String getParentId() {
        return "de.elpro.ewms.engin.gui.server.pref";
    }

    public UILabeledElement getNavigationElement() {
        return new LabeledElement("Virtual Raster");
    }

    public PreferenceEditor createEditor(Window rootWindow) {
        return new VirtualRasterPreferenceEditor(rootWindow);
    }

    private static class VirtualRasterPreferenceEditor
    extends PreferenceEditor {
        private final TableView<VirtualRasterUIModel> table = new TableView();
        private final TableColumn<VirtualRasterUIModel, Instant> fromColumn = new TableColumn("From");
        private final TableColumn<VirtualRasterUIModel, ZoneId> zoneIdColumn = new TableColumn("Zone Id");
        private final TableColumn<VirtualRasterUIModel, ZoneOffset> zoneOffsetColumn = new TableColumn("Zone Offset");

        public VirtualRasterPreferenceEditor(Window rootWindow) {
            super(rootWindow);
        }

        public Node createEditor() {
            VirtualZone virtualZone = Preferences.getVirtualZone();
            SimpleBooleanProperty changed = new SimpleBooleanProperty(false);
            for (Map.Entry entry : virtualZone.getZoneOffsets().entrySet()) {
                VirtualRasterUIModel model = new VirtualRasterUIModel((Instant)entry.getKey(), ((ZoneIdWithOffset)entry.getValue()).getZoneId(), ((ZoneIdWithOffset)entry.getValue()).getZoneOffset());
                this.table.getItems().add((Object)model);
                changed = Bindings.or((ObservableBooleanValue)changed, (ObservableBooleanValue)model.hasChanges);
                model.from.addListener((o, ov, nv) -> this.sort());
                this.canSaveProperty().set(true);
            }
            changed.addListener((o, ov, nv) -> this.hasChangesProperty().set(true));
            this.fromColumn.setCellValueFactory(cf -> ((VirtualRasterUIModel)cf.getValue()).from);
            this.zoneIdColumn.setCellValueFactory(cf -> ((VirtualRasterUIModel)cf.getValue()).zoneId);
            this.zoneOffsetColumn.setCellValueFactory(cf -> ((VirtualRasterUIModel)cf.getValue()).zoneOffset);
            this.fromColumn.setCellFactory(cf -> new EditableInstantTableCell());
            this.zoneIdColumn.setCellFactory(cf -> new TextFieldTableCell((StringConverter)new StringConverter<ZoneId>(){

                public String toString(ZoneId object) {
                    return object.toString();
                }

                public ZoneId fromString(String string) {
                    return ZoneId.of(string);
                }
            }));
            this.zoneOffsetColumn.setCellFactory(cf -> new TextFieldTableCell((StringConverter)new StringConverter<ZoneOffset>(){

                public String toString(ZoneOffset object) {
                    return object.toString();
                }

                public ZoneOffset fromString(String string) {
                    return ZoneOffset.of(string);
                }
            }));
            MenuItem addElement = new MenuItem("Add", (Node)new ImageView(Icons.ADD_ITEM_URL.toString()));
            addElement.setOnAction(e -> {
                VirtualRasterUIModel last = null;
                if (!this.table.getItems().isEmpty()) {
                    last = (VirtualRasterUIModel)this.table.getItems().get(this.table.getItems().size() - 1);
                }
                VirtualRasterUIModel model = null;
                model = last != null ? new VirtualRasterUIModel(((Instant)last.from.get()).plus(1L, ChronoUnit.DAYS), (ZoneId)last.zoneId.get(), (ZoneOffset)last.zoneOffset.get()) : new VirtualRasterUIModel(Instant.ofEpochMilli(0L), ZoneId.systemDefault(), ZoneOffset.UTC);
                model.from.addListener((o, ov, nv) -> this.sort());
                this.table.getItems().add((Object)model);
                this.sort();
                this.hasChangesProperty().set(true);
                this.canSaveProperty().set(!this.table.getItems().isEmpty());
            });
            MenuItem removeElement = new MenuItem("Remove", (Node)new ImageView(Icons.DELETE_ITEM_URL.toString()));
            removeElement.setOnAction(e -> {
                VirtualRasterUIModel selectedItem = (VirtualRasterUIModel)this.table.getSelectionModel().getSelectedItem();
                if (selectedItem != null) {
                    this.table.getItems().remove((Object)selectedItem);
                }
                this.hasChangesProperty().set(true);
                this.canSaveProperty().set(!this.table.getItems().isEmpty());
            });
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{addElement, removeElement});
            this.table.setEditable(true);
            this.table.setContextMenu(contextMenu);
            this.table.getColumns().addAll((Object[])new TableColumn[]{this.fromColumn, this.zoneIdColumn, this.zoneOffsetColumn});
            return this.table;
        }

        private void sort() {
            this.table.getItems().sort((Comparator)new Comparator<VirtualRasterUIModel>(){

                @Override
                public int compare(VirtualRasterUIModel o1, VirtualRasterUIModel o2) {
                    return ((Instant)o1.from.get()).compareTo((Instant)o2.from.get());
                }
            });
        }

        public void save() {
            VirtualZone virtualZone = new VirtualZone();
            for (VirtualRasterUIModel model : this.table.getItems()) {
                virtualZone.addZoneOffset((Instant)model.from.get(), (ZoneId)model.zoneId.get(), (ZoneOffset)model.zoneOffset.get());
            }
            Preferences.setVirtualZone((VirtualZone)virtualZone);
            VirtualZone.INSTANCE.setZoneOffsets(Preferences.getVirtualZone().getZoneOffsets());
        }

        public void discardChanges() {
        }
    }

    private static class VirtualRasterUIModel {
        private SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
        private final SimpleObjectProperty<Instant> from = new SimpleObjectProperty();
        private final SimpleObjectProperty<ZoneId> zoneId = new SimpleObjectProperty();
        private final SimpleObjectProperty<ZoneOffset> zoneOffset = new SimpleObjectProperty();

        public VirtualRasterUIModel(Instant from, ZoneId zoneId, ZoneOffset zoneOffset) {
            this.from.set((Object)from);
            this.zoneId.set((Object)zoneId);
            this.zoneOffset.set((Object)zoneOffset);
            this.from.addListener((o, ov, nv) -> this.hasChanges.set(true));
            this.zoneId.addListener((o, ov, nv) -> this.hasChanges.set(true));
            this.zoneOffset.addListener((o, ov, nv) -> this.hasChanges.set(true));
        }
    }
}

