/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface;

public final class StatusCode {
    private static final long SEVERITY_MASK = 0xC0000000L;
    private static final long SEVERITY_GOOD = 0L;
    private static final long SEVERITY_UNCERTAIN = 0x40000000L;
    private static final long SEVERITY_BAD = 0x80000000L;
    public static final StatusCode GOOD = new StatusCode(0L);
    public static final StatusCode BAD = new StatusCode(0x80000000L);
    private final long value;

    public StatusCode(long value) {
        this.value = value;
    }

    public StatusCode(int value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public boolean isGood() {
        return (this.value & 0xC0000000L) == 0L;
    }

    public boolean isBad() {
        return (this.value & 0xC0000000L) == 0x80000000L;
    }

    public boolean isUncertain() {
        return (this.value & 0xC0000000L) == 0x40000000L;
    }

    public StatusCode withOverflow() {
        return new StatusCode(this.value | 0x480L);
    }

    public StatusCode withoutOverflow() {
        return new StatusCode(this.value & 0xFFFFFFFFFFFFFB7FL);
    }

    public boolean isOverflowSet() {
        return (this.value & 0x480L) == 1152L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusCode that = (StatusCode)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    private static String quality(StatusCode statusCode) {
        if (statusCode.isGood()) {
            return "good";
        }
        if (statusCode.isBad()) {
            return "bad";
        }
        if (statusCode.isUncertain()) {
            return "uncertain";
        }
        return "unknown";
    }
}

