/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.handlers;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataGroupDAO;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import de.elpro.ui.model.UIModelElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontFormatting;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.osgi.service.prefs.BackingStoreException;

public class ExportVariableInstancesToExcel {
    private static final IEclipsePreferences prefNode = InstanceScope.INSTANCE.getNode("gui-prefs");
    private static final String itemName = "ArchiveVariables";
    private Stage stage;
    private CreationHelper creationHelper;
    private CellStyle lockedHeaderStyle;
    private CellStyle lockedRedHeaderStyle;
    private CellStyle unlockedCellStyle;
    private CellStyle unlockedRedCellStyle;
    private CellStyle lockedCellStyle;
    private CellStyle lockedBoldCellStyle;
    private CellStyle lockedRedCellStyle;
    private CellStyle lockedRedSumCellStyle;
    private Font f1;
    private Font f2;
    private Font f3;
    public static ImmutableMap<String, ExportImportColumn> exportImportColumns = ImmutableMap.builder().put((Object)"instanceId", (Object)new ExportImportColumn("Instance Id", true, false, 0)).put((Object)"varName", (Object)new ExportImportColumn("Variable Name", true, false, 1)).put((Object)"location", (Object)new ExportImportColumn("Location", true, false, 2)).put((Object)"varDescription", (Object)new ExportImportColumn("Variable Desription", true, false, 3)).put((Object)"instanceDescription", (Object)new ExportImportColumn("Instance Description", false, false, 4)).put((Object)"opcId", (Object)new ExportImportColumn("OPC-Identifier", false, false, 5)).put((Object)"resultOpcId", (Object)new ExportImportColumn("Result OPC-Identifier", false, false, 6)).put((Object)"dataGroup", (Object)new ExportImportColumn("Data Group", false, false, 7)).put((Object)"dataSource", (Object)new ExportImportColumn("OPC Server", false, false, 8)).put((Object)"plcMeasuringUnitSource", (Object)new ExportImportColumn("Plc Measuring Unit Source", false, false, 9)).put((Object)"plcMeasuringUnit", (Object)new ExportImportColumn("Plc MeasuringUnitId", false, false, 10)).build();

    @Execute
    public void execute(Stage stage) {
        this.stage = stage;
        final ExportConfig exportConfig = this.getExcelFile(itemName);
        if (exportConfig.myWorkbook == null) {
            return;
        }
        this.setExcelProperties(exportConfig.myWorkbook);
        this.setSummarySheet(exportConfig);
        CallableTask<Void> task = new CallableTask<Void>(){

            public Void call() throws Exception {
                try {
                    ExportVariableInstancesToExcel.this.createSheets(exportConfig);
                    exportConfig.myWorkbook.write((OutputStream)exportConfig.fos);
                    exportConfig.fos.close();
                    exportConfig.myWorkbook.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        TaskUtils.executeUITask((CallableTask)task).consumeResult((arg_0, arg_1) -> ExportVariableInstancesToExcel.lambda$0((CallableTask)task, arg_0, arg_1));
    }

    private ExportConfig getExcelFile(String itemName) {
        ExportConfig exportConfig = new ExportConfig();
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter xlsxExtFilter = new FileChooser.ExtensionFilter("EXCEL files (*.xlsx)", new String[]{"*.xlsx"});
        FileChooser.ExtensionFilter xlsExtFilter = new FileChooser.ExtensionFilter("EXCEL files (*.xls)", new String[]{"*.xls"});
        fileChooser.getExtensionFilters().add((Object)xlsxExtFilter);
        fileChooser.getExtensionFilters().add((Object)xlsExtFilter);
        String exportPath = prefNode.get("ArchiveVariableExportPath", System.getProperty("user.home"));
        File exportFolder = new File(exportPath);
        if (!exportFolder.exists() || !exportFolder.isDirectory()) {
            exportFolder = new File(System.getProperty("user.home"));
        }
        fileChooser.setInitialDirectory(exportFolder);
        fileChooser.setInitialFileName(String.format("%s", itemName));
        File file = fileChooser.showSaveDialog((Window)this.stage);
        ButtonType bt = null;
        do {
            try {
                if (file == null) continue;
                exportConfig.fileName = file.getName();
                String folderName = file.isDirectory() ? file.getPath() : file.getParent();
                prefNode.put("ArchiveVariableExportPath", folderName);
                try {
                    prefNode.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                exportConfig.fos = new FileOutputStream(file);
                exportConfig.myWorkbook = Files.getFileExtension((String)file.getName()).equals("xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
                bt = ButtonType.FINISH;
            }
            catch (Exception exc) {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.stage.getScene().getWindow());
                dlg.setHeaderText("Fehler!");
                dlg.setContentText("Unbehandelter Fehler beim Speichern der EXCEL-Datei.\nM\u00f6chten sie es nochmal versuchen?");
                dlg.showAndWait();
                bt = (ButtonType)dlg.getResult();
                if (bt != null) continue;
                bt = ButtonType.OK;
            }
        } while (bt != null && bt == ButtonType.OK);
        return exportConfig;
    }

    private void setExcelProperties(Workbook myWorkbook) {
        this.creationHelper = myWorkbook.getCreationHelper();
        this.f1 = myWorkbook.createFont();
        this.f1.setFontName("Arial");
        this.f1.setFontHeightInPoints((short)12);
        this.f1.setBold(true);
        this.f2 = myWorkbook.createFont();
        this.f2.setFontName("Arial");
        this.f2.setFontHeightInPoints((short)10);
        this.f2.setBold(false);
        this.f3 = myWorkbook.createFont();
        this.f3.setFontName("Arial");
        this.f3.setFontHeightInPoints((short)10);
        this.f3.setBold(true);
        this.lockedHeaderStyle = myWorkbook.createCellStyle();
        this.lockedHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
        this.lockedHeaderStyle.setFont(this.f1);
        this.lockedHeaderStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        this.lockedHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.lockedHeaderStyle.setLocked(true);
        this.lockedRedHeaderStyle = myWorkbook.createCellStyle();
        this.lockedRedHeaderStyle.setAlignment(HorizontalAlignment.CENTER);
        this.lockedRedHeaderStyle.setFont(this.f1);
        this.lockedRedHeaderStyle.setFillForegroundColor(IndexedColors.ROSE.getIndex());
        this.lockedRedHeaderStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.lockedRedHeaderStyle.setLocked(true);
        this.unlockedCellStyle = myWorkbook.createCellStyle();
        this.unlockedCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.unlockedCellStyle.setFont(this.f2);
        this.unlockedCellStyle.setLocked(false);
        this.unlockedRedCellStyle = myWorkbook.createCellStyle();
        this.unlockedRedCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.unlockedRedCellStyle.setFont(this.f2);
        this.unlockedRedCellStyle.setLocked(false);
        this.lockedCellStyle = myWorkbook.createCellStyle();
        this.lockedCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.lockedCellStyle.setFont(this.f2);
        this.lockedCellStyle.setLocked(true);
        this.lockedBoldCellStyle = myWorkbook.createCellStyle();
        this.lockedBoldCellStyle.setBorderTop(BorderStyle.MEDIUM);
        this.lockedBoldCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.lockedBoldCellStyle.setFont(this.f3);
        this.lockedBoldCellStyle.setLocked(true);
        this.lockedRedCellStyle = myWorkbook.createCellStyle();
        this.lockedRedCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.lockedRedCellStyle.setFont(this.f2);
        this.lockedRedCellStyle.setLocked(true);
        this.lockedRedSumCellStyle = myWorkbook.createCellStyle();
        this.lockedRedSumCellStyle.setBorderTop(BorderStyle.MEDIUM);
        this.lockedRedSumCellStyle.setAlignment(HorizontalAlignment.LEFT);
        this.lockedRedSumCellStyle.setFont(this.f2);
        this.lockedRedSumCellStyle.setLocked(true);
    }

    private void createSheets(ExportConfig exportConfig) {
        TreeNode structureRootNode = new TreeNode();
        HashMap<Integer, StructureObject> structureObjectMap = new HashMap<Integer, StructureObject>();
        TreeMap<String, StructureObject> sortedStructureObjectMap = new TreeMap<String, StructureObject>();
        Transaction trx = Transactions.begin();
        try {
            try {
                TreeMap<String, StructureObject> so = new TreeMap<String, StructureObject>();
                StructureObject[] structureObjectArray = StructureObjectDAO.getRoots((Transaction)trx);
                int n = structureObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StructureObject structureObject = structureObjectArray[n2];
                    so.put(structureObject.getLocalName(), structureObject);
                    ++n2;
                }
                for (StructureObject structureObject : so.values()) {
                    if (structureObjectMap.containsKey(structureObject.getId())) continue;
                    structureObjectMap.put(structureObject.getId(), structureObject);
                    sortedStructureObjectMap.put(structureObject.getName(), structureObject);
                    this.getStructure(trx, structureObject, structureRootNode, structureObjectMap);
                }
                String format = null;
                format = String.format("C2:E%d", structureObjectMap.size() + 1);
                SheetConditionalFormatting condFormatting = exportConfig.summarySheet.getSheetConditionalFormatting();
                ConditionalFormattingRule rule = condFormatting.createConditionalFormattingRule((byte)5, "0");
                FontFormatting ff = rule.createFontFormatting();
                ff.setFontColorIndex((short)10);
                ff.setFontStyle(true, true);
                CellRangeAddress[] regions = new CellRangeAddress[]{CellRangeAddress.valueOf((String)format)};
                condFormatting.addConditionalFormatting(regions, rule);
                exportConfig.dropDownListsSheet = exportConfig.myWorkbook.createSheet("Dropdownlists");
                Row choiceRow = exportConfig.dropDownListsSheet.createRow(0);
                choiceRow.createCell(0).setCellValue("Variable");
                choiceRow.createCell(1).setCellValue("InstancePLC");
                choiceRow.createCell(2).setCellValue("VariablePLC");
                Name name = exportConfig.myWorkbook.createName();
                name.setRefersToFormula("Dropdownlists!$A$1:$C$1");
                name.setNameName("UnitSource");
                for (TreeNode structureTreeNode : structureRootNode.getChildren()) {
                    StructureObject structureObject = (StructureObject)structureTreeNode.getData();
                    if (structureTreeNode.getChildren().isEmpty()) continue;
                    Sheet sheet = this.createSheetAndHeadline(exportConfig, structureObject);
                    ++exportConfig.rootRowIndex;
                    Row summaryRow = exportConfig.summarySheet.createRow(exportConfig.summaryRowIndex);
                    List<TreeNode> varTreeNodes = structureTreeNode.getChildren();
                    for (TreeNode varTreeNode : varTreeNodes) {
                        VariableInstance variableInstance = (VariableInstance)varTreeNode.getData();
                        Row row = sheet.createRow(exportConfig.rootRowIndex);
                        Variable variable = variableInstance.getVariable();
                        Integer groupId = null;
                        DataGroup opcGroup = null;
                        DataSource opcServer = null;
                        if (variableInstance.getResultPlcDataGroup() != null && (groupId = variableInstance.getResultPlcDataGroup().getId()) != null && (opcGroup = DataGroupDAO.get((Transaction)trx, (int)groupId)) != null) {
                            opcServer = DataSourceDAO.get((Transaction)trx, (int)opcGroup.getDataSource().getId());
                        }
                        try {
                            String measUnit;
                            String plcMeasuringUnitSource = MeasuringUnit.CONVERTER.toString((Object)variableInstance.getPlcSourceMU());
                            String string = plcMeasuringUnitSource = plcMeasuringUnitSource != null && !plcMeasuringUnitSource.isEmpty() ? "InstancePLC" : "VariablePLC";
                            if (plcMeasuringUnitSource.equals("InstancePLC")) {
                                measUnit = MeasuringUnit.CONVERTER.toString((Object)variableInstance.getPlcSourceMU());
                            } else {
                                measUnit = MeasuringUnit.CONVERTER.toString((Object)variable.getPlcSourceMU());
                                if (measUnit == null || measUnit.isEmpty()) {
                                    measUnit = MeasuringUnit.CONVERTER.toString((Object)variable.getMeasuringUnit());
                                    plcMeasuringUnitSource = "Variable";
                                }
                            }
                            String varDescription = variable.getDescription();
                            String instanceDescription = variableInstance.getDescription();
                            String dataSourceKey = variableInstance.getPlcDatasourceKey() != null && !variableInstance.getPlcDatasourceKey().trim().isEmpty() ? variableInstance.getPlcDatasourceKey() : null;
                            String resultDataSourceKey = variableInstance.getResultPlcDatasourceKey() != null && !variableInstance.getResultPlcDatasourceKey().trim().isEmpty() ? variableInstance.getResultPlcDatasourceKey() : null;
                            for (Map.Entry exportColumn : exportImportColumns.entrySet()) {
                                switch ((String)exportColumn.getKey()) {
                                    case "varName": {
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), variable.toString(), row);
                                        break;
                                    }
                                    case "location": {
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), ((StructureObject)structureObjectMap.get(variableInstance.getStructureObject().getId())).toString(), row);
                                        break;
                                    }
                                    case "varDescription": {
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), varDescription, row);
                                        break;
                                    }
                                    case "instanceDescription": {
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), instanceDescription, row);
                                        break;
                                    }
                                    case "opcId": {
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), dataSourceKey, row);
                                        break;
                                    }
                                    case "resultOpcId": {
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), resultDataSourceKey, row);
                                        break;
                                    }
                                    case "dataGroup": {
                                        String dataGroupId = opcGroup != null ? opcGroup.getName() : null;
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), dataGroupId, row);
                                        break;
                                    }
                                    case "dataSource": {
                                        String dataServerId = opcServer != null ? opcServer.getName() : null;
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), dataServerId, row);
                                        break;
                                    }
                                    case "plcMeasuringUnitSource": {
                                        this.createLinkedDropdownListCell(exportConfig, (ExportImportColumn)exportColumn.getValue(), plcMeasuringUnitSource, row, sheet);
                                        break;
                                    }
                                    case "plcMeasuringUnit": {
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), measUnit, row);
                                        break;
                                    }
                                    case "instanceId": {
                                        this.createExportCell((ExportImportColumn)exportColumn.getValue(), variableInstance.getId().toString(), row);
                                    }
                                }
                            }
                            ++exportConfig.rootRowIndex;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.createHyperlinkCell(exportConfig, 0, summaryRow, this.lockedCellStyle, sheet.getSheetName());
                    String formel = String.format("COUNTA('%s'!A:A)-1", sheet.getSheetName());
                    this.createSummaryFormulaCell(exportConfig, 1, summaryRow, this.lockedCellStyle, formel);
                    formel = String.format("B%d-(COUNTA('%s'!G:G)-1)", exportConfig.summaryRowIndex + 1, sheet.getSheetName());
                    this.createSummaryFormulaCell(exportConfig, 2, summaryRow, this.lockedRedCellStyle, formel);
                    formel = String.format("B%d-(COUNTA('%s'!H:H)-1)", exportConfig.summaryRowIndex + 1, sheet.getSheetName());
                    this.createSummaryFormulaCell(exportConfig, 3, summaryRow, this.lockedRedCellStyle, formel);
                    formel = String.format("B%d-(COUNTA('%s'!I:I)-1)", exportConfig.summaryRowIndex + 1, sheet.getSheetName());
                    this.createSummaryFormulaCell(exportConfig, 4, summaryRow, this.lockedRedCellStyle, formel);
                    ++exportConfig.summaryRowIndex;
                    int colIndex = 0;
                    while (colIndex < exportImportColumns.size()) {
                        sheet.autoSizeColumn(colIndex);
                        ++colIndex;
                    }
                    sheet.protectSheet("");
                    ++exportConfig.sheetIndex;
                }
                exportConfig.myWorkbook.setSheetOrder("Dropdownlists", exportConfig.sheetIndex);
                exportConfig.myWorkbook.setSheetHidden(exportConfig.sheetIndex++, true);
                Row summaryRow = exportConfig.summarySheet.createRow(exportConfig.summaryRowIndex);
                int col = 65;
                int i = 0;
                while (i <= 4) {
                    exportConfig.summarySheet.autoSizeColumn(i);
                    if (i > 0) {
                        char c = (char)(col + i);
                        String formel = String.format("sum(%s1:%s%d)", Character.valueOf(c), Character.valueOf(c), exportConfig.summaryRowIndex);
                        this.createSummaryFormulaCell(exportConfig, i, summaryRow, this.lockedRedSumCellStyle, formel);
                    } else {
                        this.createSummaryCell(exportConfig, 0, summaryRow, this.lockedBoldCellStyle, "Sum");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private void getStructure(Transaction trx, StructureObject element, TreeNode structureRootNode, Map<Integer, StructureObject> structureObjectMap) {
        if (element != null) {
            StructureObject[] structureObjects;
            int n;
            TreeNode structureTreeNode = new TreeNode((UIModelElement)element);
            VariableInstance[] variableInstances = VariableInstanceDAO.getAll((Transaction)trx, (StructureObject)element);
            if (variableInstances != null && variableInstances.length > 0) {
                VariableInstance[] variableInstanceArray = variableInstances;
                n = variableInstances.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableInstance varInstance = variableInstanceArray[n2];
                    if (varInstance.getType() == VariableInstanceType.PLC) {
                        varInstance.setVariable(VariableDAO.get((Transaction)trx, (int)varInstance.getVariable().getId()));
                        varInstance.setStructureObject(element);
                        TreeNode varTreeNode = new TreeNode((UIModelElement)varInstance);
                        structureTreeNode.add(varTreeNode);
                    }
                    ++n2;
                }
                structureRootNode.add(structureTreeNode);
            }
            if ((structureObjects = StructureObjectDAO.getAllChildren((Transaction)trx, (StructureObject)element)) == null || structureObjects.length < 1) {
                return;
            }
            StructureObject[] structureObjectArray = structureObjects;
            int n3 = structureObjects.length;
            n = 0;
            while (n < n3) {
                StructureObject structureObject = structureObjectArray[n];
                if (!structureObjectMap.containsKey(structureObject.getId())) {
                    structureObjectMap.put(structureObject.getId(), structureObject);
                    this.getStructure(trx, structureObject, structureRootNode, structureObjectMap);
                }
                ++n;
            }
        }
    }

    private Sheet createSheetAndHeadline(ExportConfig exportConfig, StructureObject sto) {
        Sheet sheet = null;
        try {
            String sheetName = sto.getKey() != null && !sto.getKey().isBlank() ? String.format("%s (key %s)", sto, sto.getKey()) : String.format("%s (id %d)", sto, sto.getId());
            sheetName = sheetName.replace('/', '_');
            sheet = exportConfig.myWorkbook.createSheet(sheetName);
            exportConfig.rootRowIndex = 0;
            Row row = sheet.createRow(exportConfig.rootRowIndex);
            for (Map.Entry exportColumn : exportImportColumns.entrySet()) {
                Cell cell = this.createExportCell((ExportImportColumn)exportColumn.getValue(), ((ExportImportColumn)exportColumn.getValue()).getHeader(), row);
                cell.setCellStyle(this.lockedHeaderStyle);
                sheet.setColumnHidden(((ExportImportColumn)exportColumn.getValue()).getPosition().intValue(), ((ExportImportColumn)exportColumn.getValue()).isHidden());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sheet;
    }

    private Cell createExportCell(ExportImportColumn exportColumn, String text, Row row) {
        Cell cell = row.createCell(exportColumn.getPosition().intValue());
        try {
            cell.setCellValue(text);
            if (exportColumn.isReadOnly()) {
                cell.setCellStyle(this.lockedCellStyle);
            } else {
                cell.setCellStyle(this.unlockedCellStyle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cell;
    }

    private void createSummaryCell(ExportConfig exportConfig, int column, Row row, CellStyle style, String value) {
        try {
            Cell cell = row.createCell(column);
            cell.setCellValue(value);
            if (style != null) {
                cell.setCellStyle(style);
            }
            exportConfig.summarySheet.autoSizeColumn(column);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createSummaryFormulaCell(ExportConfig exportConfig, int column, Row row, CellStyle style, String formula) {
        try {
            Cell cell = row.createCell(column);
            cell.setCellFormula(formula);
            if (style != null) {
                cell.setCellStyle(style);
            }
            exportConfig.summarySheet.autoSizeColumn(column);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createHyperlinkCell(ExportConfig exportConfig, int column, Row row, CellStyle style, String value) {
        try {
            Cell cell = row.createCell(column);
            cell.setCellFormula(String.format("HYPERLINK(\"[%s]'%s'!A2\",\"%s\")", exportConfig.fileName, value, value));
            if (style != null) {
                cell.setCellStyle(style);
            }
            exportConfig.summarySheet.autoSizeColumn(column);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createLinkedDropdownListCell(ExportConfig exportConfig, ExportImportColumn exportColumn, String text, Row row, Sheet sheet) {
        CellRangeAddressList addressList = new CellRangeAddressList(exportConfig.rootRowIndex, exportConfig.rootRowIndex, exportColumn.getPosition().intValue(), exportColumn.getPosition().intValue());
        DataValidationHelper dvHelper = sheet.getDataValidationHelper();
        DataValidationConstraint dvConstraint = dvHelper.createFormulaListConstraint("UnitSource");
        DataValidation validation = dvHelper.createValidation(dvConstraint, addressList);
        sheet.addValidationData(validation);
        Cell cell = row.createCell(exportColumn.getPosition().intValue());
        try {
            cell.setCellValue(text);
            if (exportColumn.isReadOnly()) {
                cell.setCellStyle(this.lockedCellStyle);
            } else {
                cell.setCellStyle(this.unlockedCellStyle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSummarySheet(ExportConfig exportConfig) {
        exportConfig.summaryRowIndex = 0;
        exportConfig.summarySheet = exportConfig.myWorkbook.createSheet("Summary");
        Row row = exportConfig.summarySheet.createRow(exportConfig.summaryRowIndex);
        this.createSummaryCell(exportConfig, 0, row, this.lockedHeaderStyle, "Location of Variableinstances");
        this.createSummaryCell(exportConfig, 1, row, this.lockedHeaderStyle, "count of Variableinstances");
        this.createSummaryCell(exportConfig, 2, row, this.lockedHeaderStyle, "not assigned OPC-Identifiers");
        this.createSummaryCell(exportConfig, 3, row, this.lockedHeaderStyle, "not assigned OPC-Groups");
        this.createSummaryCell(exportConfig, 4, row, this.lockedHeaderStyle, "not assigned OPC-Servers");
        ++exportConfig.summaryRowIndex;
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && item.getValue() instanceof DataSource;
    }

    private static /* synthetic */ void lambda$0(CallableTask callableTask, Worker.State status, Void result) {
        Platform.runLater(() -> TaskUtils.removeTaskFromView((CallableTask)callableTask));
    }

    private static class ExportConfig {
        private String fileName;
        private Workbook myWorkbook;
        private FileOutputStream fos;
        private int sheetIndex = 0;
        private int rootRowIndex = 0;
        private Sheet dropDownListsSheet;
        private Sheet summarySheet;
        private int summaryRowIndex = 0;

        private ExportConfig() {
        }
    }

    public static class ExportImportColumn {
        private String header;
        private boolean readOnly;
        private boolean hidden;
        private Integer position;
        private String value;

        public ExportImportColumn(String header, boolean ro, boolean hidden, Integer position) {
            this.header = header;
            this.readOnly = ro;
            this.hidden = hidden;
            this.position = position;
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setHeader(String header) {
            this.header = header;
        }

        public void setRo(boolean ro) {
            this.readOnly = ro;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Integer getPosition() {
            return this.position;
        }

        public void setPosition(Integer position) {
            this.position = position;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }
    }

    private class TreeNode
    implements Comparable<Object> {
        private UIModelElement data;
        private List<TreeNode> children = new ArrayList<TreeNode>();

        public TreeNode() {
        }

        public TreeNode(UIModelElement element) {
            this();
            this.data = element;
        }

        public UIModelElement getData() {
            return this.data;
        }

        public void add(TreeNode element) {
            this.children.add(element);
            Collections.sort(this.children);
        }

        private List<TreeNode> getChildren() {
            return this.children;
        }

        @Override
        public int compareTo(Object o) {
            if (this.data instanceof VariableInstance) {
                String name = ((VariableInstance)this.data).getVariable().toString().toUpperCase();
                return name.compareTo(((VariableInstance)((TreeNode)o).getData()).getVariable().toString().toUpperCase());
            }
            return ((String)this.data.textProperty().getValue()).toUpperCase().compareTo(((String)((TreeNode)o).getData().textProperty().getValue()).toUpperCase());
        }
    }
}

