/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.handlers;

import com.google.common.collect.ImmutableMap;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataGroupDAO;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.engin.gui.system.processinterface.handlers.ExportVariableInstancesToExcel;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.scene.control.TreeItem;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.prefs.BackingStoreException;

public class ImportVariableInstancesFromExcel {
    private static final IEclipsePreferences prefNode = InstanceScope.INSTANCE.getNode("gui-prefs");
    @Log
    @Inject
    private Logger logger;
    private Stage stage;
    private DataGroup[] dataGroups;
    private DataSource[] dataSources;
    private Workbook myWorkbook;
    private static ImmutableMap<String, ExportVariableInstancesToExcel.ExportImportColumn> importColumns = ExportVariableInstancesToExcel.exportImportColumns;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType;

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item, Stage stage) {
        this.stage = stage;
        this.readExcelWorkbook(this.getExcelFile());
    }

    private File getExcelFile() {
        block5: {
            FileChooser fileChooser = new FileChooser();
            FileChooser.ExtensionFilter xlsxExtFilter = new FileChooser.ExtensionFilter("EXCEL files (*.xlsx)", new String[]{"*.xlsx"});
            FileChooser.ExtensionFilter xlsExtFilter = new FileChooser.ExtensionFilter("EXCEL files (*.xls)", new String[]{"*.xls"});
            fileChooser.getExtensionFilters().add((Object)xlsxExtFilter);
            fileChooser.getExtensionFilters().add((Object)xlsExtFilter);
            String importPath = prefNode.get("ArchiveVariableImportPath", System.getProperty("user.home"));
            File importFolder = new File(importPath);
            if (!importFolder.exists() || !importFolder.isDirectory()) {
                importFolder = new File(System.getProperty("user.home"));
            }
            fileChooser.setInitialDirectory(importFolder);
            File file = fileChooser.showOpenDialog((Window)this.stage);
            try {
                if (file == null) break block5;
                String folderName = file.isDirectory() ? file.getPath() : file.getParent();
                prefNode.put("ArchiveVariableImportPath", folderName);
                try {
                    prefNode.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
                return file;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void readExcelWorkbook(final File file) {
        if (file == null) {
            return;
        }
        CallableTask<Void> task = new CallableTask<Void>(){

            public Void call() throws Exception {
                block11: {
                    this.updateTitle(String.format("Import of Variable Signal configuration from %s", file.getName()));
                    FileInputStream fis = new FileInputStream(file);
                    ImportVariableInstancesFromExcel.this.myWorkbook = WorkbookFactory.create((InputStream)fis);
                    int nrOfSheets = ImportVariableInstancesFromExcel.this.myWorkbook.getNumberOfSheets();
                    this.updateProgress(0L, nrOfSheets - 1);
                    if (nrOfSheets > 1) {
                        Transaction trx = Transactions.begin();
                        try {
                            try {
                                ImportVariableInstancesFromExcel.this.dataGroups = DataGroupDAO.getAll((Transaction)trx);
                                ImportVariableInstancesFromExcel.this.dataSources = DataSourceDAO.getAll((Transaction)trx);
                                Sheet sheet = null;
                                int i = 1;
                                while (i < nrOfSheets) {
                                    sheet = ImportVariableInstancesFromExcel.this.myWorkbook.getSheetAt(i);
                                    if (sheet != null) {
                                        this.updateMessage(String.format("Reading Sheet %s", sheet.getSheetName()));
                                        int nrOfRows = sheet.getPhysicalNumberOfRows();
                                        int j = 1;
                                        while (j < nrOfRows) {
                                            Row row = sheet.getRow(j);
                                            if (row != null) {
                                                ImportVariableInstancesFromExcel.this.readLine(row, trx);
                                            } else {
                                                ImportVariableInstancesFromExcel.this.logger.errorf("row %d is null", new Object[]{j});
                                            }
                                            ++j;
                                        }
                                    }
                                    this.updateProgress(i, nrOfSheets - 1);
                                    ++i;
                                }
                                Transactions.commitSync((Transaction)trx);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                Transactions.rollback((Transaction)trx);
                                Transactions.close((Transaction)trx);
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            Transactions.close((Transaction)trx);
                            throw throwable;
                        }
                        Transactions.close((Transaction)trx);
                    }
                }
                ImportVariableInstancesFromExcel.this.myWorkbook.close();
                return null;
            }
        };
        TaskUtils.executeUITask((CallableTask)task).consumeResult((arg_0, arg_1) -> ImportVariableInstancesFromExcel.lambda$0((CallableTask)task, arg_0, arg_1));
    }

    /*
     * Unable to fully structure code
     */
    private void readLine(Row row, Transaction trx) {
        block32: {
            actDataGroup = null;
            actDataSource = null;
            str = "";
            try {
                for (Map.Entry exportImportColumn : ImportVariableInstancesFromExcel.importColumns.entrySet()) {
                    try {
                        ec = (ExportVariableInstancesToExcel.ExportImportColumn)exportImportColumn.getValue();
                        cell = row.getCell(ec.getPosition().intValue());
                        if (cell != null) {
                            cellType = cell.getCellType();
                            switch (ImportVariableInstancesFromExcel.$SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType()[cellType.ordinal()]) {
                                case 5: {
                                    str = "";
                                    break;
                                }
                                case 6: {
                                    str = Boolean.valueOf(cell.getBooleanCellValue()).toString();
                                    break;
                                }
                                case 7: {
                                    str = "";
                                    break;
                                }
                                case 4: {
                                    str = "";
                                    break;
                                }
                                case 2: {
                                    str = Double.valueOf(cell.getNumericCellValue()).toString();
                                    break;
                                }
                                case 3: {
                                    str = cell.getStringCellValue().isEmpty() == false ? cell.getStringCellValue() : "";
                                    break;
                                }
                                default: {
                                    str = "";
                                    break;
                                }
                            }
                        } else {
                            str = "";
                        }
                        ec.setValue(str);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                varName = ((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"varName")).getValue();
                varInstId = ((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"instanceId")).getValue();
                if (varName == null || varName.isEmpty() || varInstId == null || varInstId.isEmpty() || (variableInstance = VariableInstanceDAO.get((Transaction)trx, (int)(viId = Integer.valueOf(varInstId)))) == null) break block32;
                variable = VariableDAO.get((Transaction)trx, (int)variableInstance.getVariable().getId());
                if (((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"instanceDescription")).getValue() != null) {
                    variableInstance.setDescription(((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"instanceDescription")).getValue());
                }
                if ((plcMeasuringUnitSource = ((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"plcMeasuringUnitSource")).getValue()) != null && !plcMeasuringUnitSource.isEmpty() && ((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"plcMeasuringUnit")).getValue() != null && ((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"plcMeasuringUnit")).getValue() != "") {
                    if (plcMeasuringUnitSource.equals("InstancePLC")) {
                        variableInstance.setPlcSourceMU((MeasuringUnit)MeasuringUnit.CONVERTER.fromString(((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"plcMeasuringUnit")).getValue()));
                    } else if (plcMeasuringUnitSource.equals("VariablePLC")) {
                        variable.setPlcSourceMU((MeasuringUnit)MeasuringUnit.CONVERTER.fromString(((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"plcMeasuringUnit")).getValue()));
                    }
                }
                if (((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"opcId")).getValue() != null) {
                    variableInstance.setPlcDatasourceKey(((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"opcId")).getValue());
                }
                if (((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"dataGroup")).getValue() != null) {
                    var17_21 = this.dataGroups;
                    var16_22 = this.dataGroups.length;
                    var15_23 = 0;
                    while (var15_23 < var16_22) {
                        dg = var17_21[var15_23];
                        if (dg.getName().equals(((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"dataGroup")).getValue())) {
                            variableInstance.setPlcDataGroup(dg);
                            actDataGroup = dg;
                            break;
                        }
                        ++var15_23;
                    }
                }
                if (((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"dataSource")).getValue() != null) {
                    var17_21 = this.dataSources;
                    var16_22 = this.dataSources.length;
                    var15_23 = 0;
                    while (var15_23 < var16_22) {
                        ds = var17_21[var15_23];
                        if (ds.getName().equals(((ExportVariableInstancesToExcel.ExportImportColumn)ImportVariableInstancesFromExcel.importColumns.get((Object)"dataSource")).getValue())) {
                            if (actDataGroup == null) break;
                            actDataGroup.setDataSource((DataSource)ds);
                            actDataSource = ds;
                            break;
                        }
                        ++var15_23;
                    }
                }
                try {
                    VariableInstanceDAO.saveOrUpdate((Transaction)trx, (VariableInstance)variableInstance);
                    VariableDAO.saveOrUpdate((Transaction)trx, (Variable)variable);
                    if (actDataGroup != null) {
                        DataGroupDAO.saveOrUpdate((Transaction)trx, actDataGroup);
                    }
                    if (actDataSource != null) {
                        DataSourceDAO.saveOrUpdate((Transaction)trx, actDataSource);
                    }
                    break block32;
                }
                catch (DAOOperationException e) {
                    e.printStackTrace();
                }
                break block32;
            }
            catch (Exception e) {
                rowString = row.getSheet().getSheetName();
                ** for (exportImportColumn : ImportVariableInstancesFromExcel.importColumns.entrySet())
            }
lbl-1000:
            // 1 sources

            {
                ec = (ExportVariableInstancesToExcel.ExportImportColumn)exportImportColumn.getValue();
                cell = row.getCell(ec.getPosition().intValue());
                cellString = cell.getStringCellValue().isEmpty() == false ? cell.getStringCellValue() : "EMPTY";
                rowString = String.valueOf(rowString) + cellString + " | ";
                continue;
            }
lbl103:
            // 1 sources

            message = String.format("row = %s", new Object[]{rowString});
            this.logger.error(message, (Throwable)e);
        }
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && item.getValue() instanceof DataSource;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType() {
        if ($SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType != null) {
            return $SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType;
        }
        int[] nArray = new int[CellType.values().length];
        try {
            nArray[CellType.BLANK.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.BOOLEAN.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.ERROR.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.FORMULA.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.NUMERIC.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType.STRING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CellType._NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$apache$poi$ss$usermodel$CellType = nArray;
        return nArray;
    }

    private static /* synthetic */ void lambda$0(CallableTask callableTask, Worker.State status, Void result) {
        Platform.runLater(() -> TaskUtils.removeTaskFromView((CallableTask)callableTask));
    }
}

