/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataGroupDAO;
import de.elpro.ewms.core.client.datasource.DataSourceAltDAO;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.DataSourceAlt;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ui.utils.e4.PartUtils;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class RemoveHandler {
    @Inject
    @Log
    private Logger logger;

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item, MApplication app, Scene scene) {
        RemoveHandler.deleteDataItem(this.logger, item, app, scene.getWindow());
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && (item.getValue() instanceof DataSource || item.getValue() instanceof DataSourceAlt || item.getValue() instanceof DataGroup);
    }

    public static void deleteDataItem(Logger logger, TreeItem<?> item, MApplication app, Window window) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.initOwner(window);
        alert.setTitle("Confirmation Dialog");
        alert.setContentText(String.format("Do you shure you want to delete %s?", item.getValue()));
        if (alert.showAndWait().get() == ButtonType.OK) {
            Transaction trx = Transactions.begin();
            try {
                try {
                    if (item.getValue() instanceof DataSource) {
                        DataSourceDAO.delete((Transaction)trx, (int)((DataSource)item.getValue()).getId());
                        Transactions.commitSync((Transaction)trx);
                        item.getParent().getChildren().remove(item);
                        PartUtils.closePart((String)"de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datasource", (MApplication)app, (Object[])new Object[]{(DataSource)item.getValue()});
                    } else if (item.getValue() instanceof DataSourceAlt) {
                        DataSourceAltDAO.delete((Transaction)trx, (int)((DataSourceAlt)item.getValue()).getId());
                        Transactions.commitSync((Transaction)trx);
                        item.getParent().getChildren().remove(item);
                        PartUtils.closePart((String)"de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datasourcealt", (MApplication)app, (Object[])new Object[]{(DataSourceAlt)item.getValue()});
                    } else if (item.getValue() instanceof DataGroup) {
                        DataGroupDAO.delete((Transaction)trx, (int)((DataGroup)item.getValue()).getId());
                        Transactions.commitSync((Transaction)trx);
                        item.getParent().getChildren().remove(item);
                        PartUtils.closePart((String)"de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datagroupedit", (MApplication)app, (Object[])new Object[]{(DataGroup)item.getValue()});
                    }
                }
                catch (DAOOperationException exc) {
                    logger.error("Error deleting DataSource alternative Server", (Throwable)exc);
                    Transactions.rollback((Transaction)trx);
                    Transactions.close((Transaction)trx);
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
    }
}

