/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.handlers;

import com.google.common.util.concurrent.AtomicDouble;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.engin.gui.system.processinterface.parts.OpcItemsPart;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class SearchStringInOpcItems {
    @Inject
    @Log
    private Logger logger;
    @Inject
    private MPart part;

    @Execute
    public void execute(final @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<SignalId> treeItem, Scene scene) {
        final ObservableList foundedItems = FXCollections.observableArrayList();
        final TableView resultTable = new TableView();
        resultTable.setEditable(false);
        resultTable.setRowFactory(tvr -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    TreeItem rowData = (TreeItem)row.getItem();
                    OpcItemsPart opcItemsPart = (OpcItemsPart)this.part.getObject();
                    opcItemsPart.updateSelection((TreeItem<SignalId>)rowData);
                }
            });
            return row;
        });
        TableColumn firstColumn = new TableColumn("Displayname");
        firstColumn.setPrefWidth(200.0);
        firstColumn.setCellValueFactory(val -> new ReadOnlyStringWrapper(((SignalId)((TreeItem)val.getValue()).getValue()).getDisplayName()));
        TableColumn secondColumn = new TableColumn("Identifier");
        secondColumn.setPrefWidth(500.0);
        secondColumn.setCellValueFactory(val -> new ReadOnlyStringWrapper(((SignalId)((TreeItem)val.getValue()).getValue()).getIdentifier()));
        resultTable.getColumns().addAll((Object[])new TableColumn[]{firstColumn, secondColumn});
        final Stage searchDialog = new Stage();
        searchDialog.setTitle("Textsuche");
        searchDialog.initModality(Modality.APPLICATION_MODAL);
        searchDialog.initOwner(scene.getWindow());
        VBox dialogVbox = new VBox(20.0);
        Text headerText = new Text();
        headerText.setText("Suche nach String in DisplayName.\nNur schon betretene Knoten werden durchsucht!");
        headerText.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)14.0));
        dialogVbox.getChildren().add((Object)headerText);
        final TextField searchField = new TextField();
        dialogVbox.getChildren().add((Object)searchField);
        Button searchButton = new Button("search");
        searchButton.setDisable(true);
        dialogVbox.getChildren().add((Object)searchButton);
        searchField.textProperty().addListener((observable, oldValue, newValue) -> searchButton.setDisable(newValue.trim().isEmpty()));
        searchButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                foundedItems.clear();
                String searchString = searchField.getText();
                for (TreeItem ti : treeItem.getChildren()) {
                    ObservableList<TreeItem<SignalId>> resultList = SearchStringInOpcItems.this.getResultList((TreeItem<SignalId>)ti, searchString);
                    foundedItems.addAll(resultList);
                }
                resultTable.setItems(foundedItems);
                searchDialog.sizeToScene();
            }
        });
        dialogVbox.getChildren().add((Object)resultTable);
        searchDialog.setScene(new Scene((Parent)dialogVbox));
        Platform.runLater(() -> searchField.requestFocus());
        searchDialog.sizeToScene();
        searchDialog.showAndWait();
    }

    private ObservableList<TreeItem<SignalId>> getResultList(TreeItem<SignalId> ti, String searchString) {
        ObservableList resultList = FXCollections.observableArrayList();
        SignalId sid = (SignalId)ti.getValue();
        if (sid != null) {
            String displayName = sid.getDisplayName().toUpperCase();
            if (displayName.contains(searchString.toUpperCase())) {
                resultList.add(ti);
            }
            for (TreeItem treeItem : ti.getChildren()) {
                resultList.addAll(this.getResultList((TreeItem<SignalId>)treeItem, searchString));
            }
        }
        return resultList;
    }

    private void customResize(TableView<?> view) {
        AtomicDouble width = new AtomicDouble();
        view.getColumns().forEach(col -> width.addAndGet(col.getWidth()));
        double tableWidth = view.getWidth();
        if (tableWidth > width.get()) {
            TableColumn col2 = (TableColumn)view.getColumns().get(view.getColumns().size() - 1);
            col2.setPrefWidth(col2.getWidth() + (tableWidth - width.get()));
        }
    }

    @CanExecute
    public boolean canExecute() {
        return true;
    }
}

