/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataGroupDAO;
import de.elpro.ewms.core.client.datasource.DataSourceAltDAO;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.client.datasource.ToolboxDAO;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.DataSourceAlt;
import de.elpro.ewms.core.datasource.ToolboxDescriptor;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.engin.gui.system.processinterface.handlers.NewBrowseServerHandler;
import de.elpro.ui.model.UIModelElement;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Function;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;

public class ShowOpcProcessInterfaceNavigationHandler
extends LazyNavigationContribution<UIModelElement> {
    public static final String MENU_ID = "de.elpro.ewms.engin.gui.system.processinterface.menu";
    @Inject
    private MApplication app;
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    TreeMap<String, TreeItem> rootElements = new TreeMap<String, TreeItem>();
                    DataSource[] dataSourceArray = DataSourceDAO.getAll((Transaction)trx);
                    int n = dataSourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataSource ds = dataSourceArray[n2];
                        ToolboxDescriptor descriptor = ToolboxDAO.get((String)ds.getToolboxId());
                        String protocolName = descriptor != null ? descriptor.getProtocol().name() : "Unknown";
                        TreeItem protocolElem = (TreeItem)rootElements.get(protocolName);
                        if (protocolElem == null) {
                            protocolElem = new TreeItem((Object)new ProtocolNode(protocolName));
                            rootElements.put(protocolName, protocolElem);
                            elements.add((TreeItem<UIModelElement>)protocolElem);
                        }
                        protocolElem.getChildren().add((Object)ShowOpcProcessInterfaceNavigationHandler.this.createLazyTreeItem((UIModelElement)ds));
                        ++n2;
                    }
                } else if (item.getValue() instanceof DataSource) {
                    DataSource ds = (DataSource)item.getValue();
                    elements.addAll(ShowOpcProcessInterfaceNavigationHandler.this.createTreeItemCollection((UIModelElement[])DataSourceAltDAO.getAll((Transaction)trx, (DataSource)ds)));
                    elements.addAll(ShowOpcProcessInterfaceNavigationHandler.this.createTreeItemCollection((UIModelElement[])DataGroupDAO.getByDataSource((Transaction)trx, (DataSource)ds)));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };

    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Execute
    public void execute() {
    }

    public String getContextMenuId() {
        return MENU_ID;
    }

    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        if (treeItem != null) {
            if (treeItem.getValue() instanceof DataSource) {
                EnginPartUtils.showEditPart((String)"de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datasource", (MApplication)this.app, (UIModelElement)((DataSource)treeItem.getValue()), treeItem);
            } else if (treeItem.getValue() instanceof DataSourceAlt) {
                EnginPartUtils.showEditPart((String)"de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datasourcealt", (MApplication)this.app, (UIModelElement)((DataSourceAlt)treeItem.getValue()), treeItem);
            } else if (treeItem.getValue() instanceof DataGroup) {
                EnginPartUtils.showEditPart((String)"de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datagroupedit", (MApplication)this.app, (UIModelElement)((DataGroup)treeItem.getValue()), treeItem);
            }
        }
    }

    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        NewBrowseServerHandler newBrowseServerHandler = new NewBrowseServerHandler();
        newBrowseServerHandler.execute(treeItem, this.app);
    }

    private static class ProtocolNode
    implements UIModelElement {
        private static final String UNKNOWN = "Unknown";
        private final String protocolName;

        public ProtocolNode(String protocolName) {
            this.protocolName = protocolName;
        }

        public Node getGraphic() {
            Label l = new Label();
            l.setText(this.protocolName != null ? this.protocolName : UNKNOWN);
            l.setStyle(String.format("-fx-font-weight: bold; -fx-text-fill: %s; -fx-font-style: italic;", this.protocolName != null ? "cornflowerblue" : "red"));
            l.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
            return l;
        }

        public String toString() {
            return "";
        }
    }
}

