/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataGroupDAO;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataGroupType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class DataGroupEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datagroupedit";
    @Log
    @Inject
    private Logger logger;
    @Inject
    private DataGroup dataGroup;
    @Inject
    private Scene scene;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet dataGroupPropertySheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(true);

    @PostConstruct
    public void postConstruct(BorderPane parent, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        block7: {
            this.dataGroupPropertySheet.setModeSwitcherVisible(false);
            this.dataGroupPropertySheet.setSearchBoxVisible(false);
            if (this.dataGroup.getId() != null) {
                Transaction trx = Transactions.begin();
                int id = this.dataGroup.getId();
                try {
                    try {
                        this.dataGroup = DataGroupDAO.get((Transaction)trx, (int)id);
                    }
                    catch (Exception e) {
                        this.logger.errorf("DataGroupDAO.getAllVarInstances(trx, %s)", (Throwable)e, new Object[]{id});
                        Transactions.close((Transaction)trx);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    Transactions.close((Transaction)trx);
                    throw throwable;
                }
                Transactions.close((Transaction)trx);
            } else {
                this.part.setDirty(true);
            }
        }
        IntegerPropertyItem idItem = new IntegerPropertyItem("Id", (ObservableValue)this.dataGroup.idProperty());
        idItem.setReadOnly(true);
        StringPropertyItem nameItem = new StringPropertyItem("Groupname", (ObservableValue)this.dataGroup.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Groupname must be not empty"));
        StringPropertyItem namespaceItem = new StringPropertyItem("Namespace", (ObservableValue)this.dataGroup.namespaceProperty());
        EnumPropertyItem typeItem = new EnumPropertyItem("Type", DataGroupType.class, (ObservableValue)this.dataGroup.typeProperty());
        typeItem.setValidator(Validators.createNotEmptyValidator((String)"Type must be specifeid"));
        typeItem.setNullable(false);
        ChoicePropertyItem writeValuesSourceItem = new ChoicePropertyItem("Write Values Source", (ObservableValue)this.dataGroup.writeValueSourceProperty(), Arrays.asList(RawValuesViewType.RealtimeView, RawValuesViewType.GlobalView));
        writeValuesSourceItem.setValidator(Validators.createNotEmptyValidator((String)"Write Values Source must be specifeid"));
        writeValuesSourceItem.setNullable(false);
        IntegerPropertyItem wwmaItem = new IntegerPropertyItem("Write Value Max Age Timespan", (ObservableValue)this.dataGroup.writeValueLastValidValueSearchTimespanProperty());
        wwmaItem.setPositiveOnly(true);
        wwmaItem.setValidator(Validators.createNotEmptyValidator());
        IntegerPropertyItem updateRateItem = new IntegerPropertyItem("Update Rate", (ObservableValue)this.dataGroup.updateRateProperty());
        IntegerPropertyItem keepAliveRateItem = new IntegerPropertyItem("Keep Alive Rate", (ObservableValue)this.dataGroup.keepAliveProperty());
        EnumPropertyItem sampleRasterItem = new EnumPropertyItem("Sample Raster", Raster.class, (ObservableValue)this.dataGroup.sampleRasterProperty());
        sampleRasterItem.setNullable(false);
        sampleRasterItem.setValidator(Validators.createNotEmptyValidator((String)"Sampe Raster must be specified"));
        StringPropertyItem properitesItem = new StringPropertyItem("Properties", (ObservableValue)this.dataGroup.propertiesDefinitionProperty());
        properitesItem.useAreaEditor(true);
        BooleanPropertyItem disableHistoricalImportItem = new BooleanPropertyItem("Disable Historical Import", (ReadOnlyProperty)this.dataGroup.disableHistoricalImportProperty());
        this.dataGroupPropertySheet.getItems().addAll((Object[])new PropertySheet.Item[]{idItem, nameItem, namespaceItem, typeItem, writeValuesSourceItem, wwmaItem, updateRateItem, keepAliveRateItem, sampleRasterItem, properitesItem, disableHistoricalImportItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.dataGroupPropertySheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.dataGroupPropertySheet.getItems()));
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        parent.setCenter((Node)this.dataGroupPropertySheet);
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.initOwner(this.scene.getWindow());
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.dataGroup.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.dataGroup.setId(Integer.valueOf(DataGroupDAO.saveOrUpdate((Transaction)trx, (DataGroup)this.dataGroup)));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.dataGroupPropertySheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.dataGroup.getName());
                PartUtils.refreshParts((EPartService)this.partService, DataGroup.class);
                EnginPartUtils.refreshItems((UIModelElement)this.dataGroup, (MPart)this.part);
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.scene.getWindow());
                dlg.setContentText("Error saving OPC-Group");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, DataGroup.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    public final SimpleBooleanProperty hasChangesProperty() {
        return this.hasChanges;
    }

    public final boolean isHasChanges() {
        return this.hasChangesProperty().get();
    }

    public final void setHasChanges(boolean hasChanges) {
        this.hasChangesProperty().set(hasChanges);
    }

    public final SimpleBooleanProperty hasErrorsProperty() {
        return this.hasErrors;
    }

    public final boolean isHasErrors() {
        return this.hasErrorsProperty().get();
    }

    public final void setHasErrors(boolean hasErrors) {
        this.hasErrorsProperty().set(hasErrors);
    }
}

