/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataSourceAltDAO;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.datasource.DataSourceAlt;
import de.elpro.ewms.core.datasource.opcua.MessageSecurityMode;
import de.elpro.ewms.core.datasource.opcua.MessageSecurityPolicy;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.PasswordPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class DataSourceAltEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datasourcealt";
    @Inject
    private DataSourceAlt dataSourceAlt;
    @Inject
    private MPart part;
    @Inject
    private Scene scene;
    @Inject
    private EPartService partService;
    private final PropertySheet dataServerPropertySheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(true);

    @PostConstruct
    public void postConstruct(BorderPane parent, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        Transaction trx = Transactions.begin();
        try {
            if (this.dataSourceAlt.getId() != null) {
                int id = this.dataSourceAlt.getId();
                this.dataSourceAlt = DataSourceAltDAO.get((Transaction)trx, (int)id);
            } else {
                this.part.setDirty(true);
            }
            if (this.dataSourceAlt.getMaster() != null) {
                this.dataSourceAlt.setMaster(DataSourceDAO.get((Transaction)trx, (int)this.dataSourceAlt.getMaster().getId()));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        IntegerPropertyItem idItem = new IntegerPropertyItem("Id", (ObservableValue)this.dataSourceAlt.idProperty());
        idItem.setReadOnly(true);
        ChoicePropertyItem master = new ChoicePropertyItem("Master", (ObservableValue)this.dataSourceAlt.masterProperty());
        master.setReadOnly(true);
        StringPropertyItem opcNameItem = new StringPropertyItem("Servername", (ObservableValue)this.dataSourceAlt.nameProperty());
        opcNameItem.setValidator(Validators.createNotEmptyValidator((String)"Servername must be not empty"));
        StringPropertyItem hostNameItem = new StringPropertyItem("Hostname", (ObservableValue)this.dataSourceAlt.hostNameProperty());
        IntegerPropertyItem priorityItem = new IntegerPropertyItem("Priority", (ObservableValue)this.dataSourceAlt.priorityProperty());
        priorityItem.setValidator(Validators.createNotEmptyValidator((String)"Priority must be set"));
        StringPropertyItem ipAddressItem = new StringPropertyItem("IP-Address", (ObservableValue)this.dataSourceAlt.hostIpAddrProperty());
        ipAddressItem.setValidator(Validators.createIPv4Validator((String)"IP-Address is not valid"));
        StringPropertyItem instanceItem = new StringPropertyItem("Instance", (ObservableValue)this.dataSourceAlt.instanceProperty());
        EnumPropertyItem securityPolicyItem = new EnumPropertyItem("MessageSecurityPolicy", MessageSecurityPolicy.class, (ObservableValue)this.dataSourceAlt.securityPolicyProperty());
        securityPolicyItem.setNullable(false);
        EnumPropertyItem messageSecurityModeItem = new EnumPropertyItem("MessageSecurityMode", MessageSecurityMode.class, (ObservableValue)this.dataSourceAlt.messageSecurityModeProperty());
        messageSecurityModeItem.setNullable(false);
        IntegerPropertyItem hostPortItem = new IntegerPropertyItem("Port", (ObservableValue)this.dataSourceAlt.hostPortNrProperty());
        StringPropertyItem userNameItem = new StringPropertyItem("Username", (ObservableValue)this.dataSourceAlt.userProperty());
        PasswordPropertyItem passwordItem = new PasswordPropertyItem("Password", (ObservableValue)this.dataSourceAlt.passwordProperty());
        StringPropertyItem plcAliasMap = new StringPropertyItem("Plc Alias Map", (ObservableValue)this.dataSourceAlt.plcAliasMapTextProperty());
        plcAliasMap.setPromptText("Ex.: key_1=value1;key_2=value_2;key_3=value_3;");
        this.dataServerPropertySheet.getItems().addAll((Object[])new PropertySheet.Item[]{idItem, master, opcNameItem, priorityItem, hostNameItem, ipAddressItem, hostPortItem, instanceItem, securityPolicyItem, messageSecurityModeItem, userNameItem, passwordItem, plcAliasMap});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.dataServerPropertySheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.dataServerPropertySheet.getItems()));
        parent.setCenter((Node)this.dataServerPropertySheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.initOwner(this.scene.getWindow());
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.dataSourceAlt.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.dataSourceAlt.setId(DataSourceAltDAO.saveOrUpdate((Transaction)trx, (DataSourceAlt)this.dataSourceAlt));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.dataServerPropertySheet.getItems());
                this.part.setLabel(this.dataSourceAlt.toString());
                EnginPartUtils.refreshItems((UIModelElement)this.dataSourceAlt, (MPart)this.part);
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.scene.getWindow());
                dlg.setContentText("Error saving alternative DataServer");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, DataSourceAlt.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

