/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.client.datasource.ToolboxDAO;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.ToolboxDescriptor;
import de.elpro.ewms.core.datasource.opcua.MessageSecurityMode;
import de.elpro.ewms.core.datasource.opcua.MessageSecurityPolicy;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.PasswordPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class DataSourceEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.datasource";
    @Inject
    private DataSource dataSource;
    @Inject
    private MPart part;
    @Inject
    private Scene scene;
    @Inject
    private EPartService partService;
    private final PropertySheet dataServerPropertySheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(true);

    @PostConstruct
    public void postConstruct(BorderPane parent, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        ArrayList<ToolboxDescriptor> descriptors = new ArrayList<ToolboxDescriptor>();
        SimpleObjectProperty descriptor = new SimpleObjectProperty();
        Transaction trx = Transactions.begin();
        try {
            descriptors.addAll(Arrays.asList(ToolboxDAO.getAll()));
            if (this.dataSource.getId() != null) {
                int id = this.dataSource.getId();
                this.dataSource = DataSourceDAO.get((Transaction)trx, (int)id);
                descriptor.set((Object)ToolboxDAO.get((String)this.dataSource.getToolboxId()));
            } else {
                this.part.setDirty(true);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        IntegerPropertyItem idItem = new IntegerPropertyItem("Id", (ObservableValue)this.dataSource.idProperty());
        idItem.setReadOnly(true);
        ChoicePropertyItem dataSourceTypeItem = new ChoicePropertyItem("Provider", (ObservableValue)descriptor, descriptors);
        dataSourceTypeItem.setNullable(false);
        dataSourceTypeItem.setValidator(Validators.createNotEmptyValidator((String)"Provider must be set"));
        descriptor.addListener(il -> this.dataSource.setToolboxId(((ToolboxDescriptor)descriptor.getValue()).getId()));
        StringPropertyItem opcNameItem = new StringPropertyItem("Servername", (ObservableValue)this.dataSource.nameProperty());
        opcNameItem.setValidator(Validators.createNotEmptyValidator((String)"Servername must be not empty"));
        StringPropertyItem hostNameItem = new StringPropertyItem("Hostname", (ObservableValue)this.dataSource.hostNameProperty());
        StringPropertyItem ipAddressItem = new StringPropertyItem("IP-Address", (ObservableValue)this.dataSource.hostIpAddrProperty());
        ipAddressItem.setValidator(Validators.createIPv4Validator((String)"IP-Address is not valid"));
        StringPropertyItem instanceItem = new StringPropertyItem("Instance", (ObservableValue)this.dataSource.instanceProperty());
        EnumPropertyItem securityPolicyItem = new EnumPropertyItem("MessageSecurityPolicy", MessageSecurityPolicy.class, (ObservableValue)this.dataSource.securityPolicyProperty());
        securityPolicyItem.setNullable(false);
        EnumPropertyItem messageSecurityModeItem = new EnumPropertyItem("MessageSecurityMode", MessageSecurityMode.class, (ObservableValue)this.dataSource.messageSecurityModeProperty());
        messageSecurityModeItem.setNullable(false);
        IntegerPropertyItem hostPortItem = new IntegerPropertyItem("Port", (ObservableValue)this.dataSource.hostPortNrProperty());
        StringPropertyItem userNameItem = new StringPropertyItem("Username", (ObservableValue)this.dataSource.userProperty());
        PasswordPropertyItem passwordItem = new PasswordPropertyItem("Password", (ObservableValue)this.dataSource.passwordProperty());
        StringPropertyItem plcAliasMap = new StringPropertyItem("Plc Alias Map", (ObservableValue)this.dataSource.plcAliasMapTextProperty());
        plcAliasMap.setPromptText("Ex.: key_1=value1;key_2=value_2;key_3=value_3;");
        BooleanPropertyItem autoconnect = new BooleanPropertyItem("Auto-Connect", (ReadOnlyProperty)this.dataSource.autoconnectProperty());
        this.dataServerPropertySheet.getItems().addAll((Object[])new PropertySheet.Item[]{idItem, dataSourceTypeItem, opcNameItem, hostNameItem, ipAddressItem, hostPortItem, instanceItem, securityPolicyItem, messageSecurityModeItem, userNameItem, passwordItem, plcAliasMap, autoconnect});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.dataServerPropertySheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.dataServerPropertySheet.getItems()));
        parent.setCenter((Node)this.dataServerPropertySheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.initOwner(this.scene.getWindow());
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.dataSource.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.dataSource.setId(DataSourceDAO.saveOrUpdate((Transaction)trx, (DataSource)this.dataSource));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.dataServerPropertySheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.dataSource.getName());
                EnginPartUtils.refreshItems((UIModelElement)this.dataSource, (MPart)this.part);
            }
            catch (Exception exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.scene.getWindow());
                dlg.setContentText("Error saving OPC-Server");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, DataSource.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

