/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.datasource.handlers.ImportSignalIdsRequest;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import java.util.Collection;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;

public class ImportSignalIdsDialog
extends Dialog<ButtonType> {
    private final ImportSignalIdsRequest request = new ImportSignalIdsRequest();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);

    public ImportSignalIdsDialog(Window window) {
        Object[] dataSources;
        Object[] structureClasses;
        this.initOwner(window);
        this.setResizable(true);
        PropertySheet sheet = new PropertySheet();
        sheet.setPrefWidth(600.0);
        sheet.setPrefHeight(500.0);
        Transaction trx = Transactions.begin();
        try {
            structureClasses = StructureClassDAO.getAll((Transaction)trx);
            dataSources = DataSourceDAO.getAll((Transaction)trx);
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        SimpleObjectProperty structureClassProperty = new SimpleObjectProperty();
        ChoicePropertyItem structureClassItem = new ChoicePropertyItem("Structure Class", (ObservableValue)structureClassProperty, structureClasses);
        structureClassItem.setNullable(false);
        structureClassItem.setValidator(Validators.createNotEmptyValidator((String)"Select Structure Class"));
        ChoicePropertyItem insertVariableItem = new ChoicePropertyItem("Insert Variable", (ObservableValue)this.request.insertVariableProperty(), (Object[])new Variable[0]);
        insertVariableItem.setNullable(false);
        insertVariableItem.setValidator(Validators.createNotEmptyValidator((String)"Select Variable to insert PLC Variable Instances"));
        SimpleObjectProperty parentObjectStructureClassProperty = new SimpleObjectProperty();
        ChoicePropertyItem parentObjectStructureClassItem = new ChoicePropertyItem("Parent Object Structure Class", (ObservableValue)parentObjectStructureClassProperty, structureClasses);
        parentObjectStructureClassItem.setNullable(false);
        parentObjectStructureClassItem.setValidator(Validators.createNotEmptyValidator((String)"Select Structure Class"));
        ChoicePropertyItem parentObjectItem = new ChoicePropertyItem("Parent Object", (ObservableValue)this.request.parentObjectProperty(), (Object[])new StructureObject[0]);
        parentObjectItem.setNullable(false);
        parentObjectItem.setValidator(Validators.createNotEmptyValidator((String)"Select parent object to insert new structure objects"));
        ChoicePropertyItem dataSourceItem = new ChoicePropertyItem("Data Source", (ObservableValue)this.request.dataSourceProperty(), dataSources);
        dataSourceItem.setNullable(false);
        dataSourceItem.setValidator(Validators.createNotEmptyValidator((String)"Select Data Source"));
        StringPropertyItem searchRootNamespaceItem = new StringPropertyItem("Search Root Item Namespace", (ObservableValue)this.request.searchRootNamespaceProperty());
        searchRootNamespaceItem.setPromptText("urn:com:eos");
        StringPropertyItem searchRootIdentifierItem = new StringPropertyItem("Search Root Item Identifier", (ObservableValue)this.request.searchRootIdentifierProperty());
        searchRootIdentifierItem.setPromptText("EOS/Variables");
        StringPropertyItem searchFolderRegexItem = new StringPropertyItem("Search Folder Regex", (ObservableValue)this.request.searchFolderRegexProperty());
        searchFolderRegexItem.setPromptText("(Objects|OpenPCS7|Named Connections)");
        StringPropertyItem signalIdRegexItem = new StringPropertyItem("SignalID Regex", (ObservableValue)this.request.signalIdRegexProperty());
        signalIdRegexItem.setPromptText("^(t\\.*)(Out#Value|PV_Out#Value)$");
        StringPropertyItem removeNamingPrefixRegexItem = new StringPropertyItem("Remove Naming Prefix Regex", (ObservableValue)this.request.removeNamingPrefixRegexProperty());
        removeNamingPrefixRegexItem.setPromptText("^(t\\|GHKW_OS_OS::)(.*)");
        StringPropertyItem removeNamingSuffixRegexItem = new StringPropertyItem("Remove Naming Suffix Regex", (ObservableValue)this.request.removeNamingSuffixRegexProperty());
        removeNamingSuffixRegexItem.setPromptText("^(.*)(Out#Value|PV_Out#Value)$");
        BooleanPropertyItem onlyUnusedSignalIdsItem = new BooleanPropertyItem("Only Unused Signals", (ReadOnlyProperty)this.request.onlyUnusedSignalsProperty());
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{structureClassItem, insertVariableItem, new SeparatorItem(), parentObjectStructureClassItem, parentObjectItem, new SeparatorItem(), dataSourceItem, searchRootNamespaceItem, searchRootIdentifierItem, searchFolderRegexItem, new SeparatorItem(), signalIdRegexItem, removeNamingPrefixRegexItem, removeNamingSuffixRegexItem, new SeparatorItem(), onlyUnusedSignalIdsItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
        this.getDialogPane().setContent((Node)sheet);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)this.hasErrors);
        structureClassItem.valueProperty().addListener(il -> {
            Transaction trxI = Transactions.begin();
            try {
                insertVariableItem.setChoicesArray((Object[])VariableDAO.getByClass((Transaction)trxI, (StructureClass)((StructureClass)structureClassItem.getValue())));
            }
            finally {
                Transactions.close((Transaction)trxI);
            }
            this.request.setInsertVariable(null);
        });
        parentObjectStructureClassItem.valueProperty().addListener(il -> {
            Transaction trxI = Transactions.begin();
            try {
                parentObjectItem.setChoicesArray((Object[])StructureClassDAO.getAllObjects((Transaction)trxI, (StructureClass)((StructureClass)parentObjectStructureClassItem.getValue())));
            }
            finally {
                Transactions.close((Transaction)trxI);
            }
            this.request.setParentObject(null);
        });
    }

    public ImportSignalIdsRequest getRequest() {
        return this.request;
    }
}

