/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.parts;

import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.fx.charts.ChartUtils;
import de.elpro.ewms.core.fx.charts.DefaultJFreeChartTheme;
import de.elpro.ewms.core.fx.jfree.EfficientXYLineAndOptionalShapeRenderer;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import java.awt.Color;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.fx.ChartViewer;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

public class OpcItemAttributesPart {
    public static final String ID = "de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.opcitemattributespart";
    private final SimpleIntegerProperty sampleIntervalProperty = new SimpleIntegerProperty();
    private final SimpleStringProperty signalTypeProperty = new SimpleStringProperty();
    private final SimpleStringProperty namespaceProperty = new SimpleStringProperty();
    private final SimpleStringProperty identifierProperty = new SimpleStringProperty();
    private final SimpleStringProperty identifierTypeProperty = new SimpleStringProperty();
    private final SimpleStringProperty displayNameProperty = new SimpleStringProperty();
    private final SimpleStringProperty valueProperty = new SimpleStringProperty();
    private final SimpleStringProperty sourceTimestampProperty = new SimpleStringProperty();
    private final SimpleStringProperty serverTimestampProperty = new SimpleStringProperty();
    private final long TIME_RANGE = Raster.Minute_2.toMilli();
    private final XYLineAndShapeRenderer renderer = new EfficientXYLineAndOptionalShapeRenderer();
    private final DateAxis xAxis = new DateAxis("Responce Timestamp");
    private final NumberAxis yAxis = new NumberAxis("Value");
    private JFreeChart liveChart;
    private XYPlot plot;
    private TimeSeriesCollection seriecCollection = new TimeSeriesCollection();
    private Map<SignalId, TimeSeries> seriesMap = new HashMap<SignalId, TimeSeries>();
    private final Timeline animation = new Timeline();
    private final SimpleBooleanProperty animated = new SimpleBooleanProperty(false);
    List<SignalDataValue> liveItems = new LinkedList<SignalDataValue>();
    private final TableView<SignalId> itemsTableView = new TableView();
    private final TableView<Map.Entry<String, String>> propertiesTable = new TableView();
    private SignalId selectedSignalId;
    @Inject
    private DataSource dataSource;
    @Inject
    private LazyTreeItem<SignalId> selectedItem;
    @Inject
    private MPart part;
    @Inject
    private Scene scene;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        this.xAxis.setStandardTickUnits(ChartUtils.createStandardDateTickUnits((TimeZone)TimeZone.getDefault(), (Locale)Locale.getDefault()));
        SplitPane opcItemSplitPane = new SplitPane();
        SplitPane opcItemDetailSplitPane = new SplitPane();
        VBox opcItemLivePane = new VBox();
        PropertySheet attributePropertySheet = new PropertySheet();
        opcItemSplitPane.setDividerPosition(0, 0.8);
        opcItemSplitPane.getItems().add((Object)opcItemLivePane);
        opcItemSplitPane.getItems().add((Object)opcItemDetailSplitPane);
        opcItemDetailSplitPane.setOrientation(Orientation.VERTICAL);
        opcItemDetailSplitPane.setDividerPosition(0, 0.63);
        opcItemDetailSplitPane.getItems().add((Object)attributePropertySheet);
        opcItemDetailSplitPane.getItems().add(this.propertiesTable);
        ToggleButton startStop = new ToggleButton("Start");
        startStop.selectedProperty().bindBidirectional((Property)this.animated);
        Object[] updateIntervals = (Raster[])Arrays.stream(Raster.values()).filter(r -> r.toMilli() >= Raster.Milli_10.toMilli()).toArray(Raster[]::new);
        ComboBox intervalField = new ComboBox(FXCollections.observableArrayList((Object[])updateIntervals));
        intervalField.valueProperty().addListener((o, ov, nv) -> this.sampleIntervalProperty.set((int)nv.toMilli()));
        intervalField.setValue((Object)Raster.Milli_500);
        Label sampleIntervalLabel = new Label("Sample Interval");
        sampleIntervalLabel.setPadding(new Insets(5.0));
        HBox startStopBox = new HBox(5.0, new Node[]{sampleIntervalLabel, intervalField, startStop});
        startStopBox.setAlignment(Pos.CENTER);
        startStopBox.setPadding(new Insets(5.0));
        startStopBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)javafx.scene.paint.Color.WHITE, null, null)}));
        HBox.setHgrow((Node)startStop, (Priority)Priority.ALWAYS);
        this.yAxis.setAutoRangeIncludesZero(false);
        this.renderer.setDataBoundsIncludesVisibleSeriesOnly(true);
        this.renderer.setUseFillPaint(true);
        this.plot = new XYPlot((XYDataset)this.seriecCollection, (ValueAxis)this.xAxis, (ValueAxis)this.yAxis, (XYItemRenderer)this.renderer);
        this.liveChart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, true);
        ChartViewer chartViewer = new ChartViewer(this.liveChart);
        VBox.setVgrow((Node)chartViewer, (Priority)Priority.ALWAYS);
        opcItemLivePane.getChildren().addAll((Object[])new Node[]{chartViewer, startStopBox});
        parent.setCenter((Node)opcItemSplitPane);
        this.animated.addListener((o, ov, nv) -> {
            if (nv.booleanValue()) {
                this.startAnimatedLineChart();
            } else {
                this.stopAnimatedLineChart();
            }
            startStop.setText(nv != false ? "Stop" : "Start");
        });
        this.sampleIntervalProperty.addListener(il -> this.initAnimatedLineChart());
        this.initAnimatedLineChart();
        StringPropertyItem signalTypeItem = new StringPropertyItem("Type", (ObservableValue)this.signalTypeProperty);
        signalTypeItem.setReadOnly(true);
        StringPropertyItem namespaceItem = new StringPropertyItem("Namespace", (ObservableValue)this.namespaceProperty);
        namespaceItem.setReadOnly(true);
        StringPropertyItem identifierItem = new StringPropertyItem("Identifier", (ObservableValue)this.identifierProperty);
        identifierItem.setReadOnly(true);
        StringPropertyItem idType = new StringPropertyItem("Identifier Type", (ObservableValue)this.identifierTypeProperty);
        idType.setReadOnly(true);
        StringPropertyItem displayNameItem = new StringPropertyItem("Displayname", (ObservableValue)this.displayNameProperty);
        displayNameItem.setReadOnly(true);
        StringPropertyItem valueItem = new StringPropertyItem("Value", (ObservableValue)this.valueProperty);
        valueItem.setReadOnly(true);
        StringPropertyItem sourceTSItem = new StringPropertyItem("Source Timestamp", (ObservableValue)this.sourceTimestampProperty);
        sourceTSItem.setReadOnly(true);
        StringPropertyItem serverTSItem = new StringPropertyItem("Server Timestamp", (ObservableValue)this.serverTimestampProperty);
        serverTSItem.setReadOnly(true);
        attributePropertySheet.setModeSwitcherVisible(false);
        attributePropertySheet.setSearchBoxVisible(false);
        attributePropertySheet.getItems().addAll((Object[])new PropertySheet.Item[]{new SeparatorItem(), signalTypeItem, namespaceItem, identifierItem, idType, displayNameItem, new SeparatorItem(), valueItem, sourceTSItem, serverTSItem});
        this.selectedSignalId = (SignalId)this.selectedItem.getValue();
        this.showProperties(this.selectedSignalId);
        this.addSignalToChart(this.selectedSignalId);
    }

    @Refresh
    public void refresh() {
        this.showProperties(this.selectedSignalId);
    }

    public void addSignalToChart(SignalId signalId) {
        this.plot.setNotify(false);
        int seriesIndex = this.seriesMap.size();
        this.renderer.setSeriesShapesVisible(seriesIndex, true);
        this.renderer.setSeriesShapesFilled(seriesIndex, true);
        this.renderer.setSeriesOutlinePaint(seriesIndex, this.renderer.getSeriesPaint(seriesIndex));
        this.renderer.setSeriesFillPaint(seriesIndex, (java.awt.Paint)Color.white);
        this.renderer.setSeriesShape(seriesIndex, ShapeType.Circle.createAWTShape(4.0f));
        TimeSeries series = new TimeSeries((Comparable)((Object)signalId.getIdentifier()));
        series.setMaximumItemAge(this.TIME_RANGE);
        this.seriecCollection.addSeries(series);
        this.seriesMap.put(signalId, series);
        this.plot.setNotify(true);
    }

    public void showProperties(SignalId signalId) {
        signalId = DataSourceDAO.loadSignalAttributes((int)this.dataSource.getId(), (SignalId)this.selectedSignalId);
        this.animated.set(false);
        this.liveChart.setTitle(signalId.getFullId());
        DefaultJFreeChartTheme.getChartTheme().apply(this.liveChart);
        this.liveChart.removeLegend();
        this.signalTypeProperty.set((String)signalId.getGenericProperties().get("NodeClass"));
        this.namespaceProperty.set(signalId.getNamespace());
        this.identifierProperty.set(signalId.getIdentifier());
        this.identifierTypeProperty.set(signalId.getIdentifierType());
        this.displayNameProperty.set(signalId.getDisplayName());
        this.valueProperty.set((String)signalId.getGenericProperties().get("Value"));
        this.itemsTableView.getColumns().clear();
        TableColumn instanceIdCol = new TableColumn("InstanceId");
        instanceIdCol.setCellValueFactory(val -> this.identifierProperty);
        TableColumn valueCol = new TableColumn("Value");
        valueCol.setCellValueFactory(val -> this.valueProperty);
        this.itemsTableView.getColumns().add((Object)instanceIdCol);
        this.itemsTableView.getColumns().add((Object)valueCol);
        this.itemsTableView.getItems().add((Object)this.selectedSignalId);
        this.propertiesTable.getColumns().clear();
        TableColumn propNameCol = new TableColumn("Propertyname");
        propNameCol.setCellValueFactory(cf -> new ReadOnlyStringWrapper((String)((Map.Entry)cf.getValue()).getKey()));
        TableColumn propValueCol = new TableColumn("Propertyvalue");
        propValueCol.setCellValueFactory(cf -> new ReadOnlyStringWrapper((String)((Map.Entry)cf.getValue()).getValue()));
        this.propertiesTable.getColumns().add((Object)propNameCol);
        this.propertiesTable.getColumns().add((Object)propValueCol);
        this.propertiesTable.getItems().setAll(signalId.getGenericProperties().entrySet());
        this.part.setLabel(signalId.getDisplayName());
        this.part.setIconURI(signalId.getIconUri());
    }

    private void plotTime() {
        this.plot.setNotify(false);
        try {
            try {
                Millisecond requestTs = new Millisecond();
                for (Map.Entry<SignalId, TimeSeries> entry : this.seriesMap.entrySet()) {
                    SignalId signalId = entry.getKey();
                    TimeSeries dataSeries = entry.getValue();
                    SignalDataValue dataValue = DataSourceDAO.getCurrentValue((int)this.dataSource.getId(), (SignalId)signalId);
                    Number value = dataValue.getNummericValue();
                    dataSeries.add(new TimeSeriesDataItem((RegularTimePeriod)requestTs, value));
                    if (signalId != this.selectedSignalId) continue;
                    if (dataValue == null || dataValue.getValue() == null) {
                        this.valueProperty.setValue(null);
                    } else {
                        this.valueProperty.setValue(dataValue.getValue().toString());
                    }
                    if (dataValue.getSourceTime() != null) {
                        this.sourceTimestampProperty.set(LocalDateTime.ofInstant(dataValue.getSourceTime(), ZoneOffset.systemDefault()).toString());
                    } else {
                        this.sourceTimestampProperty.set(null);
                    }
                    if (dataValue.getServerTime() != null) {
                        this.serverTimestampProperty.set(LocalDateTime.ofInstant(dataValue.getServerTime(), ZoneOffset.systemDefault()).toString());
                        continue;
                    }
                    this.serverTimestampProperty.set(null);
                }
            }
            catch (Exception exc) {
                this.animated.set(false);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(this.scene.getWindow());
                dlg.show();
                this.plot.setNotify(true);
            }
        }
        finally {
            this.plot.setNotify(true);
        }
    }

    private void initAnimatedLineChart() {
        boolean needStart = this.animated.get();
        if (needStart) {
            this.animated.set(false);
        }
        this.animation.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)Math.max(100, this.sampleIntervalProperty.get())), actionEvent -> this.plotTime(), new KeyValue[0])});
        this.animation.setCycleCount(-1);
        this.animated.set(true);
    }

    private void startAnimatedLineChart() {
        if (this.animation != null) {
            this.animation.play();
        }
    }

    @PreDestroy
    public void stopAnimatedLineChart() {
        if (this.animation != null) {
            this.animation.stop();
        }
    }
}

