/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.system.processinterface.parts;

import de.elpro.ewms.core.client.datasource.DataSourceDAO;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.SignalType;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ui.fx.cells.uimodel.UIModelTreeCell;
import de.elpro.ui.fx.controls.tree.LazyTreeItem;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class OpcItemsPart {
    public static final String ID = "de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.opcitemspart";
    private static final String MENU_ID = "de.elpro.ewms.engin.gui.system.processinterface.popupmenu.opcelementscontextmenu";
    @Inject
    private DataSource dataSource;
    @Log
    @Inject
    private Logger logger;
    @Inject
    private EMenuService menuService;
    @Inject
    private EPartService partService;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private MApplication app;
    @Inject
    private MPart part;
    @Inject
    private Scene scene;
    private final TreeView<SignalId> treeView = new TreeView();
    private final ProgressIndicatorPane progressIndicatorPane = new ProgressIndicatorPane(this.treeView);
    @Inject
    private ThreadSynchronize sync;
    private Function<TreeItem<SignalId>, List<TreeItem<SignalId>>> LIST_CREATOR = new Function<TreeItem<SignalId>, List<TreeItem<SignalId>>>(){

        @Override
        public List<TreeItem<SignalId>> apply(TreeItem<SignalId> item) {
            LinkedList<TreeItem<SignalId>> childrenSids = new LinkedList<TreeItem<SignalId>>();
            try {
                SignalId[] subSignals = item.getValue() != null ? DataSourceDAO.getChildSignals((int)OpcItemsPart.this.dataSource.getId(), (SignalId)((SignalId)item.getValue())) : DataSourceDAO.getRootSignals((int)OpcItemsPart.this.dataSource.getId());
                SignalId[] signalIdArray = subSignals;
                int n = subSignals.length;
                int n2 = 0;
                while (n2 < n) {
                    SignalId sid = signalIdArray[n2];
                    childrenSids.add((TreeItem<SignalId>)new LazyTreeItem((Object)sid, OpcItemsPart.this.LIST_CREATOR));
                    ++n2;
                }
                FXUtils.sortTreeItems(childrenSids);
            }
            catch (Exception exc) {
                OpcItemsPart.this.logger.error("Error browsing nodes", (Throwable)exc);
                Platform.runLater(() -> {
                    if (exc instanceof DAOOperationException) {
                        DAOOperationException daoExc = (DAOOperationException)((Object)((Object)exc));
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.initOwner(OpcItemsPart.this.scene.getWindow());
                        alert.setHeaderText("Error during browsing nodes");
                        alert.setContentText(daoExc.getMessage());
                        alert.show();
                    } else {
                        ExceptionDialog dialog = new ExceptionDialog((Throwable)exc);
                        dialog.initOwner(OpcItemsPart.this.scene.getWindow());
                        dialog.setHeaderText("Unexpected error during browsing nodes");
                        dialog.show();
                    }
                });
            }
            return childrenSids;
        }
    };

    @PostConstruct
    public void postConstruct(BorderPane parent) throws InterruptedException, ExecutionException {
        ThreadSynchronize.BlockCondition stateBlock = new ThreadSynchronize.BlockCondition();
        parent.setCenter((Node)new ProgressIndicator());
        Runnable connectTask = () -> {
            try {
                DataClientState state = DataSourceDAO.getClientState((int)this.dataSource.getId());
                while (state == DataClientState.Connecting) {
                    Thread.sleep(1000L);
                    state = DataSourceDAO.getClientState((int)this.dataSource.getId());
                }
                if (state == DataClientState.Connected) {
                    this.sync.syncExec(() -> stateBlock.release((Object)DataClientState.Connected));
                    return;
                }
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setContentText(String.format("Data client state is: %s. Connect?", state.name()));
                alert.initOwner(this.scene.getWindow());
                if (alert.showAndWait().get() == ButtonType.OK) {
                    DataSourceDAO.disconnect((int)this.dataSource.getId());
                    OperationResult result = DataSourceDAO.connect((int)this.dataSource.getId());
                    if (result.getType() != ResultType.Success) {
                        Platform.runLater(() -> {
                            Alert dialog = new Alert(Alert.AlertType.ERROR);
                            dialog.initOwner(this.scene.getWindow());
                            dialog.setContentText(result.getMessage());
                            dialog.showAndWait();
                            this.partService.hidePart(this.part, true);
                        });
                    }
                }
                this.sync.syncExec(() -> stateBlock.release((Object)DataSourceDAO.getClientState((int)this.dataSource.getId())));
            }
            catch (Exception exc) {
                Platform.runLater(() -> {
                    ExceptionDialog dialog = new ExceptionDialog((Throwable)exc);
                    dialog.initOwner(this.scene.getWindow());
                    dialog.setHeaderText("Unexpected error during browsing nodes");
                    dialog.show();
                });
                this.sync.syncExec(() -> stateBlock.release(null));
            }
        };
        this.sync.asyncExec(connectTask);
        if (this.sync.block(stateBlock) != DataClientState.Connected) {
            return;
        }
        this.menuService.registerContextMenu(this.treeView, MENU_ID);
        this.treeView.setShowRoot(false);
        this.treeView.setRoot((TreeItem)new LazyTreeItem(null, this.LIST_CREATOR));
        this.treeView.setCellFactory(cf -> new UIModelTreeCell());
        this.treeView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.selectionService.setSelection(nv != null ? nv : null));
        parent.setCenter((Node)this.progressIndicatorPane);
        this.treeView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TreeItem selectedItem = (TreeItem)OpcItemsPart.this.treeView.getSelectionModel().getSelectedItem();
                    if (selectedItem == null || selectedItem.getValue() == null) {
                        return;
                    }
                    PartUtils.showPart((String)"de.elpro.ewms.engin.gui.partstack.editors", (String)"de.elpro.ewms.engin.gui.system.processinterface.partdescriptor.opcitemattributespart", (MApplication)OpcItemsPart.this.app, (Object[])new Object[]{OpcItemsPart.this.dataSource, selectedItem});
                }
                mouseEvent.consume();
            }
        });
        this.treeView.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                SignalId sid = (SignalId)((TreeItem)OpcItemsPart.this.treeView.getSelectionModel().getSelectedItem()).getValue();
                if (sid.getType() == SignalType.Variable) {
                    Dragboard db = OpcItemsPart.this.treeView.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                    ClipboardContent content = new ClipboardContent();
                    content.putString(sid.getFullId());
                    db.setContent((Map)content);
                }
                event.consume();
            }
        });
        this.treeView.setOnDragDone((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                db.clear();
                event.consume();
            }
        });
    }

    public void updateSelection(TreeItem<SignalId> activeSelection) {
        this.treeView.getSelectionModel().select(activeSelection);
        this.treeView.scrollTo(this.treeView.getRow(activeSelection));
        if (!activeSelection.isExpanded()) {
            activeSelection.setExpanded(true);
        }
        System.out.println(activeSelection);
    }
}

