/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.bottom.part;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.VarSeries3D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.charts.ChartDAO;
import de.elpro.ewms.core.client.charts.SankeyChartDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.charts.Chart2DView;
import de.elpro.ewms.core.fx.charts.Chart3DView;
import de.elpro.ewms.core.fx.charts.SankeyChartView;
import de.elpro.ewms.core.fx.model.IDataComposition;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.tables.VarTableView;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ui.di.Refresh;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.di.ContextValue;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class PreviewPart {
    public static final String ID = "de.elpro.ewms.engin.gui.bottom.preview";
    public static final String PREVIEW_OBJECT_CTX_KEY = "preview-object";
    @Log
    @Inject
    private Logger logger;
    @Inject
    private IEclipseContext context;
    private final ObservableList<StructureObject> objects = FXCollections.observableArrayList();
    private final Label noContentLabel = new Label("No View Content.");
    private final ComboBox<StructureObject> objectCb = new ComboBox(this.objects);
    private BorderPane parent;
    private Node viewNode;
    private Object viewObject;
    private ITimeRangeFilter timeRangeFilter;
    @Inject
    private Scene scene;
    @Inject
    private ThreadSynchronize sync;
    @Inject
    @ContextValue(value="exportable-items")
    private Property<List<IExportable>> exportItems;
    private volatile boolean refreshing = false;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Label label = new Label("Structure Object");
        label.setPadding(new Insets(5.0));
        this.objectCb.setPromptText("Select Structure Object");
        this.objectCb.setCellFactory(cf -> new UIModelListCell());
        this.objectCb.setButtonCell((ListCell)new UIModelListCell());
        parent.setTop((Node)new HBox(10.0, new Node[]{label, this.objectCb}){
            {
                this.setPadding(new Insets(5.0));
            }
        });
        parent.setCenter((Node)this.noContentLabel);
        this.objectCb.valueProperty().addListener(il -> this.refresh());
        this.parent = parent;
    }

    @Inject
    private void updatePreview(@Optional @Named(value="preview-object") @Named(value="preview-object") Object object) {
        this.viewObject = object;
        this.refresh();
        this.updateEportables();
    }

    private void updateEportables() {
        if (this.viewNode instanceof IExportable) {
            LinkedList<IExportable> exportables = new LinkedList<IExportable>();
            exportables.add((IExportable)this.viewNode);
            this.exportItems.setValue(exportables);
        }
    }

    @Inject
    private void setTimeRangeFilter(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        if (this.viewNode instanceof Chart2DView) {
            ((Chart2DView)this.viewNode).loadData(timeRangeFilter);
        } else if (this.viewNode instanceof Chart3DView) {
            ((Chart3DView)this.viewNode).loadData(timeRangeFilter);
        } else if (this.viewNode instanceof VarTableView) {
            ((VarTableView)this.viewNode).loadData(timeRangeFilter);
        } else if (this.viewNode instanceof SankeyChartView) {
            ((SankeyChartView)this.viewNode).loadData(timeRangeFilter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Refresh(refreshClasses={Chart2D.class, Chart3D.class, YAxis.class, SeriesGroup.class, VarSeries2D.class, VarSeries3D.class, Table.class, ColumnGroup.class, Column.class})
    public void refresh() {
        if (this.refreshing) {
            return;
        }
        try {
            Chart2D chart;
            this.refreshing = true;
            StructureObject selectedObject = (StructureObject)this.objectCb.getValue();
            if (this.viewNode instanceof IDataComposition) {
                this.parent.setCenter(null);
                IDataComposition composition = (IDataComposition)this.viewNode;
                composition.dispose();
            }
            if (this.viewObject instanceof Chart2D) {
                TreeSet<StructureObject> chartObjects;
                Transaction trx;
                block60: {
                    block59: {
                        chart = (Chart2D)this.viewObject;
                        if (chart.getId() == null) {
                            return;
                        }
                        trx = Transactions.begin();
                        chart = ChartDAO.loadNormalized((Transaction)trx, (int)chart.getId());
                        if (chart.getCharacteristic2DSeries() != null || chart.getYAxes().stream().filter(y -> !y.getSeries().isEmpty()).count() != 0L) break block59;
                        Transactions.close((Transaction)trx);
                        return;
                    }
                    chartObjects = new TreeSet<StructureObject>();
                    Iterator iterator = chart.getStructureClasses().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (chartObjects.isEmpty()) {
                                break;
                            }
                            break block60;
                        }
                        StructureClass clazz = (StructureClass)iterator.next();
                        chartObjects.addAll(Arrays.asList(StructureClassDAO.getAllObjects((Transaction)trx, (int)clazz.getId())));
                    }
                    Transactions.close((Transaction)trx);
                    return;
                }
                try {
                    try {
                        if (selectedObject == null || !chartObjects.contains(selectedObject)) {
                            selectedObject = (StructureObject)chartObjects.iterator().next();
                        }
                        this.viewObject = chart;
                        this.viewNode = Chart2DView.create((Chart2D)chart, (StructureObject)selectedObject, (IEclipseContext)this.context.createChild());
                        this.objects.setAll(chartObjects);
                        this.objectCb.setValue((Object)selectedObject);
                        this.parent.setCenter(this.viewNode);
                        return;
                    }
                    catch (Exception exc) {
                        this.logger.error("Error creating chart view", (Throwable)exc);
                        Transactions.close((Transaction)trx);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            if (this.viewObject instanceof Chart3D) {
                Chart3D chart3d = (Chart3D)this.viewObject;
                if (chart3d.getId() == null) {
                    return;
                }
                Transaction trx = Transactions.begin();
                try {
                    chart3d = Chart3DDAO.loadNormalized((Transaction)trx, (int)chart3d.getId());
                    if (chart3d.getDataStructureClass() == null) {
                        return;
                    }
                    TreeSet<StructureObject> chartObjects = new TreeSet<StructureObject>();
                    chartObjects.addAll(Arrays.asList(StructureClassDAO.getAllObjects((Transaction)trx, (StructureClass)chart3d.getDataStructureClass())));
                    if (chartObjects.isEmpty()) {
                        return;
                    }
                    if (selectedObject == null || !chartObjects.contains(selectedObject)) {
                        selectedObject = (StructureObject)chartObjects.iterator().next();
                    }
                    this.viewObject = chart3d;
                    this.viewNode = new Chart3DView(chart3d, selectedObject, this.scene, this.timeRangeFilter);
                    this.objects.setAll(chartObjects);
                    this.objectCb.setValue((Object)selectedObject);
                    this.parent.setCenter(this.viewNode);
                    return;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            if (this.viewObject instanceof Table) {
                Table table = (Table)this.viewObject;
                if (table.getId() == null) {
                    return;
                }
                Transaction trx = Transactions.begin();
                try {
                    table = TableDAO.loadNormalized((Transaction)trx, (int)table.getId());
                    if (table.getStructureClass() == null) {
                        return;
                    }
                    TreeSet<StructureObject> chartObjects = new TreeSet<StructureObject>(Arrays.asList(StructureClassDAO.getAllObjects((Transaction)trx, (int)table.getStructureClass().getId())));
                    if (chartObjects.isEmpty()) {
                        return;
                    }
                    if (selectedObject == null || !chartObjects.contains(selectedObject)) {
                        selectedObject = (StructureObject)chartObjects.iterator().next();
                    }
                    this.viewObject = table;
                    this.viewNode = new VarTableView(table, selectedObject, this.scene.getWindow(), this.timeRangeFilter);
                    this.objects.setAll(chartObjects);
                    this.objectCb.setValue((Object)selectedObject);
                    this.parent.setCenter(this.viewNode);
                    return;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            if (!(this.viewObject instanceof SankeyChart)) return;
            chart = (SankeyChart)this.viewObject;
            if (chart.getId() == null) {
                return;
            }
            Transaction trx = Transactions.begin();
            try {
                chart = SankeyChartDAO.loadNormalized((Transaction)trx, (int)chart.getId());
                if (chart.getStructureClass() == null) {
                    return;
                }
                TreeSet<StructureObject> chartObjects = new TreeSet<StructureObject>(Arrays.asList(StructureClassDAO.getAllObjects((Transaction)trx, (int)chart.getStructureClass().getId())));
                if (chartObjects.isEmpty()) {
                    return;
                }
                if (selectedObject == null || !chartObjects.contains(selectedObject)) {
                    selectedObject = (StructureObject)chartObjects.iterator().next();
                }
                this.viewObject = chart;
                this.viewNode = new SankeyChartView((SankeyChart)chart, selectedObject, this.timeRangeFilter);
                this.objects.setAll(chartObjects);
                this.objectCb.setValue((Object)selectedObject);
                this.parent.setCenter(this.viewNode);
                return;
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            System.gc();
            this.refreshing = false;
        }
    }

    @Focus
    public void onFocus() {
        this.updateEportables();
    }
}

