/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.db.handlers;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.engin.gui.db.handlers.VariableInstanceValuesJsonSerializer;
import de.elpro.ewms.gui.utils.ExportUtils;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class ExportJsonDBHandler {
    private static final String EXPORT_ALIAS = "json_db_values";
    @Inject
    @Log
    private Logger logger;

    @Execute
    public void execute(Stage stage, final ITimeRangeFilter timeRangeFilter) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setInitialDirectory(ExportUtils.getDefaultExportFolder((String)EXPORT_ALIAS));
        final File directory = directoryChooser.showDialog(stage.getOwner());
        if (directory != null) {
            CallableTask<Void> task = new CallableTask<Void>(){
                {
                    this.updateTitle("Exporting Databases");
                }

                public Void call() throws Exception {
                    File subDir = new File(String.valueOf(directory.getPath()) + File.separator + timeRangeFilter.getType().toRawValueViewType().name());
                    if (!subDir.exists()) {
                        subDir.mkdirs();
                    }
                    if (ExportUtils.STORE_EXPORT_FOLDER) {
                        ExportUtils.setDefaultExportFolderPath((String)ExportJsonDBHandler.EXPORT_ALIAS, (String)directory.getPath());
                    }
                    this.updateMessage("Loading Variable Instances");
                    Transaction trx = Transactions.begin();
                    ArrayList<VariableInstance> variableInstances = new ArrayList<VariableInstance>();
                    try {
                        Map objects = StructureObjectDAO.getAsMap((Transaction)trx);
                        Variable[] variableArray = VariableDAO.getAll((Transaction)trx);
                        int n = variableArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Variable var = variableArray[n2];
                            VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (Variable)var);
                            int n3 = variableInstanceArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                VariableInstance inst = variableInstanceArray[n4];
                                if (inst.getType() == VariableInstanceType.PLC || inst.getSupplementValueStrategy() != null) {
                                    inst.setVariable(var);
                                    inst.setStructureObject((StructureObject)objects.get(inst.getStructureObject().getId()));
                                    variableInstances.add(inst);
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                    finally {
                        Transactions.close((Transaction)trx);
                    }
                    try {
                        int i = 0;
                        while (i < variableInstances.size()) {
                            this.updateProgress(i, variableInstances.size());
                            VariableInstance variableInstance = (VariableInstance)variableInstances.get(i);
                            this.updateMessage(String.format("Exporting %s", variableInstance.getFullName()));
                            if (variableInstance.getType() == VariableInstanceType.PLC) {
                                ArchiveValue[] values = VariableInstanceDAO.getArchiveValues((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (int)variableInstance.getId(), (Instant)timeRangeFilter.getFrom(), (Instant)timeRangeFilter.getTo());
                                VariableInstanceValuesJsonSerializer viv = new VariableInstanceValuesJsonSerializer(variableInstance.getId(), variableInstance.getFullName(), (IVarValue[])values);
                                String fileName = String.valueOf(variableInstance.getFullName()) + ".json";
                                fileName = fileName.replace('\\', '_');
                                File file = new File(subDir, fileName = fileName.replace('/', '_'));
                                if (file.exists()) {
                                    file.delete();
                                }
                                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                                    writer.write(viv.toString());
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception exc) {
                        ExportJsonDBHandler.this.logger.error("Error exporting databases", (Throwable)exc);
                        ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                        dlg.show();
                    }
                    this.updateProgress(1L, 1L);
                    this.updateMessage("Ready!");
                    return null;
                }
            };
            TaskUtils.executeUITask((CallableTask)task);
        }
    }
}

