/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.db.handlers;

import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.engin.gui.db.handlers.VariableInstanceValuesJsonSerializer;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.utils.TaskUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Stream;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class ImportJsonDBHandler {
    @Log
    @Inject
    private Logger logger;

    @Execute
    public void execute(Stage stage, final ITimeRangeFilter timeRangeFilter) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        final File directory = directoryChooser.showDialog(stage.getOwner());
        if (directory != null) {
            CallableTask<Void> task = new CallableTask<Void>(){
                {
                    this.updateTitle("Importing Databases");
                }

                public Void call() throws Exception {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (Stream<Path> paths = Files.walk(Paths.get(directory.toURI()), new FileVisitOption[0]);){
                            paths.forEach(filePath -> {
                                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                                    this.updateMessage(String.format("Importing %s", filePath));
                                    try {
                                        VariableInstanceValuesJsonSerializer viv = VariableInstanceValuesJsonSerializer.parse(ImportJsonDBHandler.readFile(filePath.toString(), StandardCharsets.UTF_8));
                                        ArchiveValue[] aValues = (ArchiveValue[])Arrays.stream(viv.getValues()).map(v -> (ArchiveValue)v).toArray(ArchiveValue[]::new);
                                        VariableInstanceDAO.importArchiveValues((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (int)viv.getInstanceId(), (ArchiveValue[])aValues);
                                    }
                                    catch (Exception exc) {
                                        ImportJsonDBHandler.this.logger.error(String.format("Cannot read %s file data", filePath.toString()), (Throwable)exc);
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exc) {
                        ImportJsonDBHandler.this.logger.error("Error importing databases", (Throwable)exc);
                    }
                    this.updateProgress(1L, 1L);
                    this.updateMessage("Ready!");
                    return null;
                }
            };
            TaskUtils.executeUITask((CallableTask)task);
        }
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

