/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.db.handlers;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.Plausibility;
import de.elpro.ewms.core.variable.value.SupplementValue;
import java.io.IOException;
import java.time.Instant;
import java.util.LinkedList;

public class VariableInstanceValuesJsonSerializer {
    protected static final String NaN = "NaN";
    protected static final String PositiveInfinity = "+Inf";
    protected static final String NegativeInfinity = "-Inf";
    private static final GsonBuilder builder = new GsonBuilder();
    private int instanceId;
    private String instanceFullName;
    private IVarValue[] values;

    static {
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(VariableInstanceValuesJsonSerializer.class, (Object)new TypeAdapter<VariableInstanceValuesJsonSerializer>(){

            public void write(JsonWriter out, VariableInstanceValuesJsonSerializer object) throws IOException {
                out.beginObject();
                out.name("instance_id");
                out.value((long)object.instanceId);
                out.name("instance_full_name");
                out.value(object.instanceFullName);
                out.name("values");
                out.beginArray();
                IVarValue[] iVarValueArray = object.values;
                int n = object.values.length;
                int n2 = 0;
                while (n2 < n) {
                    IVarValue value = iVarValueArray[n2];
                    out.beginObject();
                    if (value instanceof ArchiveValue) {
                        ArchiveValue av = (ArchiveValue)value;
                        out.name("start");
                        out.value(Instant.ofEpochMilli(av.getStartTimestamp()).toString());
                        out.name("end");
                        out.value(Instant.ofEpochMilli(av.getEndTimestamp()).toString());
                        VariableInstanceValuesJsonSerializer.writeValue(out, "value", av.getValue());
                        VariableInstanceValuesJsonSerializer.writeValue(out, "quality", av.getQuality());
                    } else if (value instanceof MeasuredValue) {
                        MeasuredValue mv = (MeasuredValue)value;
                        out.name("start");
                        out.value(Instant.ofEpochMilli(mv.getStartTimestamp()).toString());
                        out.name("end");
                        out.value(Instant.ofEpochMilli(mv.getEndTimestamp()).toString());
                        VariableInstanceValuesJsonSerializer.writeValue(out, "value", mv.getValue());
                        VariableInstanceValuesJsonSerializer.writeValue(out, "quality", mv.getQuality());
                    } else if (value instanceof SupplementValue) {
                        SupplementValue sv = (SupplementValue)value;
                        out.name("start");
                        out.value(Instant.ofEpochMilli(sv.getStartTimestamp()).toString());
                        out.name("end");
                        out.value(Instant.ofEpochMilli(sv.getEndTimestamp()).toString());
                        VariableInstanceValuesJsonSerializer.writeValue(out, "value", sv.getValue());
                        out.name("plsblty");
                        out.value((long)sv.getPlausibility().ordinal());
                        out.name("rcd");
                        out.value(Instant.ofEpochMilli(sv.getRecordedTimestamp()).toString());
                        out.name("usr_id");
                        out.value((long)sv.getUserId());
                    }
                    out.endObject();
                    ++n2;
                }
                out.endArray();
                out.endObject();
            }

            public VariableInstanceValuesJsonSerializer read(JsonReader in) throws IOException {
                in.beginObject();
                in.nextName();
                int id = in.nextInt();
                in.nextName();
                String fullName = in.nextString();
                LinkedList<Object> values = new LinkedList<Object>();
                in.nextName();
                in.beginArray();
                while (in.hasNext()) {
                    in.beginObject();
                    in.nextName();
                    Instant start = Instant.parse(in.nextString());
                    in.nextName();
                    Instant end = Instant.parse(in.nextString());
                    double value = VariableInstanceValuesJsonSerializer.readDoubleObj(in);
                    String nextName = in.nextName();
                    if (nextName.equals("quality")) {
                        double quality = in.nextDouble();
                        values.add(new ArchiveValue(start.toEpochMilli(), end.toEpochMilli(), value, quality));
                    } else {
                        Plausibility plsblty = Plausibility.values()[in.nextInt()];
                        in.nextName();
                        Instant recorded = Instant.parse(in.nextString());
                        in.nextName();
                        int userId = in.nextInt();
                        values.add(new SupplementValue(start.toEpochMilli(), end.toEpochMilli(), value, plsblty, recorded.toEpochMilli(), userId));
                    }
                    in.endObject();
                }
                in.endArray();
                in.endObject();
                VariableInstanceValuesJsonSerializer viv = new VariableInstanceValuesJsonSerializer(id, fullName, values.toArray(new IVarValue[0]));
                return viv;
            }
        });
    }

    public VariableInstanceValuesJsonSerializer(int id, String fullName, IVarValue[] values) {
        this.instanceId = id;
        this.instanceFullName = fullName;
        this.values = values;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceFullName() {
        return this.instanceFullName;
    }

    public IVarValue[] getValues() {
        return this.values;
    }

    public String toString() {
        return builder.create().toJson((Object)this);
    }

    public static VariableInstanceValuesJsonSerializer parse(String text) {
        return (VariableInstanceValuesJsonSerializer)builder.create().fromJson(text, VariableInstanceValuesJsonSerializer.class);
    }

    public static Double readDoubleObj(JsonReader reader) throws IOException {
        reader.nextName();
        JsonToken jt = reader.peek();
        switch (jt) {
            case STRING: {
                String fs;
                switch (fs = reader.nextString()) {
                    case "NaN": {
                        return Double.NaN;
                    }
                    case "+Inf": {
                        return Double.POSITIVE_INFINITY;
                    }
                    case "-Inf": {
                        return Double.NEGATIVE_INFINITY;
                    }
                }
                reader.nextNull();
                return null;
            }
            case NUMBER: {
                return reader.nextDouble();
            }
        }
        reader.nextNull();
        return null;
    }

    public static void writeValue(JsonWriter writer, String name, Double value) throws IOException {
        writer.name(name);
        if (value != null) {
            if (value.isNaN()) {
                writer.value(NaN);
            } else if (value == Double.POSITIVE_INFINITY) {
                writer.value(PositiveInfinity);
            } else if (value == Double.NEGATIVE_INFINITY) {
                writer.value(NegativeInfinity);
            } else {
                writer.value((Number)value);
            }
        } else {
            writer.nullValue();
        }
    }
}

