/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.charts.Characteristic2DSeries;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic2DDAO;
import de.elpro.ewms.core.client.charts.Characteristic2DSeriesDAO;
import de.elpro.ewms.core.client.charts.ChartDAO;
import de.elpro.ewms.core.client.charts.YAxisDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class Characteristic2DSeriesEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.chart.characteristic2dserieseditpart";
    @Inject
    private Characteristic2DSeries series;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Collection<Object> availableCharacteristics;
        Chart2D chart;
        boolean isNew;
        LinkedList yAxes = new LinkedList();
        Transaction trx = Transactions.begin();
        try {
            Characteristic2DSeries tmpSeries = Characteristic2DSeriesDAO.getByChart((Transaction)trx, (Chart2D)this.series.getChart());
            if (tmpSeries != null) {
                this.series = tmpSeries;
                isNew = false;
            } else {
                isNew = true;
            }
            chart = ChartDAO.get((Transaction)trx, (int)this.series.getChart().getId());
            this.series.setChart(chart);
            if (this.series.getYAxis() != null) {
                this.series.setYAxis(YAxisDAO.get((Transaction)trx, (int)this.series.getYAxis().getId()));
                availableCharacteristics = this.getAvailableCharacteristics(trx, chart.getStructureClasses(), chart.getXAxisPU(), this.series.getYAxis().getPhysicalUnit());
                for (Characteristic2D characteristic2D : availableCharacteristics) {
                    if (characteristic2D.getStructureClass() == null) continue;
                    characteristic2D.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)characteristic2D.getStructureClass().getId()));
                }
            } else {
                availableCharacteristics = Collections.emptyList();
            }
            if (this.series.getCharacteristic() != null) {
                this.series.setCharacteristic(Characteristic2DDAO.get((Transaction)trx, (int)this.series.getCharacteristic().getId()));
            }
            Collections.addAll(yAxes, YAxisDAO.getByChart((Transaction)trx, (Chart2D)this.series.getChart()));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        ChoicePropertyItem chartItem = new ChoicePropertyItem("Chart", (ObservableValue)this.series.chartProperty());
        ChoicePropertyItem choicePropertyItem = new ChoicePropertyItem("Y-Axis", (ObservableValue)this.series.yAxisProperty(), yAxes);
        choicePropertyItem.setNullable(false);
        choicePropertyItem.setValidator(Validators.createNotEmptyValidator((String)"Y-Axis must be set"));
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.series.titleProperty());
        ChoicePropertyItem c2dItem = new ChoicePropertyItem("Characteristic", (ObservableValue)this.series.characteristicProperty(), availableCharacteristics);
        c2dItem.setNullable(false);
        c2dItem.setValidator(Validators.createNotEmptyValidator((String)"Characteristic2D must be set"));
        PaintPropertyItem defaultColorItem = new PaintPropertyItem("Color", (ObservableValue)this.series.defaultColorProperty());
        this.series.yAxisProperty().addListener((o, ov, nv) -> {
            Transaction trxi = Transactions.begin();
            try {
                c2dItem.setChoices(this.getAvailableCharacteristics(trxi, chart.getStructureClasses(), chart.getXAxisPU(), nv != null ? nv.getPhysicalUnit() : null));
            }
            finally {
                Transactions.close((Transaction)trxi);
            }
        });
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{chartItem, titleItem, choicePropertyItem, c2dItem, defaultColorItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || isNew));
        this.part.setLabel(String.format("Characteristic2D Series: %s", this.series.toString()));
        parent.setCenter((Node)this.sheet);
    }

    protected Collection<Characteristic2D> getAvailableCharacteristics(Transaction trx, Collection<StructureClass> structureClasses, PhysicalUnit inputPU, PhysicalUnit outputPU) {
        LinkedList<Characteristic2D> characteristic2ds = new LinkedList<Characteristic2D>();
        if (inputPU == null || outputPU == null) {
            return characteristic2ds;
        }
        for (StructureClass structureClass : structureClasses) {
            Collections.addAll(characteristic2ds, Characteristic2DDAO.getAvailable((Transaction)trx, (StructureClass)structureClass, (PhysicalUnit)inputPU, (PhysicalUnit)outputPU));
        }
        return characteristic2ds;
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.series.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                Characteristic2DSeriesDAO.saveOrUpdate((Transaction)trx, (Characteristic2DSeries)this.series);
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("Characteristic2D Series: %s", this.series.toString()));
                EnginPartUtils.refreshItems(this.series, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving characteristic2d series");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Characteristic2DSeries.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

