/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.charts.Characteristic3DSeries;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.Chart3DWAxisType;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.characteristic.Characteristic3DDAO;
import de.elpro.ewms.core.client.charts.Characteristic3DSeriesDAO;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class Characteristic3DSeriesEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.chart.characteristic3dserieseditpart";
    @Inject
    private Characteristic3DSeries series;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Collection<Characteristic3D> availableCharacteristics;
        boolean isNew;
        Transaction trx = Transactions.begin();
        try {
            try {
                Integer chartId = this.series.getChart().getId();
                Chart3D chart = Chart3DDAO.get((Transaction)trx, (int)chartId);
                Characteristic3DSeries tmpSeries = Characteristic3DSeriesDAO.getByChart((Transaction)trx, (Chart3D)this.series.getChart());
                if (tmpSeries != null) {
                    this.series = tmpSeries;
                    isNew = false;
                } else {
                    isNew = true;
                }
                this.series.setChart(chart);
                availableCharacteristics = this.getAvailableCharacteristics(trx, chart.getDataStructureClass(), chart.getXAxisPhysicalUnit(), chart.getYAxisPhysicalUnit(), chart.getZAxisPhysicalUnit(), chart.getWAxisType() == Chart3DWAxisType.Variable ? chart.getWAxisPhysicalUnit() : null);
                if (chart.getWAxisType() != Chart3DWAxisType.None) {
                    availableCharacteristics.addAll(this.getAvailableCharacteristics(trx, chart.getDataStructureClass(), chart.getXAxisPhysicalUnit(), chart.getYAxisPhysicalUnit(), chart.getZAxisPhysicalUnit(), null));
                }
                for (Characteristic3D characteristic3d : availableCharacteristics) {
                    if (characteristic3d.getStructureClass() == null) continue;
                    characteristic3d.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)characteristic3d.getStructureClass().getId()));
                }
                if (this.series.getCharacteristic() != null) {
                    this.series.setCharacteristic(Characteristic3DDAO.get((Transaction)trx, (int)this.series.getCharacteristic().getId()));
                }
            }
            catch (Exception e) {
                System.err.println(e);
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        ChoicePropertyItem chartItem = new ChoicePropertyItem("Chart", (ObservableValue)this.series.chartProperty());
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.series.titleProperty());
        ChoicePropertyItem c3dItem = new ChoicePropertyItem("Characteristic", (ObservableValue)this.series.characteristicProperty(), availableCharacteristics);
        c3dItem.setNullable(false);
        c3dItem.setValidator(Validators.createNotEmptyValidator((String)"Characteristic3D must be set"));
        PaintPropertyItem defaultColorItem = new PaintPropertyItem("Color", (ObservableValue)this.series.defaultColorProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{chartItem, titleItem, c3dItem, defaultColorItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv != false || isNew));
        this.part.setLabel(String.format("Characteristic3D Series: %s", this.series.toString()));
        parent.setCenter((Node)this.sheet);
    }

    protected Collection<Characteristic3D> getAvailableCharacteristics(Transaction trx, StructureClass structureClass, PhysicalUnit inputXPU, PhysicalUnit inputYPU, PhysicalUnit outputZPU, PhysicalUnit outputWPU) {
        LinkedList<Characteristic3D> characteristic3ds = new LinkedList<Characteristic3D>();
        if (inputXPU == null || inputYPU == null) {
            return characteristic3ds;
        }
        Collections.addAll(characteristic3ds, Characteristic3DDAO.getAvailable((Transaction)trx, (StructureClass)structureClass, (PhysicalUnit)inputXPU, (PhysicalUnit)inputYPU, (PhysicalUnit)outputZPU, (PhysicalUnit)outputWPU));
        return characteristic3ds;
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.series.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                Characteristic3DSeriesDAO.saveOrUpdate((Transaction)trx, (Characteristic3DSeries)this.series);
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(String.format("Characteristic3D Series: %s", this.series.toString()));
                EnginPartUtils.refreshItems(this.series, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving characteristic3d series");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Characteristic3DSeries.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

