/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.Chart3DItemAxisColorPolicy;
import de.elpro.ewms.core.charts.Chart3DWAxisType;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.Characteristic3DSeriesDAO;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.charts.ChartGroupDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class Chart3DEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.chart3d";
    private static final String X_AXIS_GROUP = "X-Axis";
    private static final String Y_AXIS_GROUP = "Y-Axis";
    private static final String Z_AXIS_GROUP = "Z-Axis";
    private static final String W_AXIS_GROUP = "W-Axis";
    @Inject
    private Chart3D chart3d;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<ChartGroup> groups = new LinkedList<ChartGroup>();
        LinkedList<ChartGroup> classes = new LinkedList<ChartGroup>();
        try {
            ChartGroup[] chartGroupArray = ChartGroupDAO.getAll((Transaction)trx);
            int n = chartGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChartGroup group = chartGroupArray[n2];
                groups.add(group);
                ++n2;
            }
            chartGroupArray = StructureClassDAO.getAll((Transaction)trx);
            n = chartGroupArray.length;
            n2 = 0;
            while (n2 < n) {
                ChartGroup structureClass = chartGroupArray[n2];
                classes.add(structureClass);
                ++n2;
            }
            if (this.chart3d.getId() != null) {
                this.chart3d = Chart3DDAO.get((Transaction)trx, (int)this.chart3d.getId());
            }
            if (this.chart3d.getCharacteristic3DSeries() != null && this.chart3d.getCharacteristic3DSeries().getId() != null) {
                this.chart3d.setCharacteristic3DSeries(Characteristic3DSeriesDAO.getByChart((Transaction)trx, (Chart3D)this.chart3d));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.chart3d.idProperty());
        this.idItem.setReadOnly(true);
        String emptyNameMsg = "Name cannot be empty";
        String emptyAxisPUMsg = "Axis Physical Unit must be set";
        ChoicePropertyItem chartGroupItem = new ChoicePropertyItem("Group", (ObservableValue)this.chart3d.chartGroupProperty(), groups);
        ChoicePropertyItem dataClassItem = new ChoicePropertyItem("Data Class", (ObservableValue)this.chart3d.dataStructureClassProperty(), classes);
        dataClassItem.setNullable(false);
        dataClassItem.setValidator(Validators.createNotEmptyValidator((String)"Data class must be set"));
        EnumPropertyItem defaultRasterItem = new EnumPropertyItem("Default Raster", VirtualRaster.class, (ObservableValue)this.chart3d.defaultRasterProperty());
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.chart3d.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)emptyNameMsg));
        LocaleStringPropertyItem titleNameItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.chart3d.titleProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.chart3d.visualOrderPositionProperty());
        LocaleStringPropertyItem xAxisNameItem = new LocaleStringPropertyItem(X_AXIS_GROUP, "Name", (ObservableValue)this.chart3d.xAxisNameProperty());
        xAxisNameItem.setValidator(Validators.createNotEmptyValidator((String)emptyNameMsg));
        PaintPropertyItem xAxisColor = new PaintPropertyItem(X_AXIS_GROUP, "Axis Color", (ObservableValue)this.chart3d.xAxisColorProperty());
        ChoicePropertyItem xAxisPUItem = new ChoicePropertyItem(X_AXIS_GROUP, "Physical Unit", (ObservableValue)this.chart3d.xAxisPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        xAxisPUItem.setNullable(false);
        xAxisPUItem.setValidator(Validators.createNotEmptyValidator((String)emptyAxisPUMsg));
        ChoicePropertyItem xAxisMUItem = new ChoicePropertyItem(X_AXIS_GROUP, "Measuring Unit", (ObservableValue)this.chart3d.xAxisMeasuringUnitProperty(), Chart3DEditPart.getMeasuringUnits(this.chart3d.getXAxisPhysicalUnit()));
        xAxisPUItem.valueProperty().addListener((o, ov, nv) -> xAxisMUItem.setChoices(Chart3DEditPart.getMeasuringUnits(nv)));
        LocaleStringPropertyItem yAxisNameItem = new LocaleStringPropertyItem(Y_AXIS_GROUP, "Name", (ObservableValue)this.chart3d.yAxisNameProperty());
        yAxisNameItem.setValidator(Validators.createNotEmptyValidator((String)emptyNameMsg));
        PaintPropertyItem yAxisColor = new PaintPropertyItem(Y_AXIS_GROUP, "Axis Color", (ObservableValue)this.chart3d.yAxisColorProperty());
        ChoicePropertyItem yAxisPUItem = new ChoicePropertyItem(Y_AXIS_GROUP, "Physical Unit", (ObservableValue)this.chart3d.yAxisPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        yAxisPUItem.setNullable(false);
        yAxisPUItem.setValidator(Validators.createNotEmptyValidator((String)emptyAxisPUMsg));
        ChoicePropertyItem yAxisMUItem = new ChoicePropertyItem(Y_AXIS_GROUP, "Measuring Unit", (ObservableValue)this.chart3d.yAxisMeasuringUnitProperty(), Chart3DEditPart.getMeasuringUnits(this.chart3d.getYAxisPhysicalUnit()));
        yAxisPUItem.valueProperty().addListener((o, ov, nv) -> yAxisMUItem.setChoices(Chart3DEditPart.getMeasuringUnits(nv)));
        BooleanPropertyItem yAxisInvertedItem = new BooleanPropertyItem(Y_AXIS_GROUP, "Invert Axis", (ReadOnlyProperty)this.chart3d.yAxisInvertedProperty());
        LocaleStringPropertyItem zAxisNameItem = new LocaleStringPropertyItem(Z_AXIS_GROUP, "Name", (ObservableValue)this.chart3d.zAxisNameProperty());
        zAxisNameItem.setValidator(Validators.createNotEmptyValidator((String)emptyNameMsg));
        PaintPropertyItem zAxisColor = new PaintPropertyItem(Z_AXIS_GROUP, "Axis Color", (ObservableValue)this.chart3d.zAxisColorProperty());
        EnumPropertyItem zAxisItemColorPolicyItem = new EnumPropertyItem(Z_AXIS_GROUP, "Item Color Policy", Chart3DItemAxisColorPolicy.class, (ObservableValue)this.chart3d.zAxisItemColorPolicyProperty());
        ChoicePropertyItem zAxisPUItem = new ChoicePropertyItem(Z_AXIS_GROUP, "Physical Unit", (ObservableValue)this.chart3d.zAxisPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        zAxisPUItem.setNullable(false);
        zAxisPUItem.setValidator(Validators.createNotEmptyValidator((String)emptyAxisPUMsg));
        ChoicePropertyItem zAxisMUItem = new ChoicePropertyItem(Z_AXIS_GROUP, "Measuring Unit", (ObservableValue)this.chart3d.zAxisMeasuringUnitProperty(), Chart3DEditPart.getMeasuringUnits(this.chart3d.getZAxisPhysicalUnit()));
        zAxisPUItem.valueProperty().addListener((o, ov, nv) -> zAxisMUItem.setChoices(Chart3DEditPart.getMeasuringUnits(nv)));
        EnumPropertyItem wAxisTypeItem = new EnumPropertyItem(W_AXIS_GROUP, "Type", Chart3DWAxisType.class, (ObservableValue)this.chart3d.wAxisTypeProperty());
        wAxisTypeItem.setNullable(false);
        LocaleStringPropertyItem wAxisNameItem = new LocaleStringPropertyItem(W_AXIS_GROUP, "Name", (ObservableValue)this.chart3d.wAxisNameProperty());
        wAxisNameItem.setValidator(Validators.createValidator((o, ov, nv) -> this.chart3d.getWAxisType() == null || this.chart3d.getWAxisType() == Chart3DWAxisType.None || nv != null, (String)emptyNameMsg));
        EnumPropertyItem wAxisItemColorPolicyItem = new EnumPropertyItem(W_AXIS_GROUP, "Item Color Policy", Chart3DItemAxisColorPolicy.class, (ObservableValue)this.chart3d.wAxisItemColorPolicyProperty());
        wAxisItemColorPolicyItem.setValidator(Validators.createValidator((o, ov, nv) -> this.chart3d.getWAxisType() == null || this.chart3d.getWAxisType() == Chart3DWAxisType.None || nv != null, (String)"Item Color Policy must be set"));
        wAxisItemColorPolicyItem.setNullable(false);
        ChoicePropertyItem wAxisPUItem = new ChoicePropertyItem(W_AXIS_GROUP, "Physical Unit", (ObservableValue)this.chart3d.wAxisPhysicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        wAxisPUItem.setValidator(Validators.createValidator((o, ov, nv) -> this.chart3d.getWAxisType() != Chart3DWAxisType.Variable || nv != null, (String)emptyAxisPUMsg));
        ChoicePropertyItem wAxisMUItem = new ChoicePropertyItem(W_AXIS_GROUP, "Measuring Unit", (ObservableValue)this.chart3d.wAxisMeasuringUnitProperty(), Chart3DEditPart.getMeasuringUnits(this.chart3d.getWAxisPhysicalUnit()));
        wAxisPUItem.valueProperty().addListener((o, ov, nv) -> wAxisMUItem.setChoices(Chart3DEditPart.getMeasuringUnits(nv)));
        BooleanPropertyItem swapZWAxesItem = new BooleanPropertyItem(W_AXIS_GROUP, "Swap Z and W Axes", (ReadOnlyProperty)this.chart3d.swapZWAxesProperty());
        wAxisNameItem.readOnlyProperty().bind((ObservableValue)Bindings.equal((ObservableObjectValue)this.chart3d.wAxisTypeProperty(), (Object)Chart3DWAxisType.None));
        wAxisItemColorPolicyItem.readOnlyProperty().bind((ObservableValue)Bindings.equal((ObservableObjectValue)this.chart3d.wAxisTypeProperty(), (Object)Chart3DWAxisType.None));
        wAxisPUItem.readOnlyProperty().bind((ObservableValue)Bindings.notEqual((ObservableObjectValue)this.chart3d.wAxisTypeProperty(), (Object)Chart3DWAxisType.Variable));
        wAxisMUItem.readOnlyProperty().bind((ObservableValue)Bindings.notEqual((ObservableObjectValue)this.chart3d.wAxisTypeProperty(), (Object)Chart3DWAxisType.Variable));
        swapZWAxesItem.readOnlyProperty().bind((ObservableValue)Bindings.equal((ObservableObjectValue)this.chart3d.wAxisTypeProperty(), (Object)Chart3DWAxisType.None));
        wAxisTypeItem.valueProperty().addListener(il -> {
            wAxisNameItem.forceValidate();
            wAxisItemColorPolicyItem.forceValidate();
            wAxisPUItem.forceValidate();
            wAxisMUItem.forceValidate();
        });
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, chartGroupItem, dataClassItem, defaultRasterItem, nameItem, titleNameItem, visualOrderPositionItem, xAxisNameItem, xAxisColor, xAxisPUItem, xAxisMUItem, yAxisNameItem, yAxisColor, yAxisPUItem, yAxisMUItem, yAxisInvertedItem, zAxisNameItem, zAxisColor, zAxisItemColorPolicyItem, zAxisPUItem, zAxisMUItem, wAxisTypeItem, wAxisNameItem, wAxisItemColorPolicyItem, wAxisPUItem, wAxisMUItem, swapZWAxesItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("3D Chart: %s", this.chart3d.toString()));
        this.focus();
    }

    private Collection<Variable> getAvailableVariables(PhysicalUnit unit) {
        if (unit == null || this.chart3d.getDataStructureClass() == null) {
            return new LinkedList<Variable>();
        }
        Transaction trx = Transactions.begin();
        try {
            List<Variable> list = Arrays.asList(VariableDAO.getAll((Transaction)trx, (PhysicalUnit)unit));
            return list;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private static Collection<MeasuringUnit> getMeasuringUnits(PhysicalUnit physicalUnit) {
        if (physicalUnit == null) {
            return Collections.emptyList();
        }
        return physicalUnit.getMeasuringUnits();
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.chart3d.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)Chart3DDAO.saveOrUpdate((Transaction)trx, (Chart3D)this.chart3d));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.chart3d.toString());
                EnginPartUtils.refreshItems(this.chart3d, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save chart", (Exception)((Object)exc), (Window)this.sheet.getScene().getWindow());
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Chart3D.class);
        this.part.setLabel(String.format("3D Chart: %s", this.chart3d.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.chart3d);
    }
}

