/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.PlotType;
import de.elpro.ewms.core.charts.XAxisType;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.ChartDAO;
import de.elpro.ewms.core.client.charts.ChartGroupDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.MultChoicesPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import jidefx.scene.control.validation.ValidationEvent;
import org.controlsfx.control.PropertySheet;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ChartEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.chart";
    @Inject
    private Chart2D chart;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;
    private ObjectProperty<PhysicalUnit> clusteringPU = new SimpleObjectProperty();

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<ChartGroup> groups = new LinkedList<ChartGroup>();
        LinkedList<ChartGroup> classes = new LinkedList<ChartGroup>();
        try {
            ChartGroup[] chartGroupArray = ChartGroupDAO.getAll((Transaction)trx);
            int n = chartGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChartGroup group = chartGroupArray[n2];
                groups.add(group);
                ++n2;
            }
            chartGroupArray = StructureClassDAO.getAll((Transaction)trx);
            n = chartGroupArray.length;
            n2 = 0;
            while (n2 < n) {
                ChartGroup structureClass = chartGroupArray[n2];
                classes.add(structureClass);
                ++n2;
            }
            if (this.chart.getId() != null) {
                this.chart = ChartDAO.get((Transaction)trx, (int)this.chart.getId());
            }
            if (this.chart.getClusteringVariable() != null) {
                this.chart.setClusteringVariable(VariableDAO.get((Transaction)trx, (int)this.chart.getClusteringVariable().getId()));
                this.clusteringPU.set((Object)this.chart.getClusteringVariable().getPhysicalUnit());
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.chart.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem chartGroupItem = new ChoicePropertyItem("Group", (ObservableValue)this.chart.chartGroupProperty(), groups);
        MultChoicesPropertyItem classesItem = new MultChoicesPropertyItem("At Classes", (Collection)this.chart.getStructureClasses(), classes);
        EnumPropertyItem plotTypeItem = new EnumPropertyItem("Plot Type", PlotType.class, (ObservableValue)this.chart.plotTypeProperty());
        plotTypeItem.setNullable(false);
        EnumPropertyItem defaultRasterItem = new EnumPropertyItem("Default Raster", VirtualRaster.class, (ObservableValue)this.chart.defaultRasterProperty());
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.chart.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name cannot be empty"));
        LocaleStringPropertyItem titleNameItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.chart.titleProperty());
        LocaleStringPropertyItem xAxisTitleItem = new LocaleStringPropertyItem("X Axis:\tTitle", (ObservableValue)this.chart.xAxisTitleProperty());
        EnumPropertyItem notesSearchPolicyItem = new EnumPropertyItem("Notes Search Policy", SearchPolicy.class, (ObservableValue)this.chart.notesSearchPolicyProperty());
        EnumPropertyItem notesFilterItem = new EnumPropertyItem("Notes Filter", NoteType.class, (ObservableValue)this.chart.notesFilterProperty());
        notesFilterItem.setNullable(false);
        notesFilterItem.setValidator(Validators.createNotEmptyValidator((String)"Filter must be set"));
        EnumPropertyItem xAxisTypeItem = new EnumPropertyItem("\t\tType", XAxisType.class, (ObservableValue)this.chart.xAxisTypeProperty());
        xAxisTypeItem.setNullable(false);
        ChoicePropertyItem xAxisPUItem = new ChoicePropertyItem("\t\tPhysical Unit", (ObservableValue)this.chart.xAxisPUProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        xAxisPUItem.setValidator(Validators.createValidator((o, ov, nv) -> this.chart.getXAxisType() != XAxisType.Variable || nv != null, (String)"Physical Unit must be not empty for charts with X Axis type 'Variable'"));
        ChoicePropertyItem xAxisVarItem = new ChoicePropertyItem("\t\tVariable", (ObservableValue)this.chart.xAxisVariableProperty(), this.getAvailableVariables(this.chart.getXAxisPU()));
        xAxisVarItem.setValidator(Validators.createValidator((o, ov, nv) -> this.chart.getXAxisType() != XAxisType.Variable || nv != null, (EventType)ValidationEvent.VALIDATION_WARNING, (String)"No X-Axis variable"));
        ChoicePropertyItem xAxisMUItem = new ChoicePropertyItem("\t\tMeasuring Unit", (ObservableValue)this.chart.xAxisMUProperty(), this.chart.getXAxisPU() == null ? new LinkedList() : this.chart.getXAxisPU().getMeasuringUnits());
        xAxisMUItem.setValidator(Validators.createValidator((o, ov, nv) -> this.chart.getXAxisType() != XAxisType.Variable || nv != null || this.chart.getXAxisVariable() != null, (String)"Default Measuring Unit must be set if no X-Axis Variable specified."));
        xAxisPUItem.valueProperty().addListener((o, ov, nv) -> {
            xAxisVarItem.setChoices(this.getAvailableVariables((PhysicalUnit)nv));
            xAxisMUItem.setChoices(nv == null ? new LinkedList() : nv.getMeasuringUnits());
        });
        ChoicePropertyItem clusteringPUItem = new ChoicePropertyItem("Clustering Phys. Unit", this.clusteringPU, PhysicalUnitRegistry.getPhysicalUnits());
        ChoicePropertyItem clusteringVarItem = new ChoicePropertyItem("\t\tVariable", (ObservableValue)this.chart.clusteringVariableProperty(), this.getAvailableVariables((PhysicalUnit)this.clusteringPU.get()));
        clusteringPUItem.valueProperty().addListener((o, ov, nv) -> clusteringVarItem.setChoices(this.getAvailableVariables((PhysicalUnit)nv)));
        Runnable typeChangeListener = () -> {
            boolean disabled = this.chart.getXAxisType() != XAxisType.Variable;
            xAxisPUItem.setReadOnly(disabled);
            xAxisPUItem.forceValidate();
            xAxisVarItem.setReadOnly(disabled);
            xAxisVarItem.forceValidate();
            xAxisMUItem.setReadOnly(disabled);
            xAxisMUItem.forceValidate();
            clusteringPUItem.setReadOnly(disabled);
            clusteringVarItem.setReadOnly(disabled);
        };
        xAxisVarItem.valueProperty().addListener((o, ov, nv) -> xAxisMUItem.forceValidate());
        typeChangeListener.run();
        xAxisTypeItem.valueProperty().addListener((o, ov, nv) -> typeChangeListener.run());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.chart.visualOrderPositionProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, chartGroupItem, plotTypeItem, defaultRasterItem, classesItem, nameItem, titleNameItem, visualOrderPositionItem, new SeparatorItem(), notesSearchPolicyItem, notesFilterItem, new SeparatorItem(), xAxisTitleItem, xAxisTypeItem, xAxisPUItem, xAxisVarItem, xAxisMUItem, clusteringPUItem, clusteringVarItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("Chart: %s", this.chart.toString()));
        this.focus();
    }

    private Collection<Variable> getAvailableVariables(PhysicalUnit unit) {
        if (unit == null) {
            return new LinkedList<Variable>();
        }
        Transaction trx = Transactions.begin();
        try {
            List<Variable> list = Arrays.asList(VariableDAO.getAll((Transaction)trx, (PhysicalUnit)unit));
            return list;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.chart.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ChartDAO.saveOrUpdate((Transaction)trx, (Chart2D)this.chart));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.chart.toString());
                EnginPartUtils.refreshItems(this.chart, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save chart", (Exception)((Object)exc), (Window)this.sheet.getScene().getWindow());
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Chart2D.class);
        this.part.setLabel(String.format("Chart: %s", this.chart.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.chart);
    }
}

