/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.Chart3DWAxisType;
import de.elpro.ewms.core.charts.FunctionSeries3D;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.charts.FunctionSeries3DDAO;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.PropertyGroupDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class FunctionSeries3DEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.functionseries3d";
    @Inject
    private FunctionSeries3D series;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<Property> functionProperties = new LinkedList<Property>();
        try {
            if (this.series.getId() != null) {
                this.series = FunctionSeries3DDAO.get((Transaction)trx, (int)this.series.getId());
            }
            this.series.setChart(Chart3DDAO.get((Transaction)trx, (int)this.series.getChart().getId()));
            functionProperties.addAll(Arrays.asList(PropertyDAO.get((Transaction)trx, (StructureClass)this.series.getChart().getDataStructureClass(), (String)"de.elpro.ewms.core.structure.propertytypes.formula")));
            for (Property p2 : functionProperties) {
                p2.setGroup(PropertyGroupDAO.get((Transaction)trx, (String)p2.getGroup().getKey()));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.series.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem chartItem = new ChoicePropertyItem("Chart", (ObservableValue)this.series.chartProperty());
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.series.titleProperty());
        titleItem.setValidator(Validators.createNotEmptyValidator((String)"Title must be not empty"));
        PaintPropertyItem defaultColorItem = new PaintPropertyItem("Default Color", (ObservableValue)this.series.defaultColorProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.series.visualOrderPositionProperty());
        ChoicePropertyItem yPropertyItem = new ChoicePropertyItem("Z=F(x,w) Property", (ObservableValue)this.series.zFunctionPropertyProperty(), functionProperties);
        yPropertyItem.setTextCallback(p -> String.format("%s / %s", p.getGroup().getLocalName(), p.getLocalName()));
        yPropertyItem.setNullable(false);
        yPropertyItem.setValidator(Validators.createNotEmptyValidator());
        ChoicePropertyItem wPropertyItem = new ChoicePropertyItem("W=F(x,y,z) Property", (ObservableValue)this.series.wFunctionPropertyProperty(), functionProperties);
        wPropertyItem.setTextCallback(p -> String.format("%s / %s", p.getGroup().getLocalName(), p.getLocalName()));
        StringPropertyItem xAxisParamItem = new StringPropertyItem("X-Axis Parameter", (ObservableValue)this.series.xAxisParameterProperty());
        xAxisParamItem.setValidator(Validators.createNotEmptyValidator());
        ChoicePropertyItem xAxisMUItem = new ChoicePropertyItem("X-Axis  Measuring Unit", (ObservableValue)this.series.xAxisMUProperty(), this.series.getChart().getXAxisPhysicalUnit().getMeasuringUnits());
        xAxisMUItem.setNullable(false);
        xAxisMUItem.setValidator(Validators.createNotEmptyValidator());
        StringPropertyItem yAxisParamItem = new StringPropertyItem("Y-Axis Parameter", (ObservableValue)this.series.yAxisParameterProperty());
        yAxisParamItem.setValidator(Validators.createNotEmptyValidator());
        ChoicePropertyItem yAxisMUItem = new ChoicePropertyItem("Y-Axis  Measuring Unit", (ObservableValue)this.series.yAxisMUProperty(), this.series.getChart().getYAxisPhysicalUnit().getMeasuringUnits());
        yAxisMUItem.setNullable(false);
        yAxisMUItem.setValidator(Validators.createNotEmptyValidator());
        StringPropertyItem zAxisParamItem = new StringPropertyItem("Z-Axis Parameter", (ObservableValue)this.series.zAxisParameterProperty());
        zAxisParamItem.setValidator(Validators.createValidator((o, ov, nv) -> this.series.getWFunctionProperty() == null || this.series.getZAxisParameter() != null && !this.series.getZAxisParameter().isEmpty(), (String)Validators.DEFAULT_EMPTY_MESSAGE));
        ChoicePropertyItem zAxisMUItem = new ChoicePropertyItem("Z-Axis  Measuring Unit", (ObservableValue)this.series.zAxisMUProperty(), this.series.getChart().getZAxisPhysicalUnit().getMeasuringUnits());
        zAxisMUItem.setNullable(false);
        zAxisMUItem.setValidator(Validators.createNotEmptyValidator());
        wPropertyItem.valueProperty().addListener(o -> zAxisParamItem.forceValidate());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, chartItem, titleItem, defaultColorItem, visualOrderPositionItem, yPropertyItem, wPropertyItem, xAxisParamItem, xAxisMUItem, yAxisParamItem, yAxisMUItem, zAxisParamItem, zAxisMUItem});
        if (this.series.getChart().getWAxisType() == Chart3DWAxisType.Variable) {
            ChoicePropertyItem wAxisMUItem = new ChoicePropertyItem("W-Axis Measuring Unit", (ObservableValue)this.series.wAxisMUProperty(), this.series.getChart().getWAxisPhysicalUnit().getMeasuringUnits());
            wAxisMUItem.setNullable(false);
            wAxisMUItem.setValidator(Validators.createNotEmptyValidator());
            this.sheet.getItems().add((Object)wAxisMUItem);
        }
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("3D Function Series: %s", this.series.toString()));
        this.focus();
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.series.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)FunctionSeries3DDAO.saveOrUpdate((Transaction)trx, (FunctionSeries3D)this.series));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.series.toString());
                EnginPartUtils.refreshItems(this.series, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save chart", (Exception)((Object)exc), (Window)this.sheet.getScene().getWindow());
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Chart3D.class);
        this.part.setLabel(String.format("3D Function Series: %s", this.series.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.series.getChart());
    }
}

