/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.ChartGroupDAO;
import de.elpro.ewms.core.client.charts.SankeyChartDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.core.units.UsageDomains;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class SankeyChartEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.sankeychart";
    @Inject
    private SankeyChart chart;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<ChartGroup> groups = new LinkedList<ChartGroup>();
        LinkedList<ChartGroup> classes = new LinkedList<ChartGroup>();
        try {
            ChartGroup[] chartGroupArray = ChartGroupDAO.getAll((Transaction)trx);
            int n = chartGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChartGroup group = chartGroupArray[n2];
                groups.add(group);
                ++n2;
            }
            chartGroupArray = StructureClassDAO.getAll((Transaction)trx);
            n = chartGroupArray.length;
            n2 = 0;
            while (n2 < n) {
                ChartGroup structureClass = chartGroupArray[n2];
                classes.add(structureClass);
                ++n2;
            }
            if (this.chart.getId() != null) {
                this.chart = SankeyChartDAO.get((Transaction)trx, (int)this.chart.getId());
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.chart.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem chartGroupItem = new ChoicePropertyItem("Group", (ObservableValue)this.chart.chartGroupProperty(), groups);
        ChoicePropertyItem classItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.chart.structureClassProperty(), classes);
        classItem.setNullable(false);
        classItem.setValidator(Validators.createNotEmptyValidator((String)"Structure Class must be set"));
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.chart.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Nam must be not empty"));
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.chart.titleProperty());
        ChoicePropertyItem puItem = new ChoicePropertyItem("Physical Unit", (ObservableValue)this.chart.physicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        puItem.setNullable(false);
        puItem.setValidator(Validators.createNotEmptyValidator((String)"Physical Unit must be set"));
        ChoicePropertyItem muItem = new ChoicePropertyItem("Default Measuring Unit", (ObservableValue)this.chart.defaultMeasuringUnitProperty(), this.chart.getPhysicalUnit() == null ? new LinkedList() : this.chart.getPhysicalUnit().getMeasuringUnits());
        if (this.chart.getPhysicalUnit() != null) {
            muItem.setPromptText(String.format("Default: %s", this.chart.getPhysicalUnit().getMeasuringUnit(UsageDomains.DEFAULT)));
        }
        puItem.valueProperty().addListener((o, ov, nv) -> {
            muItem.setChoices(nv == null ? new LinkedList() : nv.getMeasuringUnits());
            if (nv != null) {
                muItem.setPromptText(String.format("Default: %s", nv.getMeasuringUnit(UsageDomains.DEFAULT)));
            } else {
                muItem.setPromptText(null);
            }
        });
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.chart.visualOrderPositionProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, chartGroupItem, classItem, nameItem, titleItem, puItem, muItem, visualOrderPositionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("Sankey Chart: %s", this.chart.toString()));
        this.focus();
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.chart.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)SankeyChartDAO.saveOrUpdate((Transaction)trx, (SankeyChart)this.chart));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.chart.toString());
                EnginPartUtils.refreshItems(this.chart, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving sankey chart group");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, SankeyChart.class);
        this.part.setLabel(String.format("Sankey Chart: %s", this.chart.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.chart);
    }
}

