/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.charts.SankeyNode;
import de.elpro.ewms.core.charts.SankeyNodeType;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.SankeyChartDAO;
import de.elpro.ewms.core.client.charts.SankeyNodeDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class SankeyNodeEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.sankeynode";
    @Inject
    private SankeyNode node;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<StructureClass> classes = new LinkedList<StructureClass>();
        try {
            if (this.node.getId() != null) {
                this.node = SankeyNodeDAO.get((Transaction)trx, (int)this.node.getId());
            }
            StructureClass[] structureClassArray = StructureClassDAO.getAll((Transaction)trx);
            int n = structureClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureClass structureClass = structureClassArray[n2];
                classes.add(structureClass);
                ++n2;
            }
            this.node.setChart(SankeyChartDAO.get((Transaction)trx, (int)this.node.getChart().getId()));
            if (this.node.getParentNode() != null) {
                this.node.setParentNode(SankeyNodeDAO.get((Transaction)trx, (int)this.node.getParentNode().getId()));
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.node.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem chartItem = new ChoicePropertyItem("Sankey Chart", (ObservableValue)this.node.chartProperty());
        ChoicePropertyItem parentItem = new ChoicePropertyItem("Parent Node", (ObservableValue)this.node.parentNodeProperty());
        EnumPropertyItem typeItem = new EnumPropertyItem("Type", SankeyNodeType.class, (ObservableValue)this.node.typeProperty());
        typeItem.setNullable(false);
        ChoicePropertyItem classItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.node.structureClassProperty(), classes);
        classItem.setNullable(false);
        classItem.setValidator(Validators.createNotEmptyValidator((String)"Structure Class must be set"));
        ChoicePropertyItem variableItem = new ChoicePropertyItem("Variable", (ObservableValue)this.node.variableProperty(), this.getAvailableVariables());
        variableItem.setNullable(false);
        variableItem.setValidator(Validators.createNotEmptyValidator((String)"Variable must be set"));
        classItem.valueProperty().addListener(il -> variableItem.setChoices(this.getAvailableVariables()));
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.node.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name must be not empty"));
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.node.titleProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, chartItem, parentItem, typeItem, classItem, variableItem, nameItem, titleItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("Sankey Node: %s", this.node.toString()));
        this.focus();
    }

    private Collection<Variable> getAvailableVariables() {
        LinkedList<Variable> vars = new LinkedList<Variable>();
        if (this.node.getStructureClass() != null) {
            Transaction trx = Transactions.begin();
            try {
                Variable[] variableArray = StructureClassDAO.getAllVariables((Transaction)trx, (int)this.node.getStructureClass().getId());
                int n = variableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Variable var = variableArray[n2];
                    if (var.getPhysicalUnit().equals((Object)this.node.getChart().getPhysicalUnit())) {
                        vars.add(var);
                    }
                    ++n2;
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
        return vars;
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.node.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)SankeyNodeDAO.saveOrUpdate((Transaction)trx, (SankeyNode)this.node));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.node.toString());
                EnginPartUtils.refreshItems(this.node, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving sankey node");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, SankeyNode.class);
        this.part.setLabel(String.format("Sankey Node: %s", this.node.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.node);
    }
}

