/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.charts.DurationCurveType;
import de.elpro.ewms.core.charts.LineType;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.SeriesGroupDAO;
import de.elpro.ewms.core.client.charts.VarSeriesDAO;
import de.elpro.ewms.core.client.charts.YAxisDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.TextUtils;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class VarSeries2DEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.varseries2d";
    @Inject
    private VarSeries2D series;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        YAxis yAxis = null;
        Transaction trx = Transactions.begin();
        LinkedList<SeriesGroup> availableSeriesGroups = new LinkedList<SeriesGroup>();
        LinkedList<Variable> availableVariables = new LinkedList<Variable>();
        try {
            if (this.series.getId() != null) {
                this.series = VarSeriesDAO.get((Transaction)trx, (int)this.series.getId());
            }
            if (this.series.getVariable() != null) {
                this.series.setVariable(VariableDAO.get((Transaction)trx, (int)this.series.getVariable().getId()));
            }
            yAxis = YAxisDAO.get((Transaction)trx, (int)this.series.getYAxis().getId());
            this.series.setYAxis(yAxis);
            if (this.series.getSeriesGroup() != null) {
                this.series.setSeriesGroup(SeriesGroupDAO.get((Transaction)trx, (int)this.series.getSeriesGroup().getId()));
            }
            for (SeriesGroup seriesGroup : yAxis.getSeriesGroups()) {
                availableSeriesGroups.add(SeriesGroupDAO.get((Transaction)trx, (int)seriesGroup.getId()));
            }
            Variable[] variableArray = VariableDAO.getAll((Transaction)trx, (PhysicalUnit)yAxis.getPhysicalUnit());
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Variable var2 = variableArray[n2];
                availableVariables.add(var2);
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.series.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem yAxisItem = new ChoicePropertyItem("Y-Axis", (ObservableValue)this.series.yAxisProperty());
        ChoicePropertyItem seriesGroupItem = new ChoicePropertyItem("Group", (ObservableValue)this.series.groupProperty(), availableSeriesGroups);
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.series.titleProperty());
        ChoicePropertyItem variableItem = new ChoicePropertyItem("Variable", (ObservableValue)this.series.variableProperty(), availableVariables);
        variableItem.setTextCallback(var -> {
            if (var.getDescription() == null || var.getDescription().isEmpty()) {
                return var.toString();
            }
            return String.format("%s (%s)", var, TextUtils.getFirstLine((String)var.getDescription(), (int)150));
        });
        variableItem.setNullable(false);
        variableItem.setValidator(Validators.createNotEmptyValidator((String)"Variable of Series Data must be set"));
        ChoicePropertyItem variableInstanceItem = new ChoicePropertyItem("Fixed Instance", (ObservableValue)this.series.variableInstanceProperty(), this.getAvailableVariableInstances());
        variableItem.valueProperty().addListener(il -> variableInstanceItem.setChoices(this.getAvailableVariableInstances()));
        BooleanPropertyItem durationCurveItem = new BooleanPropertyItem("Duration Curve", (ReadOnlyProperty)this.series.durationCurveProperty());
        EnumPropertyItem durationCurveTypeItem = new EnumPropertyItem("Duration Curve Type", DurationCurveType.class, (ObservableValue)this.series.durationCurveTypeProperty());
        durationCurveTypeItem.hiddenProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.series.durationCurveProperty()));
        durationCurveTypeItem.setNullable(false);
        EnumPropertyItem searchPolicyItem = new EnumPropertyItem("Search Policy", SearchPolicy.class, (ObservableValue)this.series.searchPolicyProperty());
        searchPolicyItem.setReadOnly(this.series.getVariableInstance() != null);
        variableInstanceItem.valueProperty().addListener((o, ov, nv) -> searchPolicyItem.setReadOnly(nv != null));
        PaintPropertyItem defaultLineColorItem = new PaintPropertyItem("Color", (ObservableValue)this.series.defaultColorProperty());
        EnumPropertyItem lineTypeItem = new EnumPropertyItem("Line:\t\tType", LineType.class, (ObservableValue)this.series.lineTypeProperty());
        lineTypeItem.setNullable(false);
        IntegerPropertyItem lineWidthItem = new IntegerPropertyItem("\t\tWidth", (ObservableValue)this.series.lineWidthProperty());
        lineWidthItem.setPromptText("Default: 1");
        EnumPropertyItem shapeTypeItem = new EnumPropertyItem("Shape:\tType", ShapeType.class, (ObservableValue)this.series.shapeTypeProperty());
        shapeTypeItem.setNullable(false);
        IntegerPropertyItem shapeSizeItem = new IntegerPropertyItem("\t\tSize", (ObservableValue)this.series.shapeSizeProperty());
        shapeSizeItem.setPromptText("Default: 4");
        BooleanPropertyItem showValuesBounds = new BooleanPropertyItem("Show Values Bounds", (ReadOnlyProperty)this.series.showValuesBoundsProperty());
        BooleanPropertyItem showValuesLabels = new BooleanPropertyItem("Show Values Labels", (ReadOnlyProperty)this.series.showValuesLabelsProperty());
        ChoicePropertyItem valueMeasuringUnitFormatItem = new ChoicePropertyItem("Value Format", (ObservableValue)this.series.valueMeasuringUnitFormatProperty(), MeasuringUnitFormats.getFormats());
        BooleanPropertyItem isVisibleProperty = new BooleanPropertyItem("Enabled", (ReadOnlyProperty)this.series.isVisibleProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.series.visualOrderPositionProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, yAxisItem, seriesGroupItem, titleItem, variableItem, variableInstanceItem, durationCurveItem, durationCurveTypeItem, searchPolicyItem, new SeparatorItem(), defaultLineColorItem, lineTypeItem, lineWidthItem, shapeTypeItem, shapeSizeItem, new SeparatorItem(), showValuesBounds, showValuesLabels, valueMeasuringUnitFormatItem, new SeparatorItem(), isVisibleProperty, visualOrderPositionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.focus();
    }

    private Collection<VariableInstance> getAvailableVariableInstances() {
        LinkedList<VariableInstance> instances = new LinkedList<VariableInstance>();
        if (this.series.getVariable() != null) {
            Transaction trx = Transactions.begin();
            try {
                VariableInstance[] variableInstanceArray = VariableInstanceDAO.getAll((Transaction)trx, (Variable)this.series.getVariable(), (boolean)true);
                int n = variableInstanceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableInstance instance = variableInstanceArray[n2];
                    instances.add(instance);
                    ++n2;
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
        }
        return instances;
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.series.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)VarSeriesDAO.saveOrUpdate((Transaction)trx, (VarSeries2D)this.series));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.series.toString());
                EnginPartUtils.refreshItems(this.series, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving var series");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, VarSeries2D.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.series.getYAxis().getChart());
    }
}

