/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.Chart3DWAxisType;
import de.elpro.ewms.core.charts.VarSeries3D;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.charts.VarSeries3DDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ewms.gui.dialogs.DialogFactory;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class VarSeries3DEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.varseries3d";
    private static final String X_AXIS_GROUP = "X-Axis";
    private static final String Y_AXIS_GROUP = "Y-Axis";
    private static final String Z_AXIS_GROUP = "Z-Axis";
    private static final String W_AXIS_GROUP = "W-Axis";
    @Inject
    private VarSeries3D series;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        LinkedList<Variable> xAxisVars = new LinkedList<Variable>();
        LinkedList<Variable> yAxisVars = new LinkedList<Variable>();
        LinkedList<Variable> zAxisVars = new LinkedList<Variable>();
        LinkedList<Variable> wAxisVars = new LinkedList<Variable>();
        try {
            if (this.series.getId() != null) {
                this.series = VarSeries3DDAO.get((Transaction)trx, (int)this.series.getId());
            }
            this.series.setChart(Chart3DDAO.get((Transaction)trx, (int)this.series.getChart().getId()));
            xAxisVars.addAll(Arrays.asList(VariableDAO.getAll((Transaction)trx, (PhysicalUnit)this.series.getChart().getXAxisPhysicalUnit())));
            yAxisVars.addAll(Arrays.asList(VariableDAO.getAll((Transaction)trx, (PhysicalUnit)this.series.getChart().getYAxisPhysicalUnit())));
            zAxisVars.addAll(Arrays.asList(VariableDAO.getAll((Transaction)trx, (PhysicalUnit)this.series.getChart().getZAxisPhysicalUnit())));
            if (this.series.getChart().getWAxisType() == Chart3DWAxisType.Variable) {
                wAxisVars.addAll(Arrays.asList(VariableDAO.getAll((Transaction)trx, (PhysicalUnit)this.series.getChart().getWAxisPhysicalUnit())));
            }
            if (this.series.getXAxisVariable() != null && !xAxisVars.contains(this.series.getXAxisVariable())) {
                this.series.setXAxisVariable(null);
            }
            if (this.series.getYAxisVariable() != null && !yAxisVars.contains(this.series.getYAxisVariable())) {
                this.series.setYAxisVariable(null);
            }
            if (this.series.getZAxisVariable() != null && !zAxisVars.contains(this.series.getZAxisVariable())) {
                this.series.setZAxisVariable(null);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.series.idProperty());
        this.idItem.setReadOnly(true);
        String emptyVariableMsg = "Axis Variable must be set";
        ChoicePropertyItem chartItem = new ChoicePropertyItem("Chart", (ObservableValue)this.series.chartProperty());
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.series.titleProperty());
        titleItem.setValidator(Validators.createNotEmptyValidator((String)"Title must be not empty"));
        PaintPropertyItem defaultColorItem = new PaintPropertyItem("Default Color", (ObservableValue)this.series.defaultColorProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.series.visualOrderPositionProperty());
        ChoicePropertyItem xAxisVariableItem = new ChoicePropertyItem(X_AXIS_GROUP, "Variable", (ObservableValue)this.series.xAxisVariableProperty(), xAxisVars);
        xAxisVariableItem.setNullable(false);
        xAxisVariableItem.setValidator(Validators.createNotEmptyValidator((String)emptyVariableMsg));
        ChoicePropertyItem xAxisVarInstItem = new ChoicePropertyItem(X_AXIS_GROUP, "Instance", (ObservableValue)this.series.xAxisVariableInstanceProperty(), VarSeries3DEditPart.getInstances(this.series.getXAxisVariable()));
        ChoicePropertyItem yAxisVariableItem = new ChoicePropertyItem(Y_AXIS_GROUP, "Variable", (ObservableValue)this.series.yAxisVariableProperty(), yAxisVars);
        yAxisVariableItem.setNullable(false);
        yAxisVariableItem.setValidator(Validators.createNotEmptyValidator((String)emptyVariableMsg));
        ChoicePropertyItem yAxisVarInstItem = new ChoicePropertyItem(Y_AXIS_GROUP, "Instance", (ObservableValue)this.series.yAxisVariableInstanceProperty(), VarSeries3DEditPart.getInstances(this.series.getYAxisVariable()));
        ChoicePropertyItem zAxisVariableItem = new ChoicePropertyItem(Z_AXIS_GROUP, "Variable", (ObservableValue)this.series.zAxisVariableProperty(), zAxisVars);
        zAxisVariableItem.setNullable(false);
        zAxisVariableItem.setValidator(Validators.createNotEmptyValidator((String)emptyVariableMsg));
        ChoicePropertyItem zAxisVarInstItem = new ChoicePropertyItem(Z_AXIS_GROUP, "Instance", (ObservableValue)this.series.zAxisVariableInstanceProperty(), VarSeries3DEditPart.getInstances(this.series.getZAxisVariable()));
        xAxisVariableItem.valueProperty().addListener(o -> xAxisVarInstItem.setChoices(VarSeries3DEditPart.getInstances(this.series.getXAxisVariable())));
        yAxisVariableItem.valueProperty().addListener(o -> yAxisVarInstItem.setChoices(VarSeries3DEditPart.getInstances(this.series.getYAxisVariable())));
        zAxisVariableItem.valueProperty().addListener(o -> zAxisVarInstItem.setChoices(VarSeries3DEditPart.getInstances(this.series.getZAxisVariable())));
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, chartItem, titleItem, defaultColorItem, visualOrderPositionItem, xAxisVariableItem, xAxisVarInstItem, yAxisVariableItem, yAxisVarInstItem, zAxisVariableItem, zAxisVarInstItem});
        if (this.series.getChart().getWAxisType() == Chart3DWAxisType.Variable) {
            ChoicePropertyItem wAxisVariableItem = new ChoicePropertyItem(W_AXIS_GROUP, "Variable", (ObservableValue)this.series.wAxisVariableProperty(), wAxisVars);
            wAxisVariableItem.setNullable(false);
            wAxisVariableItem.setValidator(Validators.createNotEmptyValidator((String)emptyVariableMsg));
            ChoicePropertyItem wAxisVarInstItem = new ChoicePropertyItem(W_AXIS_GROUP, "Instance", (ObservableValue)this.series.wAxisVariableInstanceProperty(), VarSeries3DEditPart.getInstances(this.series.getWAxisVariable()));
            wAxisVariableItem.valueProperty().addListener(o -> wAxisVarInstItem.setChoices(VarSeries3DEditPart.getInstances(this.series.getWAxisVariable())));
            this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{wAxisVariableItem, wAxisVarInstItem});
        }
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.part.setLabel(String.format("3D Series: %s", this.series.toString()));
        this.focus();
    }

    private static Collection<VariableInstance> getInstances(Variable var) {
        if (var == null) {
            return Collections.emptyList();
        }
        Transaction trx = Transactions.begin();
        try {
            List<VariableInstance> list = Arrays.asList(VariableInstanceDAO.getAll((Transaction)trx, (Variable)var, (boolean)true));
            return list;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.series.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)VarSeries3DDAO.saveOrUpdate((Transaction)trx, (VarSeries3D)this.series));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.series.toString());
                EnginPartUtils.refreshItems(this.series, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                DialogFactory.showExceptionDialog((String)"Save chart", (Exception)((Object)exc), (Window)this.sheet.getScene().getWindow());
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, Chart3D.class);
        this.part.setLabel(String.format("3D Series: %s", this.series.toString()));
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.series.getChart());
    }
}

