/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.charts.parts;

import de.elpro.ewms.core.charts.RendererType;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.YAxisLocation;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.ChartDAO;
import de.elpro.ewms.core.client.charts.YAxisDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.PhysicalUnitRegistry;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class YAxisEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.yaxis";
    @Inject
    private YAxis yAxis;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.yAxis.getId() != null) {
                this.yAxis = YAxisDAO.get((Transaction)trx, (int)this.yAxis.getId());
            }
            this.yAxis.setChart(ChartDAO.get((Transaction)trx, (int)this.yAxis.getChart().getId()));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.yAxis.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem chartItem = new ChoicePropertyItem("Chart", (ObservableValue)this.yAxis.chartProperty());
        EnumPropertyItem defaultRendererItem = new EnumPropertyItem("Default Renderer", RendererType.class, (ObservableValue)this.yAxis.defaultRendererTypeProperty());
        defaultRendererItem.setNullable(false);
        defaultRendererItem.setValidator(Validators.createNotEmptyValidator((String)"Default Renderer Type must be set"));
        LocaleStringPropertyItem titleItem = new LocaleStringPropertyItem("Title", (ObservableValue)this.yAxis.titleProperty());
        titleItem.setValidator(Validators.createNotEmptyValidator((String)"Title cannot be empty"));
        ChoicePropertyItem physicalUnitItem = new ChoicePropertyItem("Physical Unit", (ObservableValue)this.yAxis.physicalUnitProperty(), PhysicalUnitRegistry.getPhysicalUnits());
        physicalUnitItem.setNullable(false);
        physicalUnitItem.setValidator(Validators.createNotEmptyValidator((String)"Physical Untit must be set"));
        Collection availableUnits = new ArrayList();
        if (this.yAxis.getPhysicalUnit() != null) {
            availableUnits = this.yAxis.getPhysicalUnit().getMeasuringUnits();
        }
        ChoicePropertyItem measuringUnitItem = new ChoicePropertyItem("Default Measuring Unit", (ObservableValue)this.yAxis.defaultMeasuringUnitProperty(), availableUnits);
        this.yAxis.physicalUnitProperty().addListener((o, ov, nv) -> measuringUnitItem.setChoices(nv == null ? new ArrayList() : new ArrayList(nv.getMeasuringUnits())));
        EnumPropertyItem axisLocationItem = new EnumPropertyItem("Location", YAxisLocation.class, (ObservableValue)this.yAxis.axisLocationProperty());
        axisLocationItem.setNullable(false);
        PaintPropertyItem colorItem = new PaintPropertyItem("Color", (ObservableValue)this.yAxis.colorProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.yAxis.visualOrderPositionProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, chartItem, defaultRendererItem, titleItem, physicalUnitItem, measuringUnitItem, new SeparatorItem(), colorItem, axisLocationItem, visualOrderPositionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.focus();
    }

    public List<StructureObject> getAllowedParents(Transaction trx, StructureClass structureClass) {
        return Arrays.asList(StructureClassDAO.getAllowedParentObjects((Transaction)trx, (int)structureClass.getId()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.yAxis.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)YAxisDAO.saveOrUpdate((Transaction)trx, (YAxis)this.yAxis));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.yAxis.toString());
                EnginPartUtils.refreshItems(this.yAxis, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving Y-Axis");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, YAxis.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }

    @Focus
    public void focus() {
        MPart part = this.partService.findPart("de.elpro.ewms.engin.gui.bottom.preview");
        if (!part.getParent().equals(this.part.getParent())) {
            this.partService.showPart(part, EPartService.PartState.VISIBLE);
        }
        part.getContext().set("preview-object", (Object)this.yAxis.getChart());
    }
}

