/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.dataview.handlers;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.charts.ChartDAO;
import de.elpro.ewms.core.client.charts.ChartGroupDAO;
import de.elpro.ewms.core.client.charts.SankeyChartDAO;
import de.elpro.ewms.core.client.dataview.ViewNodeDAO;
import de.elpro.ewms.core.client.dataview.ViewPerspectiveDAO;
import de.elpro.ewms.core.client.graphs.GraphDefinitionDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.dataview.ViewPerspective;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.graph.GraphChart;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.engin.gui.navi.client.dataview.handlers.DataViewEditHandler;
import de.elpro.ewms.engin.gui.navi.model.INavigationTreeElement;
import de.elpro.ewms.engin.gui.navi.model.LazyNavigationContribution;
import de.elpro.ewms.gui.utils.e4.EOSPartUtils;
import de.elpro.ui.model.UIModelElement;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class CreateDataViewNaviHandler
extends LazyNavigationContribution<UIModelElement> {
    private Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> LIST_CREATOR = new Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>>(){

        @Override
        public List<TreeItem<UIModelElement>> apply(TreeItem<UIModelElement> item) {
            LinkedList<TreeItem<UIModelElement>> elements = new LinkedList<TreeItem<UIModelElement>>();
            Transaction trx = Transactions.begin();
            try {
                if (item.getValue() == null || item.getValue() instanceof INavigationTreeElement) {
                    elements.addAll(CreateDataViewNaviHandler.this.createLazyTreeItemCollection((UIModelElement[])ViewPerspectiveDAO.getAll((Transaction)trx)));
                } else if (item.getValue() instanceof ViewPerspective) {
                    ViewNode[] rootNodes;
                    ViewPerspective perspective = (ViewPerspective)item.getValue();
                    ViewNode[] viewNodeArray = rootNodes = ViewPerspectiveDAO.getRootNodes((Transaction)trx, (ViewPerspective)perspective);
                    int n = rootNodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewNode node = viewNodeArray[n2];
                        CreateDataViewNaviHandler.loadViewNode(trx, node);
                        ++n2;
                    }
                    elements.addAll(CreateDataViewNaviHandler.this.createLazyTreeItemCollection((UIModelElement[])rootNodes));
                } else if (item.getValue() instanceof ViewNode) {
                    ViewNode[] children;
                    ViewNode node = (ViewNode)item.getValue();
                    ViewNode[] viewNodeArray = children = ViewNodeDAO.getChildren((Transaction)trx, (ViewNode)node);
                    int n = children.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ViewNode child = viewNodeArray[n3];
                        CreateDataViewNaviHandler.loadViewNode(trx, child);
                        ++n3;
                    }
                    elements.addAll(CreateDataViewNaviHandler.this.createLazyTreeItemCollection((UIModelElement[])children));
                }
            }
            finally {
                Transactions.close((Transaction)trx);
            }
            return elements;
        }
    };
    @Inject
    private MApplication app;
    @Inject
    private EModelService modelService;

    private static void loadViewNode(Transaction trx, ViewNode node) {
        node.refreshReferenceObject();
        if (node.getDataClass() != null) {
            node.setDataClass(StructureClassDAO.get((Transaction)trx, (int)node.getDataClass().getId()));
        }
        if (node.getReferenceObject() != null) {
            if (node.getReferenceObject() instanceof Chart2D) {
                node.setReferenceObject((Object)ChartDAO.get((Transaction)trx, (int)node.getReferenceObjectId()));
            } else if (node.getReferenceObject() instanceof Chart3D) {
                node.setReferenceObject((Object)Chart3DDAO.get((Transaction)trx, (int)node.getReferenceObjectId()));
            } else if (node.getReferenceObject() instanceof SankeyChart) {
                node.setReferenceObject((Object)SankeyChartDAO.get((Transaction)trx, (int)node.getReferenceObjectId()));
            } else if (node.getReferenceObject() instanceof ChartGroup) {
                node.setReferenceObject((Object)ChartGroupDAO.get((Transaction)trx, (int)node.getReferenceObjectId()));
            } else if (node.getReferenceObject() instanceof Table) {
                node.setReferenceObject((Object)TableDAO.get((Transaction)trx, (int)node.getReferenceObjectId()));
            } else if (node.getReferenceObject() instanceof GraphChart) {
                node.setReferenceObject((Object)GraphDefinitionDAO.get((Transaction)trx, (int)node.getReferenceObjectId()));
            }
        }
    }

    @Override
    public Function<TreeItem<UIModelElement>, List<TreeItem<UIModelElement>>> getChildrenCreator() {
        return this.LIST_CREATOR;
    }

    @Execute
    public void execute() {
    }

    @Override
    public String getContextMenuId() {
        return "de.elpro.ewms.engin.gui.menu.navi.view";
    }

    @Override
    public void onTreeItemClick(Object sender, TreeItem<UIModelElement> treeItem) {
        new DataViewEditHandler().execute(this.app, treeItem);
    }

    @Override
    public void onTreeItemDoubleClick(Object sender, TreeItem<UIModelElement> treeItem) {
        EOSPartUtils.pinSelectedMPart((EModelService)this.modelService, (MApplication)this.app, (String)"de.elpro.ewms.engin.gui.partstack.editors");
    }
}

