/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.dataview.handlers;

import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.dataview.ViewPerspective;
import de.elpro.ewms.core.dataview.ViewType;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.model.UIModelElement;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;

public class CreateViewNodeHandler {
    @Execute
    public void execute(Scene scene, MApplication app, @Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<? extends UIModelElement> item) {
        ViewNode parentViewNode;
        ViewNode node = new ViewNode();
        if (item.getValue() instanceof ViewPerspective) {
            node.setPerspective((ViewPerspective)item.getValue());
            parentViewNode = null;
        } else {
            parentViewNode = (ViewNode)item.getValue();
            node.setParent(parentViewNode);
        }
        if (parentViewNode != null && !parentViewNode.isTreeItem()) {
            node.setTreeItem(false);
        } else if (parentViewNode != null && (parentViewNode.getViewType() == ViewType.SplitContainer || parentViewNode.getViewType() == ViewType.TabContainer)) {
            Alert questionDialog = new Alert(Alert.AlertType.INFORMATION, String.format("Add as %s content or navigation tree item?", parentViewNode.getViewType()), new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
            questionDialog.setHeaderText(String.format("Adding node to parent node of %s type.", parentViewNode.getViewType()));
            questionDialog.initOwner(scene.getWindow());
            ((Button)questionDialog.getDialogPane().lookupButton(ButtonType.YES)).setText(String.format("Add as %s content", parentViewNode.getViewType()));
            ((Button)questionDialog.getDialogPane().lookupButton(ButtonType.NO)).setText("Add as tree item");
            ButtonType btn = questionDialog.showAndWait().orElse(null);
            if (btn == ButtonType.YES) {
                node.setTreeItem(false);
            } else if (btn != ButtonType.NO) {
                return;
            }
        }
        EnginPartUtils.showCreatePart("de.elpro.ewms.engin.gui.partdescriptor.dataview.node", app, node, item);
    }

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") TreeItem<?> item) {
        return item != null && (item.getValue() instanceof ViewPerspective || item.getValue() instanceof ViewNode);
    }
}

