/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.dataview.parts;

import com.gluonhq.richtextarea.model.Document;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.charts.Chart3DDAO;
import de.elpro.ewms.core.client.charts.ChartDAO;
import de.elpro.ewms.core.client.charts.ChartGroupDAO;
import de.elpro.ewms.core.client.charts.SankeyChartDAO;
import de.elpro.ewms.core.client.dataview.ViewNodeDAO;
import de.elpro.ewms.core.client.dataview.ViewPerspectiveDAO;
import de.elpro.ewms.core.client.graphs.GraphDefinitionDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.tables.TableDAO;
import de.elpro.ewms.core.dataview.AutoTimeRangeType;
import de.elpro.ewms.core.dataview.ViewNode;
import de.elpro.ewms.core.dataview.ViewNodeDocumentPlacementPolicy;
import de.elpro.ewms.core.dataview.ViewNodeDocumentPosition;
import de.elpro.ewms.core.dataview.ViewPerspective;
import de.elpro.ewms.core.dataview.ViewType;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.editors.richtext.RichTextEditor;
import de.elpro.ewms.core.fx.propertysheet.IconKeyPropertyItem;
import de.elpro.ewms.core.graph.GraphChart;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.CustomEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.DoublePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class NodeEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.dataview.node";
    private static final String DOCUMENT_CATEGORY = "Document";
    @Inject
    private ViewNode node;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        StructureClass parentResultClass;
        Transaction trx = Transactions.begin();
        LinkedList<ViewPerspective> availablePerspectives = new LinkedList<ViewPerspective>();
        LinkedList<StructureClass> availableClasses = new LinkedList<StructureClass>();
        try {
            if (this.node.getId() != null) {
                this.node = ViewNodeDAO.get((Transaction)trx, (int)this.node.getId());
            }
            if (this.node.getPerspective() != null) {
                this.node.setPerspective(ViewPerspectiveDAO.get((Transaction)trx, (int)this.node.getPerspective().getId()));
            }
            availablePerspectives.addAll(Arrays.asList(ViewPerspectiveDAO.getAll((Transaction)trx)));
            if (this.node.getParent() != null) {
                ViewNode parentNode = ViewNodeDAO.get((Transaction)trx, (int)this.node.getParent().getId());
                this.node.setParent(parentNode);
                StructureClass parentClass = this.node.getParent().getDataClass();
                if (parentClass != null) {
                    parentNode.setDataClass(StructureClassDAO.get((Transaction)trx, (int)parentClass.getId()));
                }
                while (parentClass == null) {
                    parentNode = ViewNodeDAO.get((Transaction)trx, (int)parentNode.getParent().getId());
                    parentClass = parentNode.getDataClass();
                }
                parentResultClass = StructureClassDAO.get((Transaction)trx, (int)parentClass.getId());
            } else {
                parentResultClass = null;
            }
            if (this.node.getDataClass() != null) {
                this.node.setDataClass(StructureClassDAO.get((Transaction)trx, (int)this.node.getDataClass().getId()));
            }
            if (this.node.getViewType() == ViewType.Chart2D && this.node.getReferenceObject() != null) {
                this.node.setReferenceObject((Object)ChartDAO.get((Transaction)trx, (int)this.node.getReferenceObjectId()));
            }
            StructureClass[] structureClassArray = StructureClassDAO.getAll((Transaction)trx);
            int n = structureClassArray.length;
            int parentClass = 0;
            while (parentClass < n) {
                StructureClass structureClass = structureClassArray[parentClass];
                availableClasses.add(structureClass);
                ++parentClass;
            }
            this.node.refreshReferenceObject();
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.node.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem perspectiveItem = new ChoicePropertyItem("Perspective", (ObservableValue)this.node.viewPerspectiveProperty(), availablePerspectives);
        perspectiveItem.setValidator(Validators.createValidator((o, ov, nv) -> this.node.getParent() != null && this.node.getPerspective() == null || this.node.getParent() == null && this.node.getPerspective() != null, (String)"Root Nodes should be assignet do Perspective"));
        ChoicePropertyItem parentItem = new ChoicePropertyItem("Parent Node", (ObservableValue)this.node.parentNodeProperty(), this.node.getPerspective() != null ? List.of() : List.of(this.node.getParent()));
        parentItem.setValidator(Validators.createValidator((o, ov, nv) -> this.node.getParent() != null && this.node.getPerspective() == null || this.node.getParent() == null && this.node.getPerspective() != null, (String)"Root Nodes should be assignet do Perspective"));
        BooleanPropertyItem isEnablePropertyItem = new BooleanPropertyItem("Enable", (ReadOnlyProperty)this.node.enabledProperty());
        BooleanPropertyItem isTreeItemPropertyItem = new BooleanPropertyItem("Is Tree Item", (ReadOnlyProperty)this.node.isTreeItemProperty());
        ChoicePropertyItem dataClassItem = new ChoicePropertyItem("Data Class", (ObservableValue)this.node.dataClassProperty(), availableClasses);
        dataClassItem.setValidator(Validators.createValidator((o, ov, nv) -> this.node.getParent() != null || this.node.getDataClass() != null, (String)"Root Nodes must define data class"));
        if (this.node.getParent() != null) {
            dataClassItem.setPromptText(String.format("Same as parent data class: %s", parentResultClass));
        }
        ChoicePropertyItem dataObjectItem = new ChoicePropertyItem("Data Object", (ObservableValue)this.node.dataObjectProperty(), this.getAvailableDataObjects(parentResultClass));
        dataObjectItem.setPromptText("Static Data Object Reference");
        EnumPropertyItem dataObjectSearchPolicyItem = new EnumPropertyItem("Object Search Policy", SearchPolicy.class, (ObservableValue)this.node.dataObjectSearchPolicyProperty());
        this.node.dataClassProperty().addListener(il -> dataObjectItem.setChoices(this.getAvailableDataObjects(parentResultClass)));
        if (this.node.getParent() != null && !this.node.getParent().isTreeItem()) {
            this.node.setTreeItem(false);
            isTreeItemPropertyItem.setReadOnly(true);
        }
        if (this.node.getParent() == null) {
            this.node.setTreeItem(true);
            isTreeItemPropertyItem.setReadOnly(true);
        }
        InvalidationListener isTreeItemInvalidationListener = l -> {};
        this.node.isTreeItemProperty().addListener(isTreeItemInvalidationListener);
        isTreeItemInvalidationListener.invalidated(null);
        EnumPropertyItem viewTypeItem = new EnumPropertyItem("View Type", ViewType.class, (ObservableValue)new SimpleObjectProperty((Object)this.node.getViewType()));
        viewTypeItem.setNullable(false);
        ChoicePropertyItem referenceObjectItem = new ChoicePropertyItem("Reference Object", (ObservableValue)this.node.referenceObjectProperty(), this.getAvailableReferenceObjects(parentResultClass));
        referenceObjectItem.setValidator(Validators.createValidator((o, ov, nv) -> nv != null || nv == null && this.node.getViewType() != ViewType.Chart2D && this.node.getViewType() != ViewType.Chart3D && this.node.getViewType() != ViewType.SankeyChart && this.node.getViewType() != ViewType.ChartGroup && this.node.getViewType() != ViewType.Table && this.node.getViewType() != ViewType.Report && this.node.getViewType() != ViewType.GraphChart, (String)"Rererence Object must be selected"));
        BooleanPropertyItem autoTimeRangeItem = new BooleanPropertyItem("Auto Time-Range", (ReadOnlyProperty)this.node.autoTimeRangeProperty());
        EnumPropertyItem autoTimeRangeTypeItem = new EnumPropertyItem("Auto Time-Range Type", AutoTimeRangeType.class, (ObservableValue)this.node.autoTimeRangeTypeProperty());
        autoTimeRangeTypeItem.setNullable(false);
        autoTimeRangeItem.valueProperty().addListener(o -> autoTimeRangeTypeItem.setHidden(this.node.getViewType() == ViewType.Empty || !this.node.isAutoTimeRange()));
        Runnable refreshRefObjectsListener = () -> {
            referenceObjectItem.setChoices(this.getAvailableReferenceObjects(parentResultClass));
            referenceObjectItem.forceValidate();
        };
        dataObjectItem.valueProperty().addListener(il -> refreshRefObjectsListener.run());
        viewTypeItem.valueProperty().addListener(il -> {
            this.node.setReferenceObjectId(null);
            this.node.setViewType((ViewType)viewTypeItem.getValue());
            refreshRefObjectsListener.run();
        });
        StringPropertyItem partDescriptorIdItem = new StringPropertyItem("PartDescriptor ID", (ObservableValue)this.node.partDescriptorIdProperty());
        partDescriptorIdItem.setValidator(Validators.createValidator((o, ov, nv) -> {
            if (this.node.getViewType() != ViewType.Part) {
                return true;
            }
            return nv != null && !((String)nv).isBlank();
        }, (String)"PartDescriptor ID must be specified"));
        EnumPropertyItem splitContainerOrientationItem = new EnumPropertyItem("Container Orientation", Orientation.class, (ObservableValue)this.node.splitContainerOrientationProperty());
        splitContainerOrientationItem.setValidator(Validators.createValidator((o, ov, nv) -> this.node.getViewType() != ViewType.SplitContainer || nv != null, (String)"Orientation must be not empty"));
        splitContainerOrientationItem.setNullable(false);
        StringPropertyItem splitContainerDataItem = new StringPropertyItem("Container Data", (ObservableValue)this.node.splitContainerDataProperty());
        splitContainerDataItem.setPromptText("Spliter position, e.g.: 35|20|45");
        BooleanPropertyItem splitContainerFixedItem = new BooleanPropertyItem("Container Fixed", (ReadOnlyProperty)this.node.isSplitContainerFixedProperty());
        IconKeyPropertyItem customIconKeyItem = new IconKeyPropertyItem("Custom Icon", (ObservableValue)this.node.customIconKeyProperty(), "ewms/icons/dataview/node");
        LocaleStringPropertyItem customNameItem = new LocaleStringPropertyItem("Custom Name", (ObservableValue)this.node.customNameProperty());
        InvalidationListener hideNodesListener = l -> {
            ViewType type = this.node.getViewType();
            referenceObjectItem.setHidden(type != ViewType.Chart2D && type != ViewType.Chart3D && type != ViewType.ChartGroup && type != ViewType.Table && type != ViewType.SankeyChart && type != ViewType.GraphChart);
            splitContainerOrientationItem.setHidden(type != ViewType.SplitContainer);
            splitContainerDataItem.setHidden(type != ViewType.SplitContainer);
            splitContainerFixedItem.setHidden(type != ViewType.SplitContainer);
            autoTimeRangeItem.setHidden(type == ViewType.Empty);
            autoTimeRangeTypeItem.setHidden(type == ViewType.Empty || !this.node.isAutoTimeRange());
            partDescriptorIdItem.setHidden(type != ViewType.Part);
            partDescriptorIdItem.forceValidate();
            splitContainerOrientationItem.forceValidate();
        };
        hideNodesListener.invalidated(null);
        this.node.viewTypeProperty().addListener(hideNodesListener);
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual order position", (ObservableValue)this.node.visualOrderPositionProperty());
        StringPropertyItem viewProperties = new StringPropertyItem("Properties", (ObservableValue)this.node.viewPropertiesProperty());
        viewProperties.useAreaEditor(true);
        perspectiveItem.valueProperty().addListener(il -> {
            if (this.node.getPerspective() != null) {
                this.node.setParent(null);
            }
            parentItem.forceValidate();
        });
        parentItem.valueProperty().addListener(il -> {
            if (this.node.getParent() != null) {
                this.node.setPerspective(null);
            }
            perspectiveItem.forceValidate();
            dataClassItem.forceValidate();
        });
        BooleanPropertyItem showDocumentItem = new BooleanPropertyItem(DOCUMENT_CATEGORY, "Show", (ReadOnlyProperty)this.node.showDocumentProperty());
        EnumPropertyItem documentPositionItem = new EnumPropertyItem(DOCUMENT_CATEGORY, "Position", ViewNodeDocumentPosition.class, (ObservableValue)this.node.documentPositionProperty());
        EnumPropertyItem documentPlacementPolicyItem = new EnumPropertyItem(DOCUMENT_CATEGORY, "Placement Policy", ViewNodeDocumentPlacementPolicy.class, (ObservableValue)this.node.documentPlacementPolicyProperty());
        DoublePropertyItem documentPreferedWidthItem = new DoublePropertyItem(DOCUMENT_CATEGORY, "Prefered Width", (ObservableValue)this.node.documentPreferedWidthProperty());
        documentPreferedWidthItem.setPositiveOnly(true);
        DoublePropertyItem documentPreferedHeightItem = new DoublePropertyItem(DOCUMENT_CATEGORY, "Prefered Height", (ObservableValue)this.node.documentPreferedHeightProperty());
        documentPreferedHeightItem.setPositiveOnly(true);
        CustomEditorPropertyItem documentItem = new CustomEditorPropertyItem(DOCUMENT_CATEGORY, DOCUMENT_CATEGORY, null, (ObservableValue)this.node.documentProperty());
        RichTextEditor documentEditor = new RichTextEditor();
        documentEditor.getEditor().setAutoSave(true);
        documentEditor.getEditor().setDocument(this.node.getDocument() != null ? this.node.getDocument() : new Document());
        documentEditor.getEditor().documentProperty().addListener((o, ov, nv) -> this.node.setDocument(nv));
        documentItem.setEditor((Node)documentEditor);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, perspectiveItem, parentItem, isEnablePropertyItem, isTreeItemPropertyItem, dataClassItem, dataObjectItem, dataObjectSearchPolicyItem, new SeparatorItem(), viewTypeItem, referenceObjectItem, partDescriptorIdItem, autoTimeRangeItem, autoTimeRangeTypeItem, splitContainerOrientationItem, splitContainerDataItem, splitContainerFixedItem, customIconKeyItem, customNameItem, visualOrderPositionItem, viewProperties, showDocumentItem, documentPositionItem, documentPlacementPolicyItem, documentPreferedWidthItem, documentPreferedHeightItem, documentItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    private Collection<StructureObject> getAvailableDataObjects(StructureClass parentResultClass) {
        StructureClass referenceClass;
        StructureClass structureClass = referenceClass = this.node.getDataClass() != null ? this.node.getDataClass() : parentResultClass;
        if (referenceClass == null) {
            return Collections.emptyList();
        }
        Transaction trx = Transactions.begin();
        try {
            List<StructureObject> list = Arrays.asList(StructureClassDAO.getAllObjects((Transaction)trx, (int)referenceClass.getId()));
            return list;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private Collection<Object> getAvailableReferenceObjects(StructureClass parentResultClass) {
        LinkedList<Object> objects = new LinkedList<Object>();
        if (this.node.getDataClass() == null && this.node.getParent() == null) {
            return objects;
        }
        StructureClass structureClass = this.node.getDataClass() != null ? this.node.getDataClass() : parentResultClass;
        switch (this.node.getViewType()) {
            case Chart2D: {
                Transaction trx = Transactions.begin();
                try {
                    Chart2D[] chart2DArray = ChartDAO.findByClass((Transaction)trx, (StructureClass)structureClass);
                    int n = chart2DArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Chart2D chart = chart2DArray[n2];
                        objects.add(chart);
                        ++n2;
                    }
                    break;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            case Chart3D: {
                Transaction trx = Transactions.begin();
                try {
                    Chart3D[] chart3DArray = Chart3DDAO.getAll((Transaction)trx);
                    int n = chart3DArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Chart3D chart = chart3DArray[n3];
                        objects.add(chart);
                        ++n3;
                    }
                    break;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            case SankeyChart: {
                Transaction trx = Transactions.begin();
                try {
                    SankeyChart[] sankeyChartArray = SankeyChartDAO.findByClass((Transaction)trx, (StructureClass)structureClass);
                    int n = sankeyChartArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        SankeyChart chart = sankeyChartArray[n4];
                        objects.add(chart);
                        ++n4;
                    }
                    break;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            case ChartGroup: {
                Transaction trx = Transactions.begin();
                try {
                    ChartGroup[] chartGroupArray = ChartGroupDAO.getAll((Transaction)trx);
                    int n = chartGroupArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        ChartGroup chartGroup = chartGroupArray[n5];
                        objects.add(chartGroup);
                        ++n5;
                    }
                    break;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            case Table: {
                Transaction trx = Transactions.begin();
                try {
                    Table[] tableArray = TableDAO.findByClass((Transaction)trx, (StructureClass)structureClass);
                    int n = tableArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        Table table = tableArray[n6];
                        objects.add(table);
                        ++n6;
                    }
                    break;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
            case GraphChart: {
                Transaction trx = Transactions.begin();
                try {
                    GraphChart[] graphChartArray = GraphDefinitionDAO.getAll((Transaction)trx);
                    int n = graphChartArray.length;
                    int n7 = 0;
                    while (n7 < n) {
                        GraphChart graph = graphChartArray[n7];
                        objects.add(graph);
                        ++n7;
                    }
                    break;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        }
        return objects;
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.node.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ViewNodeDAO.saveOrUpdate((Transaction)trx, (ViewNode)this.node));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.node.toString());
                EnginPartUtils.refreshItems(this.node, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving view perspective");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ChartGroup.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

