/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.dataview.parts;

import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.dataview.ViewPerspectiveDAO;
import de.elpro.ewms.core.dataview.ViewPerspective;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class PerspectiveEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.dataview.perspective";
    @Inject
    private ViewPerspective perspective;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private final PropertySheet sheet = new PropertySheet();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private NumberPropertyItem<Integer> idItem;

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        Transaction trx = Transactions.begin();
        try {
            if (this.perspective.getId() != null) {
                this.perspective = ViewPerspectiveDAO.get((Transaction)trx, (int)this.perspective.getId());
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.perspective.idProperty());
        this.idItem.setReadOnly(true);
        StringPropertyItem targetPartStackItem = new StringPropertyItem("Target Part Stack ID", (ObservableValue)this.perspective.targetPartStackIdProperty());
        targetPartStackItem.setPromptText("Monitoring Target Stack: de.elpro.ewms.monitoring.gui.partstack.left");
        targetPartStackItem.setValidator(Validators.createNotEmptyValidator((String)"Target Part Stack ID must be specified."));
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.perspective.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Name cannot be empty"));
        StringPropertyItem iconUriItem = new StringPropertyItem("Icon URI", (ObservableValue)this.perspective.iconProperty());
        IntegerPropertyItem visualOrderPositionItem = new IntegerPropertyItem("Visual Order Position", (ObservableValue)this.perspective.visualOrderPositionProperty());
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, targetPartStackItem, nameItem, iconUriItem, visualOrderPositionItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        this.sheet.setMode(PropertySheet.Mode.CATEGORY);
        parent.setCenter((Node)this.sheet);
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.perspective.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)ViewPerspectiveDAO.saveOrUpdate((Transaction)trx, (ViewPerspective)this.perspective));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.perspective.toString());
                EnginPartUtils.refreshItems(this.perspective, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving view perspective");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ChartGroup.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

