/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.engin.gui.navi.client.graph.parts;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.graphs.GraphDefinitionDAO;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.graph.GraphChartView;
import de.elpro.ewms.core.graph.GraphChart;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.engin.gui.services.EnginPartUtils;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.IntegerPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.NumberPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import de.elpro.ui.utils.e4.PartUtils;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;

public class GraphEditPart {
    public static final String ID = "de.elpro.ewms.engin.gui.partdescriptor.graphs.graph";
    @Log
    @Inject
    private Logger logger;
    @Inject
    private GraphChart graphDefinition;
    @Inject
    private MPart part;
    @Inject
    private EPartService partService;
    private ITimeRangeFilter timeRangeFilter;
    private GraphChartView graphView;
    private final PropertySheet sheet = new PropertySheet();
    private final BooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final BooleanProperty hasErrors = new SimpleBooleanProperty(false);
    private final ObjectProperty<StructureObject> graphRootObject = new SimpleObjectProperty();
    private final ObservableList<StructureObject> graphRootObjects = FXCollections.observableArrayList();
    private NumberPropertyItem<Integer> idItem;
    private final ComboBox<StructureObject> graphRootObjectCB = new ComboBox(this.graphRootObjects);
    private final BorderPane center = new BorderPane();

    @PostConstruct
    public void postConstruct(BorderPane parent, ITimeRangeFilter timeRangeFilter) {
        LinkedList<StructureClass> allClasses = new LinkedList<StructureClass>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Transaction trx = Transactions.begin();){
            if (this.graphDefinition.getId() != null) {
                this.graphDefinition = GraphDefinitionDAO.get((Transaction)trx, (int)this.graphDefinition.getId());
            }
            StructureClass[] structureClassArray = StructureClassDAO.getAll((Transaction)trx);
            int n = structureClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureClass clazz = structureClassArray[n2];
                allClasses.add(clazz);
                ++n2;
            }
            if (this.graphDefinition.getStructureClass() != null) {
                this.graphRootObjects.addAll(StructureClassDAO.getAllObjects((StructureClass)this.graphDefinition.getStructureClass()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.idItem = new IntegerPropertyItem("Id", (ObservableValue)this.graphDefinition.idProperty());
        this.idItem.setReadOnly(true);
        ChoicePropertyItem structureClassItem = new ChoicePropertyItem("Structure Class", (ObservableValue)this.graphDefinition.structureClassProperty(), allClasses);
        structureClassItem.setValidator(Validators.createNotEmptyValidator((String)"Structure Class must be not empty"));
        structureClassItem.setNullable(false);
        structureClassItem.valueProperty().addListener(il -> this.updateRootObjectChoices());
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem("Name", (ObservableValue)this.graphDefinition.nameProperty());
        nameItem.setValidator(Validators.createNotEmptyValidator((String)"Cannot be empty"));
        StringPropertyItem defItem = new StringPropertyItem("Definition", (ObservableValue)this.graphDefinition.definitionProperty());
        defItem.setHidden(true);
        this.sheet.getItems().addAll((Object[])new PropertySheet.Item[]{this.idItem, structureClassItem, nameItem, defItem, new SeparatorItem()});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)this.sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)this.sheet.getItems()));
        parent.setTop((Node)this.sheet);
        parent.setCenter((Node)this.center);
        HBox choiceBox = new HBox(10.0, new Node[]{new Label("For Root Object:\t"), this.graphRootObjectCB});
        choiceBox.setPadding(new Insets(0.0, 10.0, 10.0, 10.0));
        choiceBox.setAlignment(Pos.CENTER_LEFT);
        this.center.setTop((Node)choiceBox);
        this.center.setPadding(new Insets(10.0));
        this.hasChanges.addListener((o, ov, nv) -> this.part.setDirty(nv.booleanValue()));
        this.graphRootObjectCB.setCellFactory(cf -> new UIModelListCell());
        this.graphRootObjectCB.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> this.updateGraphRootObject((StructureObject)nv));
        if (!this.graphRootObjects.isEmpty()) {
            this.graphRootObjectCB.getSelectionModel().select((Object)((StructureObject)this.graphRootObjects.get(0)));
        }
    }

    private void updateRootObjectChoices() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Transaction trx = Transactions.begin();){
            this.graphRootObjects.setAll(StructureClassDAO.getAllObjects((StructureClass)this.graphDefinition.getStructureClass()));
            if (!this.graphRootObjects.contains(this.graphRootObjectCB.getSelectionModel().getSelectedItem())) {
                if (this.graphRootObjects.isEmpty()) {
                    this.graphRootObjectCB.getSelectionModel().clearSelection();
                } else {
                    this.graphRootObjectCB.getSelectionModel().select((Object)((StructureObject)this.graphRootObjects.get(0)));
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateGraphRootObject(StructureObject rootObject) {
        if (rootObject == null) {
            this.graphView = null;
            this.center.setCenter(null);
        } else {
            this.graphView = new GraphChartView(rootObject, this.graphDefinition, this.timeRangeFilter);
            this.graphView.jsonViewProperty().addListener((o, ov, nv) -> this.graphDefinition.setDefinition(nv));
            this.center.setCenter((Node)this.graphView);
        }
    }

    @Inject
    private void setTimeRangeFilter(ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        if (this.graphView != null) {
            this.graphView.loadData(timeRangeFilter);
        }
    }

    @Persist
    public void save() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format("Cannot save %s. Fix errors first.", this.graphDefinition.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.idItem.setValue((Object)GraphDefinitionDAO.saveOrUpdate((Transaction)trx, (GraphChart)this.graphDefinition));
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties((Collection)this.sheet.getItems());
                this.part.setDirty(false);
                this.part.setLabel(this.graphDefinition.toString());
                EnginPartUtils.refreshItems(this.graphDefinition, this.part);
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.setContentText("Error saving locale definition");
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PartUtils.refreshParts((EPartService)this.partService, ColumnGroup.class);
    }

    @PreDestroy
    protected void close() {
        this.part.setDirty(false);
    }
}

